/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.comm;

import com.gc5.comm.Msg;
import com.gc5.comm.SoxClient;
import com.gc5.comm.SoxMsg;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import sedona.Buf;
import sedona.Env;
import sedona.sox.SoxFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileTransfer {
    SoxClient client;
    SoxClient.TransferListener listener;
    String uri;
    SoxFile file;
    String method;
    int fileSize;
    int offset;
    int chunkSize;
    int numChunks;
    int transferedChunks;
    Properties reqHeaders;
    Properties resHeaders;
    long startTicks;
    long lastReceiveTicks;
    boolean closeReceived;
    Object lock;
    volatile boolean opened;
    final LinkedList chunkQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getFile() throws Exception {
        Properties properties;
        this.file.open("w");
        try {
            this.doGetFile();
            properties = this.resHeaders;
            Object var2_2 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.file.close();
            throw throwable;
        }
        this.file.close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doGetFile() throws Exception {
        this.method = "g";
        this.fileSize = FileTransfer.geti(this.reqHeaders, "fileSize", 0);
        this.start();
        this.lastReceiveTicks = Env.ticks();
        Object object = this.lock;
        synchronized (object) {
            this.receiveChunk(null);
            while (this.transferedChunks < this.numChunks) {
                if (this.client.session() == null) {
                    throw new IOException("file transfer session disconnected");
                }
                if (Env.ticks() - this.lastReceiveTicks > this.client.session().receiveTimeout()) {
                    throw new IOException("file transfer timed out");
                }
                try {
                    this.lock.wait(1000L);
                }
                catch (Exception exception) {}
            }
        }
        SoxMsg soxMsg = SoxMsg.prepareReq(122);
        SoxMsg soxMsg2 = this.client.request(soxMsg);
        soxMsg2.checkResponse(90);
        this.progress();
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receiveChunk(SoxMsg soxMsg) {
        try {
            if (soxMsg != null) {
                this.chunkQueue.add(soxMsg);
            }
            if (!this.opened) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                while (true) {
                    if (this.chunkQueue.isEmpty()) {
                        this.lock.notifyAll();
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 6, 9] lbl18 : MonitorExitStatement: MONITOREXIT : var2_2
                        this.progress();
                        return;
                    }
                    soxMsg = (SoxMsg)((Object)this.chunkQueue.remove(0));
                    int n = soxMsg.u1();
                    int n2 = soxMsg.u1();
                    int n3 = soxMsg.u2();
                    int n4 = soxMsg.u2();
                    this.lastReceiveTicks = Env.ticks();
                    if (n != 107) {
                        System.out.println("WARNING: This code is hosed up " + (char)n);
                        return;
                    }
                    if (n3 >= this.numChunks) {
                        System.out.println("WARNING: Received received out of range chunk " + n3 + " >= " + this.numChunks);
                        return;
                    }
                    ++this.transferedChunks;
                    this.file.write(n3 * this.chunkSize, (Buf)soxMsg, n4);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties putFile() throws Exception {
        Properties properties;
        this.file.open("r");
        try {
            this.doPutFile();
            properties = this.resHeaders;
            Object var2_2 = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.file.close();
            throw throwable;
        }
        this.file.close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void doPutFile() throws Exception {
        this.method = "p";
        this.fileSize = FileTransfer.geti(this.reqHeaders, "fileSize", this.file.size());
        this.start();
        int n = 0;
        while (n < this.numChunks || n == 0 && this.numChunks == 0) {
            this.sendChunk(n);
            ++this.transferedChunks;
            this.progress();
            ++n;
        }
        long l = Env.ticks();
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                if (this.closeReceived) {
                    // MONITOREXIT @DISABLED, blocks:[2, 6, 9] lbl21 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.progress();
                    this.done();
                    return;
                }
                if (this.client.session() == null) {
                    throw new IOException("file transfer session disconnected");
                }
                if (Env.ticks() - l > this.client.session().receiveTimeout()) {
                    throw new IOException("file transfer timed out waiting for put close");
                }
                try {
                    this.lock.wait(1000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void sendChunk(int n) throws Exception {
        int n2 = this.chunkSize;
        if (n == this.numChunks - 1) {
            if (this.fileSize % this.chunkSize > 0) {
                n2 = this.fileSize % this.chunkSize;
            } else if (this.fileSize == 0) {
                n2 = 0;
            }
        }
        SoxMsg soxMsg = SoxMsg.prepareReq(107, 0);
        soxMsg.u2(n);
        soxMsg.u2(n2);
        this.file.read(n * this.chunkSize, (Buf)soxMsg, n2);
        this.client.send(soxMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void receiveClose(SoxMsg soxMsg) {
        Object object = this.lock;
        synchronized (object) {
            this.closeReceived = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            block8: {
                String string;
                Object object2;
                this.opened = false;
                this.chunkQueue.clear();
                SoxMsg soxMsg = SoxMsg.prepareReq(102);
                soxMsg.str(this.method);
                soxMsg.str(this.uri);
                soxMsg.i4(this.fileSize);
                soxMsg.u2(this.chunkSize);
                Iterator<Object> iterator = this.reqHeaders.keySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) break;
                    object2 = (String)iterator.next();
                    if (((String)object2).equals("fileSize")) continue;
                    string = (String)this.reqHeaders.get(object2);
                    soxMsg.str((String)object2);
                    soxMsg.str(string);
                }
                soxMsg.u1(0);
                object2 = this.client.request(soxMsg);
                ((Msg)((Object)object2)).checkResponse(70);
                this.fileSize = object2.i4();
                this.chunkSize = object2.u2();
                this.resHeaders = new Properties();
                while (true) {
                    if ((string = object2.str()).equals("")) {
                        this.resHeaders.put("fileSize", "" + this.fileSize);
                        this.resHeaders.put("chunkSize", "" + this.chunkSize);
                        this.numChunks = this.fileSize / this.chunkSize;
                        if (this.fileSize % this.chunkSize > 0) {
                            break;
                        }
                        break block8;
                    }
                    String string2 = object2.str();
                    this.resHeaders.put(string, string2);
                }
                ++this.numChunks;
            }
            if (this.numChunks == 0 && this.method.equals("p")) {
                this.numChunks = 1;
            }
            this.transferedChunks = 0;
            this.opened = true;
            return;
        }
    }

    static int geti(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    static boolean getb(Properties properties, String string, boolean bl) {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.equals("true");
    }

    private final void progress() {
        if (this.listener == null) {
            return;
        }
        try {
            this.listener.progress(this.transferedChunks * this.chunkSize, this.fileSize);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private final void done() {
        long l = Env.ticks() - this.startTicks;
        if (!this.client.traceXferStats) {
            return;
        }
        System.out.println();
        System.out.println("Done [" + this.uri + ']');
        System.out.println("  duration:    " + l + "ms");
        System.out.println("  fileSize:    " + this.fileSize + " bytes");
        System.out.println("  chunkSize:   " + this.chunkSize + " bytes");
        System.out.println("  numChunks:   " + this.numChunks);
        System.out.println();
    }

    private final /* synthetic */ void this() {
        this.chunkQueue = new LinkedList();
    }

    FileTransfer(SoxClient soxClient, String string, SoxFile soxFile, Properties properties, SoxClient.TransferListener transferListener) {
        this.this();
        if (properties == null) {
            properties = new Properties();
        }
        int n = soxClient.session().idealMax() - 18;
        this.client = soxClient;
        this.listener = transferListener;
        this.uri = string;
        this.file = soxFile;
        this.reqHeaders = properties;
        this.offset = FileTransfer.geti(properties, "offset", 0);
        this.chunkSize = FileTransfer.geti(properties, "chunkSize", n);
        this.lock = new Object();
        this.startTicks = Env.ticks();
    }
}

