/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.comm;

import com.gc5.BIsmaSoxDevice;
import com.gc5.comm.SoxMsg;
import com.gc5.comm.SoxSocket;
import com.gc5.comm.SoxTransaction;
import com.gc5.comm.SoxTransactionManager;
import com.gc5.core.BIsmaSoxAddress;
import com.gc5.core.BIsmaSoxCommunicator;
import com.gc5.util.ByteArrayUtil;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BajaRuntimeException;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspSession;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SoxComm {
    Hashtable dsHash;
    SoxSocket socket;
    BIsmaSoxCommunicator communicator;
    SoxTransactionManager transMgr;
    boolean commStarted;
    boolean done;
    SoxReceiveDriver rcvDriver;
    Thread rcvThread;
    SoxConnect soxConnect;
    Thread soxThread;
    Hashtable clients;

    public static SoxComm make(BIsmaSoxCommunicator bIsmaSoxCommunicator) {
        return new SoxComm(bIsmaSoxCommunicator);
    }

    public void start() throws Exception {
        this.transMgr.start();
        this.socket = new SoxSocket(-1, null, 13);
        this.rcvDriver = new SoxReceiveDriver(this.socket);
        this.rcvThread = new Thread((Runnable)this.rcvDriver, "SoxRcvDriver:" + this.communicator.getParent().getName());
        this.rcvThread.start();
        this.rcvThread.setPriority(5);
        this.soxConnect = new SoxConnect();
        this.soxThread = new Thread((Runnable)this.soxConnect, "SoxConnect:" + this.communicator.getParent().getName());
        this.soxThread.start();
        this.soxThread.setPriority(5);
        this.commStarted = true;
        this.getSession((BIsmaSoxDevice)this.communicator.getParent());
    }

    public void stop() throws Exception {
        this.done = true;
        if (this.rcvThread != null) {
            this.rcvDriver.stop();
            this.rcvThread.interrupt();
        }
        if (this.soxThread != null) {
            this.soxConnect.stop();
            this.soxThread.interrupt();
        }
        this.transMgr.stop();
        this.socket.close();
        this.commStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public SoxMsg sendRequest(BIsmaSoxDevice bIsmaSoxDevice, SoxMsg soxMsg) throws Exception {
        Object object;
        if (!this.commStarted) {
            throw new BajaRuntimeException("SoxComm not started.");
        }
        SoxTransaction soxTransaction = this.transMgr.getTransaction();
        soxTransaction.outgoingMessage = soxMsg;
        soxMsg.setReplyNum(soxTransaction.tag);
        soxMsg.device = bIsmaSoxDevice;
        int n = (int)this.communicator.getRetryTime().getMillis();
        int n2 = this.communicator.getRetryCount();
        int n3 = 0;
        while (n3 <= n2) {
            object = soxTransaction;
            // MONITORENTER : object
            {
                this.transMgr.schedule(soxTransaction, n);
                DaspSession daspSession = this.getSession(bIsmaSoxDevice);
                if (daspSession == null) {
                    throw new BajaRuntimeException("No Session for " + bIsmaSoxDevice.getName());
                }
                this.writeLinkDebug("~send" + n3 + ':', bIsmaSoxDevice.getAddress(), soxMsg.bytes, soxMsg.size);
                daspSession.send(soxMsg.bytes, 0, soxMsg.size);
                try {
                    soxTransaction.wait();
                }
                catch (InterruptedException interruptedException) {}
                if (soxTransaction.responseMessage != null) {
                    // MONITOREXIT : object
                    break;
                }
                ++n3;
            }
        }
        SoxMsg soxMsg2 = soxTransaction.responseMessage;
        object = soxTransaction.exception;
        this.transMgr.freeTransaction(soxTransaction);
        if (soxMsg2 != null) return soxMsg2;
        if (object == null) return soxMsg2;
        throw object;
    }

    public void sendResponse(BIsmaSoxDevice bIsmaSoxDevice, SoxMsg soxMsg) throws Exception {
        if (!this.commStarted) {
            throw new BajaRuntimeException("SoxComm not started.");
        }
        DaspSession daspSession = this.getSession(bIsmaSoxDevice);
        if (daspSession == null) {
            throw new BajaRuntimeException("No Session for " + bIsmaSoxDevice.getName());
        }
        this.writeLinkDebug("~send:", bIsmaSoxDevice.getAddress(), soxMsg.bytes, soxMsg.size);
        daspSession.send(soxMsg.bytes, 0, soxMsg.size);
    }

    public void receiveSoxMessage(SoxMsg soxMsg) {
        if (soxMsg.isRequest()) {
            this.handleUnsolicited(soxMsg);
        } else {
            this.handleResponse(soxMsg);
        }
    }

    public DaspSession getSession(BIsmaSoxDevice bIsmaSoxDevice) {
        DaspSession daspSession = (DaspSession)this.dsHash.get((Object)bIsmaSoxDevice.getAddress());
        if (daspSession != null) {
            if (!daspSession.isClosed()) {
                return daspSession;
            }
            this.dsHash.remove((Object)bIsmaSoxDevice.getAddress());
        }
        if (this.socket.socket.isClosed()) {
            bIsmaSoxDevice.pingFail("Socket is closed.");
            return null;
        }
        this.soxConnect.connectDevice(bIsmaSoxDevice);
        return null;
    }

    public void endSession(BIsmaSoxDevice bIsmaSoxDevice) {
        this.soxConnect.disconnectDevice(bIsmaSoxDevice);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handleResponse(SoxMsg soxMsg) {
        int n = soxMsg.replyNum() & 0xFF;
        SoxTransaction soxTransaction = this.transMgr.getTransactionMatch(n);
        if (soxTransaction == null) {
            return;
        }
        SoxTransaction soxTransaction2 = soxTransaction;
        synchronized (soxTransaction2) {
            soxTransaction.responseMessage = soxMsg;
            soxTransaction.notify();
            return;
        }
    }

    private final void handleUnsolicited(SoxMsg soxMsg) {
        int n = soxMsg.getCommand();
        switch (n) {
            case 101: {
                soxMsg.device.receiveEvent(soxMsg);
                break;
            }
            case 107: {
                if (soxMsg.device.getAlarms().isActive()) {
                    soxMsg.device.getAlarms().getClient().getFileTransfer().receiveChunk(soxMsg);
                    break;
                }
                soxMsg.device.getHistories().getClient().getFileTransfer().receiveChunk(soxMsg);
                break;
            }
            default: {
                this.communicator.getLog().warning("Received unhandled message type.\n" + (Object)((Object)soxMsg));
            }
        }
    }

    public SoxSocket getSoxSocket() {
        return this.socket;
    }

    public String toString() {
        return "SoxComm";
    }

    void writeLinkDebug(String string, BIsmaSoxAddress bIsmaSoxAddress, byte[] byArray, int n) {
        if (this.communicator.getLog().isTraceOn()) {
            this.communicator.getLog().trace(string + (Object)((Object)bIsmaSoxAddress) + ':' + (char)byArray[0] + ' ' + ByteArrayUtil.toString(byArray, n));
        }
    }

    private final /* synthetic */ void this() {
        this.dsHash = new Hashtable();
        this.commStarted = false;
        this.done = true;
        this.rcvThread = null;
        this.soxThread = null;
        this.clients = new Hashtable();
    }

    private SoxComm(BIsmaSoxCommunicator bIsmaSoxCommunicator) {
        this.this();
        this.communicator = bIsmaSoxCommunicator;
        this.transMgr = SoxTransactionManager.make(bIsmaSoxCommunicator);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class SoxReceiveDriver
    implements Runnable {
        private SoxSocket soxSocket;

        void stop() {
            SoxComm.this.done = true;
        }

        public void run() {
            SoxComm.this.done = false;
            while (!SoxComm.this.done) {
                try {
                    DaspMessage daspMessage = this.soxSocket.socket.receive((long)-1);
                    byte[] byArray = daspMessage.payload();
                    BIsmaSoxDevice bIsmaSoxDevice = (BIsmaSoxDevice)((Object)daspMessage.session().userData);
                    SoxMsg soxMsg = SoxMsg.make(bIsmaSoxDevice, byArray, byArray.length);
                    if (soxMsg.isRequest()) {
                        SoxComm.this.writeLinkDebug("~unsolrcvd:", bIsmaSoxDevice.getAddress(), byArray, byArray.length);
                    } else {
                        SoxComm.this.writeLinkDebug("~rcvd:", bIsmaSoxDevice.getAddress(), byArray, byArray.length);
                    }
                    SoxComm.this.receiveSoxMessage(soxMsg);
                }
                catch (ThreadDeath threadDeath) {
                    SoxComm.this.done = true;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable throwable) {}
            }
        }

        public SoxReceiveDriver(SoxSocket soxSocket) {
            this.soxSocket = soxSocket;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SoxConnect
    implements Runnable {
        Vector deviceToAdd;
        Vector deviceToRemove;

        void stop() {
            SoxComm.this.done = true;
        }

        synchronized void connectDevice(BIsmaSoxDevice bIsmaSoxDevice) {
            if (!this.deviceToAdd.contains((Object)bIsmaSoxDevice)) {
                this.deviceToAdd.add(bIsmaSoxDevice);
            }
            this.notifyAll();
        }

        synchronized void disconnectDevice(BIsmaSoxDevice bIsmaSoxDevice) {
            if (!this.deviceToRemove.contains((Object)bIsmaSoxDevice)) {
                this.deviceToRemove.add(bIsmaSoxDevice);
            }
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            SoxComm.this.done = false;
            while (!SoxComm.this.done) {
                try {
                    DaspSession daspSession;
                    BIsmaSoxAddress bIsmaSoxAddress;
                    BIsmaSoxDevice bIsmaSoxDevice;
                    block13: {
                        BIsmaSoxDevice bIsmaSoxDevice2 = null;
                        bIsmaSoxDevice = null;
                        SoxConnect soxConnect = this;
                        synchronized (soxConnect) {
                            while (true) {
                                if (this.deviceToAdd.size() > 0 || this.deviceToRemove.size() > 0) {
                                    if (this.deviceToAdd.size() > 0) {
                                        bIsmaSoxDevice2 = (BIsmaSoxDevice)((Object)this.deviceToAdd.remove(0));
                                    }
                                    if (this.deviceToRemove.size() > 0) {
                                        bIsmaSoxDevice = (BIsmaSoxDevice)((Object)this.deviceToRemove.remove(0));
                                    }
                                    // MONITOREXIT @DISABLED, blocks:[0, 2, 6, 7, 12] lbl19 : MonitorExitStatement: MONITOREXIT : var3_4
                                    if (bIsmaSoxDevice2 != null) {
                                        break;
                                    }
                                    break block13;
                                }
                                this.wait();
                            }
                        }
                        bIsmaSoxAddress = bIsmaSoxDevice2.getAddress();
                        daspSession = (DaspSession)SoxComm.this.dsHash.get((Object)bIsmaSoxAddress);
                        if (daspSession == null) {
                            SoxComm.this.communicator.getLog().message("Create a session for " + bIsmaSoxDevice2.getName() + ':' + (Object)((Object)bIsmaSoxDevice2.getAddress()));
                            BUsernameAndPassword bUsernameAndPassword = bIsmaSoxDevice2.getCredentials();
                            DaspSession daspSession2 = SoxComm.this.socket.socket.connect(bIsmaSoxAddress.getInetAddress(), bIsmaSoxAddress.getPort(), bUsernameAndPassword.getUsername(), bUsernameAndPassword.getPassword().getString());
                            daspSession2.userData = bIsmaSoxDevice2;
                            daspSession2.traceReceive = false;
                            daspSession2.traceSend = false;
                            SoxComm.this.dsHash.put(bIsmaSoxAddress, daspSession2);
                            bIsmaSoxDevice2.ping();
                            bIsmaSoxDevice2.resubscribe();
                        }
                    }
                    if (bIsmaSoxDevice == null || (daspSession = (DaspSession)SoxComm.this.dsHash.get((Object)(bIsmaSoxAddress = bIsmaSoxDevice.getAddress()))) == null) continue;
                    SoxComm.this.communicator.getLog().message("Close session for " + bIsmaSoxDevice.getName());
                    daspSession.close();
                    SoxComm.this.dsHash.remove(daspSession);
                }
                catch (ThreadDeath threadDeath) {
                    SoxComm.this.done = true;
                }
                catch (Throwable throwable) {}
            }
        }

        private final /* synthetic */ void this() {
            this.deviceToAdd = new Vector();
            this.deviceToRemove = new Vector();
        }

        public SoxConnect() {
            this.this();
        }
    }
}

