/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.comm;

import com.gc5.comm.SoxTransaction;
import com.gc5.comm.TimeOutException;
import com.gc5.core.BIsmaSoxCommunicator;
import java.util.Vector;
import javax.baja.sys.Clock;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class SoxTransactionManager {
    private SoxTransaction nextFree;
    private Vector inuseVect;
    private Vector timedVect;
    private int lastTagUsed;
    private TransactionTimer transactionTimer;
    private Thread timerThread;
    private int transCnt;
    BIsmaSoxCommunicator comm;

    static final SoxTransactionManager make(BIsmaSoxCommunicator bIsmaSoxCommunicator) {
        return new SoxTransactionManager(bIsmaSoxCommunicator);
    }

    final void start() {
        this.nextFree = null;
        this.lastTagUsed = 0;
        this.inuseVect = new Vector();
        this.timedVect = new Vector();
        this.transactionTimer = new TransactionTimer();
        this.timerThread = new Thread((Runnable)this.transactionTimer, "SoxTransactionTimer:" + this.comm.getParent().getName());
        this.timerThread.start();
        this.timerThread.setPriority(5);
    }

    final void stop() {
        if (this.timerThread != null) {
            this.transactionTimer.stop();
            this.timerThread.interrupt();
        }
        int n = this.inuseVect.size() - 1;
        while (n >= 0) {
            SoxTransaction soxTransaction = (SoxTransaction)this.inuseVect.elementAt(n);
            this.inuseVect.removeElement(soxTransaction);
            this.freeTransaction(soxTransaction);
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final SoxTransaction getTransaction() {
        SoxTransactionManager soxTransactionManager = this;
        synchronized (soxTransactionManager) {
            SoxTransaction soxTransaction;
            block5: {
                block4: {
                    soxTransaction = this.nextFree;
                    if (soxTransaction == null) break block4;
                    this.nextFree = soxTransaction.next;
                    break block5;
                }
                soxTransaction = new SoxTransaction();
                ++this.transCnt;
            }
            if (++this.lastTagUsed > 255) {
                this.lastTagUsed = 1;
            }
            soxTransaction.tag = this.lastTagUsed;
            soxTransaction.startTime = Clock.ticks();
            this.inuseVect.add(soxTransaction);
            return soxTransaction;
        }
    }

    final void schedule(SoxTransaction soxTransaction, int n) {
        this.transactionTimer.schedule(soxTransaction, n);
    }

    final synchronized void freeTransaction(SoxTransaction soxTransaction) {
        this.inuseVect.removeElement(soxTransaction);
        soxTransaction.clear();
        soxTransaction.next = this.nextFree;
        this.nextFree = soxTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    final SoxTransaction getTransactionMatch(int n) {
        SoxTransaction soxTransaction = null;
        SoxTransactionManager soxTransactionManager = this;
        // MONITORENTER : soxTransactionManager
        int n2 = 0;
        while (n2 < this.inuseVect.size()) {
            SoxTransaction soxTransaction2 = (SoxTransaction)this.inuseVect.elementAt(n2);
            if (soxTransaction2.tag != n) {
                ++n2;
                continue;
            }
            soxTransaction2.finishTime = Clock.ticks();
            soxTransaction2.delta = soxTransaction2.finishTime - soxTransaction2.startTime;
            this.inuseVect.removeElement(soxTransaction2);
            soxTransaction = soxTransaction2;
            break;
        }
        // MONITOREXIT : soxTransactionManager
        if (soxTransaction == null) return soxTransaction;
        this.transactionTimer.unschedule(soxTransaction);
        return soxTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final synchronized void timeOut(SoxTransaction soxTransaction) {
        if (!this.timedVect.removeElement(soxTransaction)) return;
        soxTransaction.exception = new TimeOutException();
        soxTransaction.timeOut = true;
        SoxTransaction soxTransaction2 = soxTransaction;
        synchronized (soxTransaction2) {
            soxTransaction.notifyAll();
            return;
        }
    }

    final synchronized SoxTransaction nextTimed() {
        if (this.timedVect.size() > 0) {
            return (SoxTransaction)this.timedVect.elementAt(0);
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.lastTagUsed = 0;
        this.timerThread = null;
        this.transCnt = 0;
        this.comm = null;
    }

    SoxTransactionManager(BIsmaSoxCommunicator bIsmaSoxCommunicator) {
        this.this();
        this.comm = bIsmaSoxCommunicator;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TransactionTimer
    implements Runnable {
        SoxTransaction timedTransaction;
        boolean interrupt;
        boolean alive;

        void stop() {
            this.alive = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            this.alive = true;
            while (this.alive) {
                TransactionTimer transactionTimer = this;
                // MONITORENTER : transactionTimer
                {
                    try {
                        if (this.timedTransaction == null) {
                            this.wait();
                        } else {
                            long l = this.timedTransaction.endTime - Clock.millis();
                            this.interrupt = false;
                            if (l > 0L) {
                                this.wait(l);
                            }
                            if (!this.interrupt) {
                                SoxTransactionManager.this.timeOut(this.timedTransaction);
                            }
                            this.timedTransaction = SoxTransactionManager.this.nextTimed();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (Exception exception) {}
                    // MONITOREXIT : transactionTimer
                }
            }
        }

        synchronized void schedule(SoxTransaction soxTransaction, int n) {
            soxTransaction.endTime = Clock.millis() + (long)n;
            soxTransaction.exception = null;
            soxTransaction.timeOut = false;
            SoxTransactionManager.this.timedVect.add(soxTransaction);
            if (this.timedTransaction == null) {
                this.timedTransaction = soxTransaction;
                this.interrupt = true;
                this.notifyAll();
            }
        }

        synchronized void unschedule(SoxTransaction soxTransaction) {
            int n;
            SoxTransactionManager.this.timedVect.removeElement(soxTransaction);
            int n2 = soxTransaction.tag;
            if (this.timedTransaction != null && n2 == (n = this.timedTransaction.tag)) {
                this.interrupt = true;
                this.notifyAll();
            }
        }

        private final /* synthetic */ void this() {
            this.timedTransaction = null;
            this.interrupt = false;
            this.alive = false;
        }

        private TransactionTimer() {
            this.this();
        }
    }
}

