/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nsedona.sox.BISoxPlatform;
import com.tridium.nsedona.sox.PlatformSession;
import com.tridium.sedonanet.driver.BFoxSoxChannel;
import com.tridium.sedonanet.driver.BISedonaDevice;
import java.util.Properties;
import sedona.KitPart;
import sedona.Schema;
import sedona.sox.ISoxComm;
import sedona.sox.KitVersion;
import sedona.sox.SoxFile;
import sedona.sox.VersionInfo;

public final class FoxDevicePlatformSession
extends PlatformSession {
    private final BISedonaDevice device;
    private final int sessionId;
    private BFoxSoxChannel channel;
    private VersionInfo version;

    public final BFoxSoxChannel getChannel() {
        if (this.channel == null) {
            this.channel = FoxDevicePlatformSession.getChannel(this.device);
        }
        return this.channel;
    }

    public final VersionInfo getVersionInfo() throws Exception {
        if (this.version == null) {
            this.version = this.getChannel().versionInfo(this);
        }
        return this.version;
    }

    public final Schema getSchema() throws Exception {
        KitVersion[] kitVersionArray = this.getVersionInfo().kits;
        KitPart[] kitPartArray = new KitPart[kitVersionArray.length];
        int n = 0;
        while (n < kitVersionArray.length) {
            KitVersion kitVersion = kitVersionArray[n];
            kitPartArray[n] = new KitPart(kitVersion.name, kitVersion.checksum, kitVersion.version);
            ++n;
        }
        try {
            return Schema.load((KitPart[])kitPartArray);
        }
        catch (Schema.MissingKitManifestException missingKitManifestException) {
            this.resolveMissingManifests(missingKitManifestException.parts);
            return Schema.load((KitPart[])kitPartArray);
        }
    }

    public final void saveApp() throws Exception {
        this.getChannel().saveApp(this);
    }

    public final void restart() throws Exception {
        this.getChannel().restart(this);
    }

    public final void close() {
        try {
            this.getChannel().closeSession(this.sessionId);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final PlatformSession.FileTransfer makeFileTransfer(Properties properties, ISoxComm.TransferListener transferListener) {
        return new Transfer(properties, transferListener);
    }

    public static final BFoxSoxChannel getChannel(BISedonaDevice bISedonaDevice) {
        BFoxSession bFoxSession = (BFoxSession)bISedonaDevice.getDevice().getSession();
        BFoxClientConnection bFoxClientConnection = bFoxSession.getConnection();
        return (BFoxSoxChannel)bFoxClientConnection.getChannels().get("foxsox", BFoxSoxChannel.TYPE);
    }

    public final int sessionId() {
        return this.sessionId;
    }

    private final void log(String string) {
        System.out.println("foxsox [" + this.sessionId + "] " + string);
    }

    public FoxDevicePlatformSession(BISedonaDevice bISedonaDevice, int n) {
        super((BISoxPlatform)bISedonaDevice);
        this.device = bISedonaDevice;
        this.sessionId = n;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Transfer
    implements PlatformSession.FileTransfer {
        final Properties headers;
        final ISoxComm.TransferListener listener;

        public void getFile(String string, SoxFile soxFile) throws Exception {
            FoxDevicePlatformSession.this.getChannel().getFile(FoxDevicePlatformSession.this, string, soxFile, this.headers, this.listener);
        }

        public void putFile(SoxFile soxFile, String string) throws Exception {
            FoxDevicePlatformSession.this.getChannel().putFile(FoxDevicePlatformSession.this, soxFile, string, this.headers, this.listener);
        }

        public void renameFile(String string, String string2) throws Exception {
            FoxDevicePlatformSession.this.getChannel().renameFile(FoxDevicePlatformSession.this, string, string2);
        }

        public Transfer(Properties properties, ISoxComm.TransferListener transferListener) {
            this.headers = properties;
            if (transferListener == null) {
                transferListener = new ISoxComm.TransferListener(){

                    public final void progress(int n, int n2) {
                    }
                };
            }
            this.listener = transferListener;
        }
    }
}

