/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.ui.user;

import com.tridium.nsedona.ui.user.BGroupPermissionsFE;
import com.tridium.nsedona.ui.user.BProvPermissionsFE;
import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.driver.BSedonaBaseNetwork;
import com.tridium.sedonanet.user.BSedonaRole;
import com.tridium.sedonanet.user.BSedonaRoleService;
import com.tridium.sedonanet.user.BSedonaUser;
import com.tridium.sedonanet.user.BSedonaUserService;
import com.tridium.sedonanet.user.BSedonaUsersExt;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSelection;
import javax.baja.util.Array;
import javax.baja.workbench.CannotSaveException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BUserTable
extends BTreeTable {
    public static final Action validate = BUserTable.newAction((int)0, null);
    public static final Topic usersModified = BUserTable.newTopic((int)0, null);
    public static final Type TYPE;
    private BSedonaUserService userService;
    private BSedonaRoleService roleService;
    private Model model;
    private UserSelection sel;
    static /* synthetic */ Class class$com$tridium$sedonanet$ui$user$BUserTable;

    public final void validate() {
        this.invoke(validate, null, null);
    }

    public final void fireUsersModified(BValue bValue) {
        this.fire(usersModified, bValue, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final UserSelection getUserSelection() {
        return (UserSelection)this.getSelection();
    }

    final void expandToDepth(int n) {
        if (n == 0) {
            return;
        }
        int n2 = this.getTreeTableModel().getRootCount();
        int n3 = 0;
        while (n3 < n2) {
            this.expand(this.getTreeTableModel().getRoot(n3), n);
            ++n3;
        }
    }

    private final void expand(TreeTableNode treeTableNode, int n) {
        treeTableNode.setExpanded(true);
        if (n - 1 == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < treeTableNode.getChildCount()) {
            this.expand(treeTableNode.getChild(n2), n - 1);
            ++n2;
        }
    }

    public final void save() throws Exception {
        this.validate();
        int n = 0;
        while (n < this.model.getRootCount()) {
            ((Node)this.model.getRoot(n)).save();
            ++n;
        }
        n = 0;
        while (n < this.model.getRootCount()) {
            ((Node)this.model.getRoot(n)).clearModified();
            ++n;
        }
        this.model.updateTreeTable(true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void doValidate() {
        this.userService.lease();
        this.roleService.lease();
        try {
            int n = 0;
            while (n < this.model.getRootCount()) {
                ((Node)this.model.getRoot(n)).validate();
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.model.updateTreeTable(true);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.model.updateTreeTable(true);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BUserTable() {
    }

    public BUserTable(BSedonaBaseNetwork bSedonaBaseNetwork) {
        this.userService = (BSedonaUserService)BOrd.make((String)"service:sedonanet:SedonaUserService").get((BObject)bSedonaBaseNetwork);
        this.roleService = (BSedonaRoleService)BOrd.make((String)"service:sedonanet:SedonaRoleService").get((BObject)bSedonaBaseNetwork);
        this.model = new Model();
        this.setModel((TableModel)this.model);
        this.model.load(bSedonaBaseNetwork);
        this.sel = new UserSelection();
        this.setSelection((TableSelection)this.sel);
        this.linkTo((BComponent)this, (Slot)usersModified, (Slot)validate);
    }

    static {
        Class clazz = class$com$tridium$sedonanet$ui$user$BUserTable;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$ui$user$BUserTable = BUserTable.class("[Lcom.tridium.sedonanet.ui.user.BUserTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class UserSelection
    extends TreeTableSelection {
        private ExtNode copyRoot;
        static /* synthetic */ Class class$com$tridium$sedonanet$ui$user$BUserTable$ExtNode;
        static /* synthetic */ Class class$com$tridium$sedonanet$ui$user$BUserTable$UserNode;

        public final boolean onlyDevicesSelected() {
            if (this.getRowCount() == 0) {
                return false;
            }
            ExtNode[] extNodeArray = this.getSelectedExts();
            boolean bl = false;
            if (extNodeArray.length > 0 && extNodeArray.length == this.getSelection().getRowCount()) {
                bl = true;
            }
            return bl;
        }

        public final boolean onlyUsersSelected() {
            if (this.getRowCount() == 0) {
                return false;
            }
            UserNode[] userNodeArray = this.getSelectedUsers();
            boolean bl = false;
            if (userNodeArray.length > 0 && userNodeArray.length == this.getRowCount()) {
                bl = true;
            }
            return bl;
        }

        public final ExtNode[] getSelectedExts() {
            Class clazz = class$com$tridium$sedonanet$ui$user$BUserTable$ExtNode;
            if (clazz == null) {
                clazz = class$com$tridium$sedonanet$ui$user$BUserTable$ExtNode = UserSelection.class("[Lcom.tridium.sedonanet.ui.user.BUserTable$ExtNode;", false);
            }
            return (ExtNode[])this.filterSelection(clazz).trim();
        }

        public final UserNode[] getSelectedUsers() {
            Class clazz = class$com$tridium$sedonanet$ui$user$BUserTable$UserNode;
            if (clazz == null) {
                clazz = class$com$tridium$sedonanet$ui$user$BUserTable$UserNode = UserSelection.class("[Lcom.tridium.sedonanet.ui.user.BUserTable$UserNode;", false);
            }
            return (UserNode[])this.filterSelection(clazz).trim();
        }

        public final void deleteSelected() {
            TreeTableModel treeTableModel = this.getTreeTableModel();
            int n = 0;
            while (n < treeTableModel.getRootCount()) {
                ((ExtNode)treeTableModel.getRoot(n)).deleteSelectedChildren();
                ++n;
            }
            treeTableModel.updateTreeTable(true);
        }

        private final Array filterSelection(Class clazz) {
            TreeTableModel treeTableModel = this.getTreeTableModel();
            Array array = new Array(clazz);
            int[] nArray = this.getSelection().getRows();
            int n = 0;
            while (n < nArray.length) {
                TreeTableNode treeTableNode = treeTableModel.rowToNode(nArray[n]);
                if (clazz.isInstance(treeTableNode)) {
                    array.add((Object)treeTableNode);
                }
                ++n;
            }
            return array;
        }

        public final boolean isCopyableSelection() {
            boolean bl = false;
            if (this.getRowCount() == 1) {
                bl = true;
            }
            boolean bl2 = bl;
            this.copyRoot = null;
            if (!this.onlyUsersSelected()) {
                return false;
            }
            UserNode[] userNodeArray = this.getSelectedUsers();
            ExtNode extNode = userNodeArray[0].ext();
            int n = 1;
            while (n < userNodeArray.length) {
                if (userNodeArray[n].ext() != extNode) {
                    return false;
                }
                ++n;
            }
            this.copyRoot = extNode;
            return true;
        }

        public final ExtNode getCopyRoot() {
            return this.copyRoot;
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            this.copyRoot = null;
        }

        public UserSelection() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends TreeTableModel {
        ExtNode[] devices;

        public void load(BSedonaBaseNetwork bSedonaBaseNetwork) {
            BSedonaBaseDevice[] bSedonaBaseDeviceArray = bSedonaBaseNetwork.getDeviceList();
            this.devices = new ExtNode[bSedonaBaseDeviceArray.length];
            int n = 0;
            while (n < bSedonaBaseDeviceArray.length) {
                this.devices[n] = new ExtNode(this, bSedonaBaseDeviceArray[n]);
                ++n;
            }
        }

        public int getRootCount() {
            return this.devices.length;
        }

        public TreeTableNode getRoot(int n) {
            return this.devices[n];
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Permission Bits";
                }
                case 2: {
                    return "Provisioning Bits";
                }
            }
            return "";
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static abstract class Node
    extends TreeTableNode {
        protected Array errors;
        protected Array nodes;
        protected boolean isModified;
        static /* synthetic */ Class class$com$tridium$sedonanet$ui$user$BUserTable$ErrorNode;
        static /* synthetic */ Class class$com$tridium$sedonanet$ui$user$BUserTable$Node;

        public Object getValueAt(int n) {
            return null;
        }

        public final int getChildCount() {
            return this.errors.size() + this.nodes.size();
        }

        public final TreeTableNode getChild(int n) {
            return n < this.errors.size() ? (TreeTableNode)this.errors.get(n) : (TreeTableNode)this.nodes.get(n - this.errors.size());
        }

        public final BSedonaUserService userService() {
            return ((BUserTable)this.getTable()).userService;
        }

        public final BSedonaRoleService roleService() {
            return ((BUserTable)this.getTable()).roleService;
        }

        public final ExtNode ext() {
            TreeTableNode treeTableNode = this.getParent();
            while (treeTableNode != null && !(treeTableNode instanceof ExtNode)) {
                treeTableNode = treeTableNode.getParent();
            }
            return (ExtNode)treeTableNode;
        }

        public final void validate() {
            this.errors.clear();
            this.doValidate();
            int n = 0;
            while (n < this.getChildCount()) {
                ((Node)this.getChild(n)).validate();
                ++n;
            }
        }

        protected void doValidate() {
        }

        public void save() throws Exception {
            if (this.hasErrors()) {
                throw new CannotSaveException("There are errors in the configuration");
            }
            int n = 0;
            while (n < this.getChildCount()) {
                ((Node)this.getChild(n)).save();
                ++n;
            }
        }

        public void rebuildChildren() {
        }

        public final BImage getIcon() {
            BIcon bIcon = this._getIcon();
            if (this.hasErrors()) {
                bIcon = BIcon.make((BIcon)bIcon, (BIcon)BIcon.std((String)"badges/error.png"));
            }
            BImage bImage = BImage.make((BIcon)bIcon);
            if (this.isModified) {
                bImage = bImage.getHighlightedImage();
            }
            return bImage;
        }

        protected abstract BIcon _getIcon();

        public boolean hasErrors() {
            int n = 0;
            while (n < this.nodes.size()) {
                if (((Node)((Object)this.nodes.get(n))).hasErrors()) {
                    return true;
                }
                ++n;
            }
            boolean bl = false;
            if (this.errors.size() > 0) {
                bl = true;
            }
            return bl;
        }

        public void setModified() {
            this.isModified = true;
            Node node = (Node)this.getParent();
            while (node != null) {
                node.setModified();
                node = (Node)node.getParent();
            }
        }

        public void clearModified() {
            if (!this.isModified) {
                return;
            }
            int n = 0;
            while (n < this.getChildCount()) {
                ((Node)this.getChild(n)).clearModified();
                ++n;
            }
            this.isModified = false;
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            Class clazz = class$com$tridium$sedonanet$ui$user$BUserTable$ErrorNode;
            if (clazz == null) {
                clazz = class$com$tridium$sedonanet$ui$user$BUserTable$ErrorNode = Node.class("[Lcom.tridium.sedonanet.ui.user.BUserTable$ErrorNode;", false);
            }
            this.errors = new Array(clazz);
            Class clazz2 = class$com$tridium$sedonanet$ui$user$BUserTable$Node;
            if (clazz2 == null) {
                clazz2 = class$com$tridium$sedonanet$ui$user$BUserTable$Node = Node.class("[Lcom.tridium.sedonanet.ui.user.BUserTable$Node;", false);
            }
            this.nodes = new Array(clazz2);
            this.isModified = false;
        }

        public Node(TreeTableModel treeTableModel) {
            super(treeTableModel);
            this.this();
        }

        public Node(TreeTableNode treeTableNode) {
            super(treeTableNode);
            this.this();
        }
    }

    static class RoleNode
    extends Node {
        String role;
        String perm;
        String prov;

        public UserNode user() {
            return (UserNode)this.getParent();
        }

        protected void doValidate() {
            super.doValidate();
            if (this.roleService().getSedonaRole(this.role) == null) {
                this.errors.add((Object)new ErrorNode(this, this.role + " is no longer in the role service"));
            }
        }

        public Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return SlotPath.unescape((String)this.role);
                }
                case 1: {
                    return this.perm;
                }
                case 2: {
                    return this.prov;
                }
            }
            return "";
        }

        protected BIcon _getIcon() {
            return BSedonaRole.Icon;
        }

        public RoleNode(UserNode userNode, String string) {
            super(userNode);
            BSedonaRoleService bSedonaRoleService = ((BUserTable)this.getTable()).roleService;
            this.role = string;
            BSedonaRole bSedonaRole = bSedonaRoleService.getSedonaRole(string);
            bSedonaRole.loadSlots();
            this.perm = BGroupPermissionsFE.toDisplay((int)bSedonaRole.getPermissions());
            this.prov = BProvPermissionsFE.toDisplay((int)bSedonaRole.getProvisioning());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class UserNode
    extends Node {
        String username;
        static /* synthetic */ Class class$com$tridium$sedonanet$ui$user$BUserTable$RoleNode;

        public Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.username;
                }
            }
            return "";
        }

        public Set currentRoles() {
            return new HashSet((Set)this.ext().getCurrentState().get(this.username));
        }

        public void setRoles(Set hashSet) {
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            this.ext().userToRoles.put(this.username, hashSet);
            this.rebuildChildren();
        }

        protected void doValidate() {
            String string;
            super.doValidate();
            if (this.nodes.size() == 0) {
                this.errors.add((Object)new ErrorNode(this, "User has no roles"));
            }
            if (this.userService().getSedonaUser(this.username) == null) {
                this.errors.add((Object)new ErrorNode(this, this.username + " is no longer in the user service"));
            }
            if (this.username.equals(string = this.ext().device.getCredentials().getUsername())) {
                this.errors.add((Object)new ErrorNode(this, "Cannot manage a user with the same name as in the device's credentials property"));
            }
        }

        public void rebuildChildren() {
            Object object;
            Set set = (Set)this.ext().userToRoles.get(this.username);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            boolean bl = false;
            if (this.nodes.size() != set.size()) {
                bl = true;
            }
            boolean bl2 = bl;
            int n = 0;
            while (n < this.nodes.size()) {
                object = (RoleNode)((Object)this.nodes.get(n));
                if (set.contains(((RoleNode)((Object)object)).role)) {
                    hashMap.put(((RoleNode)((Object)object)).role, object);
                } else {
                    bl2 = true;
                }
                ++n;
            }
            Class clazz = class$com$tridium$sedonanet$ui$user$BUserTable$RoleNode;
            if (clazz == null) {
                clazz = class$com$tridium$sedonanet$ui$user$BUserTable$RoleNode = UserNode.class("[Lcom.tridium.sedonanet.ui.user.BUserTable$RoleNode;", false);
            }
            Array array = new Array(clazz);
            object = set.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (hashMap.containsKey(string)) {
                    array.add(hashMap.get(string));
                    continue;
                }
                RoleNode roleNode = new RoleNode(this, string);
                array.add((Object)roleNode);
                roleNode.setModified();
            }
            this.nodes = array.sort(new Comparator(){

                public final int compare(Object object, Object object2) {
                    return ((RoleNode)((Object)object)).role.compareTo(((RoleNode)((Object)object2)).role);
                }
            });
            if (bl2) {
                this.setModified();
            }
        }

        protected BIcon _getIcon() {
            return BSedonaUser.Icon;
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public UserNode(ExtNode extNode, String string) {
            super(extNode);
            this.username = string;
            this.rebuildChildren();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class ExtNode
    extends Node {
        BSedonaBaseDevice device;
        BSedonaUsersExt ext;
        HashMap userToRoles;
        static /* synthetic */ Class class$com$tridium$sedonanet$ui$user$BUserTable$UserNode;

        public void save() throws Exception {
            super.save();
            this.ext.setUserMap(this.userToRoles);
            this.getModel().updateTreeTable(true);
        }

        public Map getCurrentState() {
            HashMap hashMap = new HashMap();
            Iterator iterator = this.userToRoles.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashMap.put(string, new HashSet((Set)this.userToRoles.get(string)));
            }
            return hashMap;
        }

        public void update(Map map) {
            String string;
            HashSet<String> hashSet = new HashSet<String>();
            String[] stringArray = this.userToRoles.keySet().toArray(new String[this.userToRoles.size()]);
            int n = 0;
            while (n < stringArray.length) {
                string = stringArray[n];
                hashSet.add(string);
                Set set = (Set)this.userToRoles.get(string);
                Set set2 = (Set)map.get(string);
                if (!set.equals(set2)) {
                    this.userToRoles.put(string, set2 == null ? new HashSet() : set2);
                }
                ++n;
            }
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (hashSet.contains(string)) continue;
                this.userToRoles.put(string, map.get(string));
            }
            this.rebuildChildren();
        }

        public Map copy() {
            TreeTableModel treeTableModel = this.getModel();
            UserSelection userSelection = (UserSelection)treeTableModel.getSelection();
            if (userSelection.onlyDevicesSelected()) {
                return this.getCurrentState();
            }
            HashMap<String, Set> hashMap = new HashMap<String, Set>();
            UserNode[] userNodeArray = userSelection.getSelectedUsers();
            int n = 0;
            while (n < userNodeArray.length) {
                hashMap.put(userNodeArray[n].username, userNodeArray[n].currentRoles());
                ++n;
            }
            return hashMap;
        }

        public void paste(Map map) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.userToRoles.put(string, map.get(string));
            }
            this.rebuildChildren();
        }

        public void pasteSpecial(Map map) {
            this.userToRoles.clear();
            this.paste(map);
        }

        public UserNode[] getUserNodes() {
            Class clazz = class$com$tridium$sedonanet$ui$user$BUserTable$UserNode;
            if (clazz == null) {
                clazz = class$com$tridium$sedonanet$ui$user$BUserTable$UserNode = ExtNode.class("[Lcom.tridium.sedonanet.ui.user.BUserTable$UserNode;", false);
            }
            Array array = new Array(clazz);
            array.addAll(this.nodes.trim());
            return (UserNode[])array.trim();
        }

        public void deleteSelectedChildren() {
            TreeTableModel treeTableModel = this.getModel();
            int n = this.getChildCount();
            boolean bl = false;
            int n2 = -1;
            int n3 = 0;
            while (n3 < n) {
                UserNode userNode = (UserNode)this.getChild(n3);
                n2 = treeTableModel.nodeToRow((TreeTableNode)userNode);
                if (n2 >= 0 && treeTableModel.getSelection().isSelected(n2)) {
                    bl = true;
                    this.userToRoles.remove(userNode.username);
                } else {
                    int n4 = userNode.getChildCount();
                    Set set = (Set)this.userToRoles.get(userNode.username);
                    int n5 = 0;
                    while (n5 < n4) {
                        RoleNode roleNode = (RoleNode)userNode.getChild(n5);
                        n2 = treeTableModel.nodeToRow((TreeTableNode)roleNode);
                        if (n2 >= 0 && treeTableModel.getSelection().isSelected(n2)) {
                            bl = true;
                            set.remove(roleNode.role);
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
            if (bl) {
                this.rebuildChildren();
            }
        }

        public void rebuildChildren() {
            Object object;
            boolean bl = false;
            if (this.nodes.size() != this.userToRoles.size()) {
                bl = true;
            }
            boolean bl2 = bl;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int n = 0;
            while (n < this.nodes.size()) {
                object = (UserNode)((Object)this.nodes.get(n));
                if (this.userToRoles.containsKey(((UserNode)((Object)object)).username)) {
                    hashMap.put(((UserNode)((Object)object)).username, object);
                }
                ++n;
            }
            Class clazz = class$com$tridium$sedonanet$ui$user$BUserTable$UserNode;
            if (clazz == null) {
                clazz = class$com$tridium$sedonanet$ui$user$BUserTable$UserNode = ExtNode.class("[Lcom.tridium.sedonanet.ui.user.BUserTable$UserNode;", false);
            }
            Array array = new Array(clazz);
            object = this.userToRoles.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (hashMap.containsKey(string)) {
                    UserNode userNode = (UserNode)((Object)hashMap.get(string));
                    array.add((Object)userNode);
                    userNode.rebuildChildren();
                    continue;
                }
                array.add((Object)new UserNode(this, string));
                bl2 = true;
            }
            this.nodes = array.sort(new Comparator(){

                public final int compare(Object object, Object object2) {
                    return ((UserNode)((Object)object)).username.compareTo(((UserNode)((Object)object2)).username);
                }
            });
            if (bl2) {
                this.setModified();
            }
        }

        public void setModified() {
            super.setModified();
            ((BUserTable)this.getTable()).fireUsersModified(null);
        }

        public Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.device.getDisplayName(null);
                }
            }
            return "";
        }

        protected BIcon _getIcon() {
            return this.device.getIcon();
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public ExtNode(TreeTableModel treeTableModel, BSedonaBaseDevice bSedonaBaseDevice) {
            super(treeTableModel);
            this.device = bSedonaBaseDevice;
            bSedonaBaseDevice.loadSlots();
            this.ext = (BSedonaUsersExt)bSedonaBaseDevice.getMixIn(BSedonaUsersExt.TYPE);
            this.ext.lease();
            this.userToRoles = new HashMap();
            this.update(this.ext.userToRoles());
            this.clearModified();
        }
    }

    static class ErrorNode
    extends Node {
        static BIcon Icon = BIcon.std((String)"error.png");
        final String err;

        public Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.err;
                }
            }
            return "";
        }

        protected BIcon _getIcon() {
            return Icon;
        }

        public ErrorNode(TreeTableNode treeTableNode, String string) {
            super(treeTableNode);
            this.err = string;
        }
    }
}

