/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.modbus;

import com.tridium.basicdriver.MessageListener;
import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.datatypes.BModbusClientPresetRegister;
import com.tridium.modbusCore.client.datatypes.BModbusClientPresetRegisters;
import com.tridium.modbusCore.client.point.BModbusClientPointDeviceExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.baja.control.trigger.BIntervalTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusToSedonaDateTime
extends BModbusClientPresetRegisters {
    public static final Property writeOnInputChange = BModbusToSedonaDateTime.newProperty((int)1, (boolean)false, null);
    public static final Property dataType = BModbusToSedonaDateTime.newProperty((int)1, (BValue)BDataTypeEnum.integerType, null);
    public static final Property startingAddress = BModbusToSedonaDateTime.newProperty((int)1, (BValue)new BFlexAddress(BAddressFormatEnum.decimal, "61440"), null);
    public static final Property syncTrigger = BModbusToSedonaDateTime.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BIntervalTriggerMode.make((BRelTime)BRelTime.makeMinutes((int)15))), null);
    public static final Property hour = BModbusToSedonaDateTime.newProperty((int)0, (BValue)new BModbusClientPresetRegister(), null);
    public static final Property minute = BModbusToSedonaDateTime.newProperty((int)0, (BValue)new BModbusClientPresetRegister(), null);
    public static final Property second = BModbusToSedonaDateTime.newProperty((int)0, (BValue)new BModbusClientPresetRegister(), null);
    public static final Property year = BModbusToSedonaDateTime.newProperty((int)0, (BValue)new BModbusClientPresetRegister(), null);
    public static final Property month = BModbusToSedonaDateTime.newProperty((int)0, (BValue)new BModbusClientPresetRegister(), null);
    public static final Property day = BModbusToSedonaDateTime.newProperty((int)0, (BValue)new BModbusClientPresetRegister(), null);
    public static final Type TYPE;
    int devAddr;
    static /* synthetic */ Class class$com$ontrol$modbus$BModbusToSedonaDateTime;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetRegister;

    public BFlexAddress getStartingAddress() {
        return (BFlexAddress)this.get(startingAddress);
    }

    public void setStartingAddress(BFlexAddress bFlexAddress) {
        this.set(startingAddress, (BValue)bFlexAddress, null);
    }

    public BTimeTrigger getSyncTrigger() {
        return (BTimeTrigger)this.get(syncTrigger);
    }

    public void setSyncTrigger(BTimeTrigger bTimeTrigger) {
        this.set(syncTrigger, (BValue)bTimeTrigger, null);
    }

    public BModbusClientPresetRegister getHour() {
        return (BModbusClientPresetRegister)this.get(hour);
    }

    public void setHour(BModbusClientPresetRegister bModbusClientPresetRegister) {
        this.set(hour, (BValue)bModbusClientPresetRegister, null);
    }

    public BModbusClientPresetRegister getMinute() {
        return (BModbusClientPresetRegister)this.get(minute);
    }

    public void setMinute(BModbusClientPresetRegister bModbusClientPresetRegister) {
        this.set(minute, (BValue)bModbusClientPresetRegister, null);
    }

    public BModbusClientPresetRegister getSecond() {
        return (BModbusClientPresetRegister)this.get(second);
    }

    public void setSecond(BModbusClientPresetRegister bModbusClientPresetRegister) {
        this.set(second, (BValue)bModbusClientPresetRegister, null);
    }

    public BModbusClientPresetRegister getYear() {
        return (BModbusClientPresetRegister)this.get(year);
    }

    public void setYear(BModbusClientPresetRegister bModbusClientPresetRegister) {
        this.set(year, (BValue)bModbusClientPresetRegister, null);
    }

    public BModbusClientPresetRegister getMonth() {
        return (BModbusClientPresetRegister)this.get(month);
    }

    public void setMonth(BModbusClientPresetRegister bModbusClientPresetRegister) {
        this.set(month, (BValue)bModbusClientPresetRegister, null);
    }

    public BModbusClientPresetRegister getDay() {
        return (BModbusClientPresetRegister)this.get(day);
    }

    public void setDay(BModbusClientPresetRegister bModbusClientPresetRegister) {
        this.set(day, (BValue)bModbusClientPresetRegister, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.linkTo("retryLink", (BComponent)this.getSyncTrigger(), (Slot)BTimeTrigger.fireTrigger, (Slot)write);
    }

    public void doWrite() {
        BAbsTime bAbsTime = Clock.time();
        this.getHour().setValue((float)bAbsTime.getHour());
        this.getMinute().setValue((float)bAbsTime.getMinute());
        this.getSecond().setValue((float)bAbsTime.getSecond());
        this.getYear().setValue((float)bAbsTime.getYear());
        this.getMonth().setValue((float)(1 + bAbsTime.getMonth().getOrdinal()));
        this.getDay().setValue((float)bAbsTime.getDay());
        this.writePresetValues();
    }

    private final byte[] setIntegerByteArray(float f) {
        byte[] byArray = new byte[2];
        f = f >= 0.0f ? (float)((double)f + 0.5) : (float)((double)f - 0.5);
        float f2 = 65535.0f;
        float f3 = 0.0f;
        if (f > f2) {
            f = f2;
        } else if (f < f3) {
            f = f3;
        }
        int n = (int)f;
        byArray[0] = (byte)((n & 0xFF00) >> 8);
        byArray[1] = (byte)(n & 0xFF);
        return byArray;
    }

    public void writePresetValues() {
        BModbusClientDevice bModbusClientDevice = this.getDevice();
        BModbusClientNetwork bModbusClientNetwork = this.getNetwork();
        if (this.devAddr > 0) {
            super.writePresetValues();
        } else {
            BModbusClientPresetRegister[] bModbusClientPresetRegisterArray;
            Class clazz = class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetRegister;
            if (clazz == null) {
                clazz = class$com$tridium$modbusCore$client$datatypes$BModbusClientPresetRegister = BModbusToSedonaDateTime.class("[Lcom.tridium.modbusCore.client.datatypes.BModbusClientPresetRegister;", false);
            }
            if ((bModbusClientPresetRegisterArray = (BModbusClientPresetRegister[])this.getChildren(clazz)) == null || bModbusClientPresetRegisterArray.length <= 0) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while (n < bModbusClientPresetRegisterArray.length) {
                float f = bModbusClientPresetRegisterArray[n].getValue();
                try {
                    byteArrayOutputStream.write(this.setIntegerByteArray(f));
                }
                catch (IOException iOException) {}
                ++n;
            }
            n = 16;
            int n2 = this.getAbsoluteStartingAddress().getDataAddress();
            ModbusWriteRequest modbusWriteRequest = new ModbusWriteRequest(bModbusClientNetwork.getModbusMode(), (BModbusDevice)bModbusClientDevice, this.devAddr, n, n2, bModbusClientPresetRegisterArray.length, byteArrayOutputStream.toByteArray());
            modbusWriteRequest.setResponseExpected(false);
            bModbusClientNetwork.sendAsyncWrite((Message)modbusWriteRequest, (MessageListener)this, BRelTime.make((long)10L), 0);
        }
    }

    public void processMessage(Message message) {
        if (this.devAddr > 0) {
            super.processMessage(message);
        } else {
            this.fireWriteSuccessful(null);
        }
    }

    public BModbusClientDevice getDevice() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BModbusClientDevice) {
                BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)bComplex;
                this.devAddr = bModbusClientDevice.getDeviceAddress();
                return bModbusClientDevice;
            }
            bComplex = bComplex.getParent();
        }
        this.devAddr = 0;
        return (BModbusClientDevice)this.getNetwork().getDevices()[0];
    }

    public BModbusClientNetwork getNetwork() {
        BComplex bComplex = this.getParent();
        while (bComplex != null) {
            if (bComplex instanceof BModbusClientNetwork) {
                return (BModbusClientNetwork)bComplex;
            }
            bComplex = bComplex.getParent();
        }
        return null;
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)BStatus.DEFAULT, null);
    }

    public boolean isParentLegal(BComponent bComponent) {
        boolean bl = false;
        if (bComponent instanceof BModbusClientNetwork || bComponent instanceof BModbusClientPointDeviceExt || bComponent instanceof BModbusClientDevice) {
            bl = true;
        }
        return bl;
    }

    public void doAddPresetRegisterValue(BModbusClientPresetRegister bModbusClientPresetRegister) {
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$ontrol$modbus$BModbusToSedonaDateTime;
        if (clazz == null) {
            clazz = class$com$ontrol$modbus$BModbusToSedonaDateTime = BModbusToSedonaDateTime.class("[Lcom.ontrol.modbus.BModbusToSedonaDateTime;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

