/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pansheet.details;

import com.tridium.nsedona.pan.BIPanNetwork;
import com.tridium.nsedona.pan.BPanLink;
import com.tridium.nsedona.pan.BPanNode;
import com.tridium.pansheet.PanGraph;
import com.tridium.pansheet.details.DetailsFactory;
import com.tridium.pansheet.digraph.Edge;
import com.tridium.pansheet.viz.BNodeGlyph;
import com.tridium.pansheet.viz.BPanWidget;
import java.util.Iterator;
import java.util.Set;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.BIcon;
import javax.baja.ui.BWidget;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class NodeDetails
implements DetailsFactory.DetailsWidget {
    static final BIcon zeroBars = BIcon.make((String)"module://pansheet/icons/zeroBars.png");
    static final BIcon oneBar = BIcon.make((String)"module://pansheet/icons/oneBar.png");
    static final BIcon twoBars = BIcon.make((String)"module://pansheet/icons/twoBars.png");
    static final BIcon threeBars = BIcon.make((String)"module://pansheet/icons/threeBars.png");
    static final BIcon fourBars = BIcon.make((String)"module://pansheet/icons/fourBars.png");
    static final int IdCol = 0;
    static final int SignalCol = 1;
    static final int SentCol = 2;
    static final int DroppedCol = 3;
    final BPanWidget pan;
    final PanGraph graph;
    final BPanNode node;
    private BPanNode[] neighbors;

    public final BWidget makeWidget() {
        BTable bTable = new BTable((TableModel)new Model());
        bTable.setCellRenderer((TableCellRenderer)new DetailsRenderer(this.pan.getPanNetwork()));
        bTable.setMultipleSelection(false);
        return BTitlePane.makePane((String)this.node.toString(), (BTable)bTable, (String)"Neighbors");
    }

    final BPanLink getLink(BPanNode bPanNode) {
        BPanLink bPanLink = (BPanLink)this.graph.getEdgeData(this.node, bPanNode);
        if (bPanLink == null) {
            throw new IllegalStateException("no link data: " + this.node + " -> " + bPanNode);
        }
        return bPanLink;
    }

    private final /* synthetic */ void this() {
        this.neighbors = new BPanNode[0];
    }

    NodeDetails(BPanWidget bPanWidget, BNodeGlyph bNodeGlyph) {
        this(bPanWidget, bNodeGlyph.getPanNode());
    }

    NodeDetails(BPanWidget bPanWidget, BPanNode bPanNode) {
        this.this();
        this.pan = bPanWidget;
        this.graph = bPanWidget.getPanGraph();
        this.node = bPanNode;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends TableModel {
        private final void init() {
            Set set = NodeDetails.this.graph.getOutEdges(NodeDetails.this.node);
            NodeDetails.this.neighbors = new BPanNode[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                ((NodeDetails)NodeDetails.this).neighbors[n++] = (BPanNode)edge.head;
            }
        }

        public BImage getRowIcon(int n) {
            return BImage.make((BIcon)NodeDetails.this.neighbors[n].getIcon());
        }

        public int getRowCount() {
            return NodeDetails.this.neighbors.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Neighbor";
                }
                case 1: {
                    return DetailsFactory.DetailsWidget.lex.getText("details.signalCol");
                }
                case 2: {
                    return "Sent Packets";
                }
                case 3: {
                    return "Dropped Packets";
                }
            }
            return "??? " + n;
        }

        public Object getValueAt(int n, int n2) {
            BPanNode bPanNode = NodeDetails.this.neighbors[n];
            if (n2 == 0) {
                return bPanNode.getPrimaryId();
            }
            BPanLink bPanLink = NodeDetails.this.getLink(NodeDetails.this.neighbors[n]);
            if (bPanLink.getIgnoreLinkData()) {
                return "N/A";
            }
            switch (n2) {
                case 1: {
                    return Integer.toString(bPanLink.getSignalStrength());
                }
                case 2: {
                    return Integer.toString(bPanLink.getSentPackets());
                }
                case 3: {
                    return Integer.toString(bPanLink.getDroppedPackets());
                }
            }
            return "??? " + n2;
        }

        public Model() {
            this.init();
        }
    }

    static class DetailsRenderer
    extends TableCellRenderer {
        protected final BIPanNetwork network;

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            if (this.isSignalCol(cell)) {
                return this.getFont(cell).width(this.getCellText(cell)) + 12.0 + 20.0;
            }
            return super.getPreferredCellWidth(cell);
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            if (!this.isSignalCol(cell)) {
                super.paintCell(graphics, cell);
                return;
            }
            this.paintCellBackground(graphics, cell);
            double d = 2;
            double d2 = (cell.height - 16.0) / (double)2;
            BImage bImage = this.getSignalIcon(cell);
            graphics.drawImage(bImage, d, d2);
            d += 20.0;
            String string = this.getCellText(cell);
            BFont bFont = this.getFont(cell);
            switch (this.getModel().getColumnAlignment(cell.column).getOrdinal()) {
                case 2: {
                    d = cell.width - (double)2 - bFont.width(string);
                    break;
                }
                case 1: {
                    d = (cell.width - bFont.width(string)) / (double)2;
                    break;
                }
            }
            graphics.setFont(bFont);
            graphics.drawString(string, d, (cell.height + bFont.getAscent() - bFont.getDescent()) / (double)2);
        }

        protected boolean isSignalCol(TableCellRenderer.Cell cell) {
            boolean bl = false;
            if (cell.column == 1) {
                bl = true;
            }
            return bl;
        }

        private final BImage getSignalIcon(TableCellRenderer.Cell cell) {
            Object object = this.getModel().getValueAt(cell.row, cell.column);
            try {
                int n = Integer.parseInt(object.toString());
                switch (this.network.getSignalBars(n).getOrdinal()) {
                    case 0: {
                        return BImage.make((BIcon)zeroBars);
                    }
                    case 1: {
                        return BImage.make((BIcon)oneBar);
                    }
                    case 2: {
                        return BImage.make((BIcon)twoBars);
                    }
                    case 3: {
                        return BImage.make((BIcon)threeBars);
                    }
                    case 4: {
                        return BImage.make((BIcon)fourBars);
                    }
                }
                throw new IllegalStateException();
            }
            catch (NumberFormatException numberFormatException) {
                return BImage.NULL;
            }
        }

        public DetailsRenderer(BIPanNetwork bIPanNetwork) {
            this.network = bIPanNetwork;
        }
    }
}

