/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pansheet.digraph.algo;

import com.tridium.pansheet.digraph.Digraph;
import com.tridium.pansheet.digraph.Edge;
import com.tridium.pansheet.digraph.algo.CycleBreaker;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class DepthFirstCycleBreaker
implements CycleBreaker {
    private Object entryVertex;
    private final HashSet todo;
    private final Stack working;

    public Digraph breakCycles(Digraph digraph) {
        Digraph digraph2 = new Digraph();
        if (digraph.cardinality() == 0) {
            return digraph2;
        }
        this.working.clear();
        this.todo.clear();
        this.todo.addAll(digraph.vertices());
        Object object = this.entryVertex == null ? this.todo.toArray()[0] : this.entryVertex;
        while (!this.todo.isEmpty()) {
            this.doBreakCycles(digraph, digraph2, object);
            Object object2 = object = this.todo.isEmpty() ? null : this.todo.toArray()[0];
        }
        return digraph2;
    }

    private final void doBreakCycles(Digraph digraph, Digraph digraph2, Object object) {
        this.todo.remove(object);
        this.working.add(object);
        Set set = digraph.getOutEdges(object);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Edge edge = (Edge)iterator.next();
            if (this.working.contains(edge.head)) continue;
            edge.addEdge(digraph2);
            this.doBreakCycles(digraph, digraph2, edge.head);
        }
    }

    public DepthFirstCycleBreaker() {
        this(null);
    }

    public DepthFirstCycleBreaker(Object object) {
        this.entryVertex = object;
        this.todo = new HashSet();
        this.working = new Stack();
    }
}

