/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pansheet.viz;

import com.tridium.nsedona.pan.BPanNode;
import com.tridium.pansheet.viz.BPanGlyph;
import com.tridium.pansheet.viz.BPanWidget;
import com.tridium.ui.UiEnv;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BPen;
import javax.baja.gx.Graphics;
import javax.baja.status.BStatus;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BNodeGlyph
extends BPanGlyph {
    public static final Type TYPE;
    private static Lexicon lex;
    private static final double boldHeight;
    private static final double normalHeight;
    public static final int NodeHeight = 24;
    private static final int ImgBuf = 6;
    private static final int FontSize = 10;
    private static final int BaselineX = 4;
    private static final int BaselineY = 10;
    private int flipFlopCount;
    private BPanNode panNode;
    private BBrush titleBrush;
    static /* synthetic */ Class class$com$tridium$pansheet$viz$BNodeGlyph;

    public Type getType() {
        return TYPE;
    }

    public BPanNode getPanNode() {
        return this.panNode;
    }

    public void computePreferredSize() {
        this.setPreferredSize(BNodeGlyph.preferredWidth(this.getPanNode()), BNodeGlyph.preferredHeight(this.getPanNode()));
    }

    public static double preferredHeight(BPanNode bPanNode) {
        return boldHeight + (double)2 * normalHeight;
    }

    public static double preferredWidth(BPanNode bPanNode) {
        BImage bImage = BImage.make((BIcon)bPanNode.getIcon());
        double d = BNodeGlyph.boldFont().width(bPanNode.getPrimaryId());
        double d2 = BNodeGlyph.font().width(bPanNode.getSecondaryId());
        return (double)4 + Math.max(d, d2) + 6.0 + bImage.getWidth() + 6.0;
    }

    public void paint(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        graphics.setBrush(BColor.make((int)204, (int)204, (int)204));
        graphics.fillRect(1.0, 1.0, d - (double)2, d2 - (double)2);
        this.paintTitle(graphics);
        this.paintStatus(graphics);
        if (this.isSelected()) {
            this.paintOutline(graphics, BColor.blue, 3);
        } else {
            this.paintOutline(graphics, BColor.make((int)0), 1.0);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintTitle(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        BImage bImage = BImage.make((BIcon)this.panNode.getIcon());
        graphics.push();
        try {
            graphics.clip(0.0, 0.0, d - bImage.getWidth() - 12.0, d2);
            graphics.setBrush(this.titleBrush);
            graphics.setFont(BNodeGlyph.boldFont());
            graphics.drawString(this.getPanNode().getPrimaryId(), (double)4, 10.0);
            graphics.setFont(BNodeGlyph.font());
            graphics.drawString(this.getPanNode().getSecondaryId(), (double)4, 20.0);
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var8_7 = null;
        }
        graphics.pop();
        graphics.drawImage(bImage, d - 6.0 - bImage.getWidth(), (boldHeight + normalHeight - bImage.getHeight()) / (double)2);
    }

    protected void paintOutline(Graphics graphics, BColor bColor, double d) {
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        graphics.setBrush(bColor);
        graphics.setPen(BPen.make((double)d, (int)101, (int)203, null));
        graphics.strokeLine((double)2, 0.0, d2 - (double)3, 0.0);
        graphics.strokeLine((double)2, d3 - 1.0, d2 - (double)3, d3 - 1.0);
        graphics.strokeLine(0.0, (double)2, 0.0, d3 - (double)3);
        graphics.strokeLine(d2 - 1.0, (double)2, d2 - 1.0, d3 - (double)3);
        graphics.strokeLine(0.0, (double)2, (double)2, 0.0);
        graphics.strokeLine(d2 - (double)3, 0.0, d2 - 1.0, (double)2);
        graphics.strokeLine(0.0, d3 - (double)3, (double)2, d3 - 1.0);
        graphics.strokeLine(d2 - 1.0, d3 - (double)3, d2 - (double)3, d3 - 1.0);
        graphics.setBrush(BColor.black);
        graphics.setPen(BPen.DEFAULT);
        graphics.strokeLine(0.0, d3 - normalHeight, d2, d3 - normalHeight);
    }

    protected void paintStatus(Graphics graphics) {
        BStatus bStatus = this.getPanNode().getStatus();
        Lexicon lexicon = Lexicon.make((String)"baja");
        BColor bColor = null;
        BColor bColor2 = null;
        String string = null;
        if (bStatus.isDisabled()) {
            bColor = (BColor)BStatus.disabledFg;
            bColor2 = (BColor)BStatus.disabledBg;
            string = lexicon.getText("Status.disabled");
        } else if (bStatus.isFault()) {
            bColor = (BColor)BStatus.faultFg;
            bColor2 = (BColor)BStatus.faultBg;
            string = lexicon.getText("Status.fault");
        } else if (bStatus.isDown()) {
            bColor = (BColor)BStatus.downFg;
            bColor2 = (BColor)BStatus.downBg;
            string = lexicon.getText("Status.down");
        } else {
            return;
        }
        double d = this.getWidth();
        double d2 = this.getHeight();
        graphics.setFont(BNodeGlyph.font());
        graphics.setBrush(bColor2);
        graphics.fillRect(0.0, d2 - normalHeight, (double)4 + BNodeGlyph.font().width(string) + (double)4, normalHeight);
        graphics.setBrush(bColor);
        graphics.drawString(string, (double)4, d2 - BNodeGlyph.font().getDescent());
    }

    public void animate() {
        if (this.flipFlopCount > 0) {
            --this.flipFlopCount;
            this.titleBrush = (this.flipFlopCount & 1) == 0 ? BColor.make((int)0).toBrush() : BColor.red.toBrush();
            this.getParentWidget().repaint();
        }
        super.animate();
    }

    public void visualCue() {
        this.flipFlopCount = 10;
    }

    public String toString(Context context) {
        return this.panNode.toString() + ": " + this.boundsToString();
    }

    protected static BFont font() {
        return BNodeGlyph.getFont(BFont.make((String)lex.getText("ps.font")), 10);
    }

    protected static BFont boldFont() {
        return BNodeGlyph.getFont(BFont.make((String)lex.getText("ps.font.bold")), 10);
    }

    private static final BFont getFont(BFont bFont, int n) {
        if (UiEnv.get().isMicroEdition()) {
            return BFont.make((String)bFont.getName(), (double)Math.max(10, n), (int)bFont.getStyle());
        }
        return BFont.make((String)bFont.getName(), (double)n, (int)bFont.getStyle());
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.flipFlopCount = 0;
        this.titleBrush = BColor.make((int)0).toBrush();
    }

    public BNodeGlyph() {
        this.this();
    }

    public BNodeGlyph(BPanWidget bPanWidget) {
        this(bPanWidget, new BPanNode());
    }

    public BNodeGlyph(BPanWidget bPanWidget, BPanNode bPanNode) {
        super(bPanWidget);
        this.this();
        this.panNode = bPanNode;
    }

    static {
        Class clazz = class$com$tridium$pansheet$viz$BNodeGlyph;
        if (clazz == null) {
            clazz = class$com$tridium$pansheet$viz$BNodeGlyph = BNodeGlyph.class("[Lcom.tridium.pansheet.viz.BNodeGlyph;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$com$tridium$pansheet$viz$BNodeGlyph;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$pansheet$viz$BNodeGlyph = BNodeGlyph.class("[Lcom.tridium.pansheet.viz.BNodeGlyph;", false);
        }
        lex = Lexicon.make((Class)clazz2);
        boldHeight = BNodeGlyph.boldFont().getAscent() + BNodeGlyph.boldFont().getDescent() + BNodeGlyph.boldFont().getLeading();
        normalHeight = BNodeGlyph.font().getAscent() + BNodeGlyph.font().getDescent() + BNodeGlyph.font().getLeading();
    }
}

