/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.bacnet.ui.point;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BBacnetDiscoverPointsJob;
import com.tridium.bacnet.job.BDiscoveryPoint;
import com.tridium.bacnet.job.BDiscoveryPointTable;
import com.tridium.bacnet.ui.point.BBacnetPointManager;
import com.tridium.bacnet.ui.point.PointLearn;
import java.io.IOException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.util.PropertyInfo;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BTypeSpec;
import javax.baja.util.TextUtil;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.MgrEditRow;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OntrolBacnetPointLearn
extends PointLearn {
    static /* synthetic */ Class class$com$tridium$bacnet$job$BDiscoveryPoint;

    BBacnetDiscoverPointsJob getDiscoveryJob() {
        return (BBacnetDiscoverPointsJob)this.getJob();
    }

    public void toRow(Object object, MgrEditRow mgrEditRow) throws Exception {
        BWbShell bWbShell = this.getManager().getWbShell();
        bWbShell.enterBusy();
        try {
            BBacnetPointManager bBacnetPointManager = (BBacnetPointManager)this.getManager();
            BDiscoveryPoint bDiscoveryPoint = this.lr(object);
            BControlPoint bControlPoint = (BControlPoint)mgrEditRow.getTarget();
            int n = bDiscoveryPoint.getPropertyId();
            PropertyInfo propertyInfo = bBacnetPointManager.getDevice().getPropertyInfo(bDiscoveryPoint.getObjectId().getObjectType(), n);
            String string = bDiscoveryPoint.getObjectName();
            if (string == null || string.length() == 0) {
                string = bDiscoveryPoint.getObjectId().toString();
            }
            if (bDiscoveryPoint.getPropertyId() != 85) {
                string = string + '-' + bDiscoveryPoint.getPropertyIdentifier();
            }
            if (bDiscoveryPoint.getIndex().length() > 0) {
                string = string + '_' + bDiscoveryPoint.getIndex();
            }
            string = SlotPath.escape((String)TextUtil.replace((String)string, (String)"/", (String)"."));
            mgrEditRow.setDefaultName(string);
            mgrEditRow.setCell(bBacnetPointManager.getModel().getColumn(5), (BValue)bDiscoveryPoint.getObjectId());
            mgrEditRow.setCell(bBacnetPointManager.getModel().getColumn(6), (BValue)BDynamicEnum.make((int)n, (BEnumRange)BEnumRange.make((Type)BBacnetPropertyIdentifier.TYPE)));
            if (bDiscoveryPoint.getIndex().length() > 0) {
                mgrEditRow.setCell(bBacnetPointManager.getModel().getColumn(7), (BValue)BInteger.make((String)bDiscoveryPoint.getIndex()));
            }
            if (propertyInfo != null) {
                mgrEditRow.setCell(bBacnetPointManager.getModel().getColumn(9), (BValue)BString.make((String)propertyInfo.getDataType()));
            }
            String string2 = "readonly";
            if (bControlPoint.isWritablePoint()) {
                string2 = "writable";
            }
            mgrEditRow.setCell(bBacnetPointManager.getModel().getColumn(11), (BValue)BString.make((String)string2));
            mgrEditRow.setCell(bBacnetPointManager.getModel().getColumn(10), (BValue)BString.make((String)"unsubscribed"));
            boolean bl = false;
            if (bControlPoint.isWritablePoint()) {
                int n2 = bDiscoveryPoint.getObjectId().getObjectType();
                if (n2 == 1 || n2 == 4 || n2 == 14) {
                    bl = true;
                }
                if (n2 == 2 || n2 == 5 || n2 == 19) {
                    bl = this.getDiscoveryJob().checkForPriorityArray(bDiscoveryPoint.getObjectId()).getBoolean();
                }
                if (bl) {
                    mgrEditRow.setCell(bBacnetPointManager.getModel().getColumn(4), (BValue)BBoolean.make((boolean)false));
                }
            }
            BFacets bFacets = bControlPoint.getFacets();
            BFacets bFacets2 = bDiscoveryPoint.getFacets();
            if (bFacets2 == null || bFacets2.isNull()) {
                bFacets2 = this.getDiscoveryJob().discoverFacets(bDiscoveryPoint.getObjectId());
            }
            if (propertyInfo != null) {
                if (propertyInfo.isEnum()) {
                    BEnum bEnum = (BEnum)BTypeSpec.make((String)propertyInfo.getType()).getInstance();
                    BEnumRange bEnumRange = bEnum.getRange();
                    if (propertyInfo.isExtensible()) {
                        bEnumRange = bBacnetPointManager.getDevice().getEnumerationList().getEnumRange(propertyInfo.getType());
                    }
                    bFacets2 = BFacets.make((BFacets)bFacets2, (String)"range", (BIDataValue)bEnumRange);
                }
                if (propertyInfo.getFacetControl().equals("all")) {
                    bFacets = bFacets2;
                } else if (propertyInfo.getFacetControl().equals("units")) {
                    bFacets = BFacets.make((String)"units", (BIDataValue)((BUnit)bFacets2.getFacet("units")));
                } else if (!propertyInfo.getFacetControl().equals("no") && bFacets2 != null && !bFacets2.isNull()) {
                    bFacets = bFacets2;
                }
            }
            mgrEditRow.setCell(bBacnetPointManager.getModel().getColumn(12), (BValue)bFacets);
            bFacets = BFacets.makeRemove((BFacets)bFacets, (String)"priPV");
            mgrEditRow.setCell(bBacnetPointManager.getModel().getColumn(13), (BValue)bFacets);
        }
        catch (Exception exception) {
            bWbShell.exitBusy();
            throw exception;
        }
        bWbShell.exitBusy();
    }

    public BImage getIcon(Object object) {
        BBacnetPointManager bBacnetPointManager = (BBacnetPointManager)this.getManager();
        BDiscoveryPoint bDiscoveryPoint = this.lr(object);
        try {
            int n = bDiscoveryPoint.getPropertyId();
            int n2 = -1;
            PropertyInfo propertyInfo = bBacnetPointManager.getDevice().getPropertyInfo(bDiscoveryPoint.getObjectId().getObjectType(), n);
            n2 = propertyInfo != null ? propertyInfo.getAsnType() : AsnUtil.getAsnType((Type)bDiscoveryPoint.getValue().getType());
            switch (n2) {
                case -2: {
                    return BImage.make((String)"module://icons/x16/database.png");
                }
                case 0: {
                    return BImage.make((String)"module://icons/x16/control/stringPoint.png");
                }
                case 1: {
                    return BImage.make((String)"module://icons/x16/control/booleanPoint.png");
                }
                case 2: 
                case 3: {
                    return BImage.make((String)"module://icons/x16/control/enumPoint.png");
                }
                case 4: 
                case 5: {
                    return BImage.make((String)"module://icons/x16/control/numericPoint.png");
                }
                case 6: 
                case 7: 
                case 8: {
                    return BImage.make((String)"module://icons/x16/control/stringPoint.png");
                }
                case 9: {
                    if (propertyInfo != null && propertyInfo.getType().equals("bacnet:BacnetBinaryPv")) {
                        return BImage.make((String)"module://icons/x16/control/booleanPoint.png");
                    }
                    return BImage.make((String)"module://icons/x16/control/enumPoint.png");
                }
                case -6: 
                case -5: 
                case -4: 
                case -3: 
                case -1: 
                case 10: 
                case 11: 
                case 12: {
                    return BImage.make((String)"module://icons/x16/control/stringPoint.png");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error getting icon for discovery point:" + bDiscoveryPoint);
        }
        return BImage.make((String)"module://bacnet/com/tridium/bacnet/ui/icons/bacObject.png");
    }

    public Object[] getChildren(Object object) {
        try {
            BDiscoveryPoint bDiscoveryPoint = this.lr(object);
            if (bDiscoveryPoint.getPropertyId() == 211) {
                BDiscoveryPointTable bDiscoveryPointTable = this.getDiscoveryJob().discover(bDiscoveryPoint);
                Class clazz = class$com$tridium$bacnet$job$BDiscoveryPoint;
                if (clazz == null) {
                    clazz = class$com$tridium$bacnet$job$BDiscoveryPoint = OntrolBacnetPointLearn.class("[Lcom.tridium.bacnet.job.BDiscoveryPoint;", false);
                }
                BDiscoveryPoint[] bDiscoveryPointArray = (BDiscoveryPoint[])bDiscoveryPointTable.getChildren(clazz);
                Object[] objectArray = new BDiscoveryPoint[bDiscoveryPointArray.length];
                int n = 0;
                while (n < bDiscoveryPointArray.length) {
                    BDiscoveryPoint bDiscoveryPoint2 = bDiscoveryPointArray[n];
                    BBacnetObjectIdentifier bBacnetObjectIdentifier = (BBacnetObjectIdentifier)bDiscoveryPoint2.getObjectId().decodeFromString(bDiscoveryPoint2.getValue().toString());
                    BDiscoveryPoint bDiscoveryPoint3 = new BDiscoveryPoint(bDiscoveryPoint2.getObjectName(), bBacnetObjectIdentifier, "presentValue", null, null, true);
                    bDiscoveryPointTable = this.getDiscoveryJob().discover(bDiscoveryPoint3);
                    Class clazz2 = class$com$tridium$bacnet$job$BDiscoveryPoint;
                    if (clazz2 == null) {
                        clazz2 = OntrolBacnetPointLearn.class("[Lcom.tridium.bacnet.job.BDiscoveryPoint;", false);
                    }
                    BDiscoveryPoint[] bDiscoveryPointArray2 = (BDiscoveryPoint[])bDiscoveryPointTable.getChildren(clazz2);
                    String string = new String();
                    BString bString = BString.DEFAULT;
                    int n2 = 0;
                    while (n2 < bDiscoveryPointArray2.length) {
                        BDiscoveryPoint bDiscoveryPoint4 = bDiscoveryPointArray2[n2];
                        if (bDiscoveryPoint4.getPropertyId() == 77) {
                            string = bDiscoveryPoint4.getValue().toString();
                        } else if (bDiscoveryPoint4.getPropertyId() == 85) {
                            bString = bDiscoveryPoint4.getValue();
                        }
                        ++n2;
                    }
                    BBacnetObjectIdentifier bBacnetObjectIdentifier2 = (BBacnetObjectIdentifier)bDiscoveryPoint2.getObjectId().decodeFromString(bDiscoveryPoint2.getValue().toString());
                    objectArray[n] = new BDiscoveryPoint(string, bBacnetObjectIdentifier2, "presentValue", (BValue)bString, BFacets.NULL, true);
                    ++n;
                }
                return objectArray;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return super.getChildren(object);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public OntrolBacnetPointLearn(BBacnetPointManager bBacnetPointManager) {
        super(bBacnetPointManager);
    }
}

