/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona;

import com.ontrol.sedona.OntFontUtil;
import com.ontrol.sedona.OntImageUtil;
import com.tridium.nsedona.sox.BSoxSession;
import com.tridium.nsedona.sys.BISedonaSpace;
import java.io.File;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BFont;
import javax.baja.naming.BOrd;
import javax.baja.space.BSpace;
import javax.baja.ui.BProgressDialog;
import javax.baja.util.Array;
import sedona.sox.ISoxComm;
import sedona.sox.SoxClient;
import sedona.sox.SoxException;
import sedona.sox.SoxFile;

public class FileTransferW
extends BProgressDialog.Worker
implements ISoxComm.TransferListener {
    SoxClient soxclient;
    boolean cancel;
    int totalSize;
    int transferredSize;
    boolean isGet = false;
    Array filesArray = new Array(File.class);
    Array foldersArray = new Array(String.class);

    public FileTransferW(SoxClient soxClient, boolean bl) {
        this.soxclient = soxClient;
        this.isGet = bl;
    }

    public FileTransferW(BISedonaSpace bISedonaSpace, boolean bl) {
        this.soxclient = ((BSoxSession)((BSpace)bISedonaSpace).getSession()).getClient();
        this.isGet = bl;
    }

    public FileTransferW(BISedonaSpace bISedonaSpace, boolean bl, File file, String string) {
        this.soxclient = ((BSoxSession)((BSpace)bISedonaSpace).getSession()).getClient();
        this.isGet = bl;
        this.addFile(file, string);
    }

    public void addFile(BOrd bOrd, String string) {
        BFileSystem bFileSystem = BFileSystem.INSTANCE;
        File file = bFileSystem.pathToLocalFile(bOrd.resolve().getFilePath());
        this.filesArray.add((Object)file);
        this.foldersArray.add((Object)string);
    }

    public void addFile(File file, String string) {
        this.filesArray.add((Object)file);
        this.foldersArray.add((Object)string);
    }

    public void addFileArray(Array array, String string) {
        this.filesArray.addAll(array);
        for (int i = 0; i < array.size(); ++i) {
            this.foldersArray.add((Object)string);
        }
    }

    public void addFontFile(BFont bFont) {
        File file = OntFontUtil.nativeFileForFont(bFont);
        if (file != null) {
            this.addFile(file, "fonts");
        }
    }

    public void addImageFile(String string) {
        File file = new File(OntImageUtil.oxImageBank, string);
        File file2 = OntImageUtil.convertImageToNativeFormat(file);
        if (file2 != null) {
            this.addFile(file2, "images");
        }
    }

    public int calculateTotalSize() {
        if (this.isGet) {
            return this.getFileCount();
        }
        File[] fileArray = (File[])this.filesArray.trim();
        int n = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            n = (int)((long)n + fileArray[i].length());
        }
        return n;
    }

    public int getFileCount() {
        return this.filesArray.size();
    }

    public void progress(int n, int n2) {
        int n3 = this.transferredSize;
        if (!this.isGet) {
            n3 += n;
        }
        int n4 = 100 * n3 / this.totalSize;
        this.updateProgress(n4);
    }

    public void doRun() throws Exception {
        String[] stringArray = (String[])this.foldersArray.trim();
        File[] fileArray = (File[])this.filesArray.trim();
        this.cancel = false;
        this.transferredSize = 0;
        this.totalSize = this.calculateTotalSize();
        for (int i = 0; i < fileArray.length && !this.cancel; ++i) {
            File file = fileArray[i];
            if (this.isGet) {
                this.updateProgress("Getting " + file.getName());
                try {
                    this.soxclient.getFile(stringArray[i] + "/" + file.getName(), SoxFile.make((File)file), null, (ISoxComm.TransferListener)this);
                }
                catch (SoxException soxException) {
                    file.delete();
                    soxException.printStackTrace();
                }
                ++this.transferredSize;
                continue;
            }
            if (!file.exists()) continue;
            this.updateProgress("Transferring " + file.getName());
            String string = stringArray[i];
            if (string.length() > 0) {
                string = string + "/";
            }
            this.soxclient.putFile(string + file.getName(), SoxFile.make((File)file), null, (ISoxComm.TransferListener)this);
            this.transferredSize = (int)((long)this.transferredSize + file.length());
        }
    }

    public void doCancel() throws Exception {
        this.cancel = true;
        this.updateProgress("Aborting transfers...");
    }
}

