/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona;

import java.io.File;
import java.util.Set;
import javax.baja.file.FileUtil;
import javax.baja.gx.BFont;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.util.Array;
import javax.baja.util.SortUtil;
import sedona.Component;
import sedona.Env;
import sedona.offline.OfflineApp;

public class OntFontUtil {
    public static File fontBank = new File(Env.home, "ontrol/fontBank");
    public static String DEFAULT_FONT_STR = SlotPath.escape((String)"16pt Tahoma");
    public static BFont DEFAULT_FONT = BFont.make((String)"16pt Tahoma");

    public static BEnumRange getSystemFonts() {
        Array array = new Array(String.class);
        Array array2 = new Array(BDouble.class);
        array.add((Object)DEFAULT_FONT_STR);
        array2.add((Object)BDouble.make((double)DEFAULT_FONT.getSize()));
        if (!fontBank.exists()) {
            fontBank.mkdirs();
        }
        File[] fileArray = fontBank.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                String string = FileUtil.getBase((String)fileArray[i].getName());
                BFont bFont = BFont.make((String)string);
                string = SlotPath.escape((String)string);
                if (bFont.isNull() || array.contains((Object)string)) continue;
                array.add((Object)string);
                array2.add((Object)BDouble.make((double)bFont.getSize()));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object[] objectArray = new String[]{DEFAULT_FONT_STR};
        if (array.size() > 0) {
            objectArray = (String[])array.trim();
            SortUtil.sort((Object[])array2.trim(), (Object[])objectArray);
        }
        return BEnumRange.make((String[])objectArray);
    }

    public static String makeFontString(int n, int n2, int n3) {
        boolean bl = (n3 & 1) > 0;
        boolean bl2 = (n3 & 2) > 0;
        boolean bl3 = (n3 & 4) > 0;
        String string = new String();
        if (bl) {
            string = string + "bold ";
        }
        if (bl2) {
            string = string + "italic ";
        }
        if (bl3) {
            string = string + "underline ";
        }
        string = string + n2 + "pt ";
        string = string + (n == 0 ? "Tahoma" : "Lato");
        return string;
    }

    public static BValue makeFontAttr(BFont bFont) {
        int n = bFont.isBold() ? 1 : 0;
        n += bFont.isItalic() ? 2 : 0;
        return BInteger.make((int)(n += bFont.isUnderline() ? 4 : 0));
    }

    public static File nativeFileForFont(BFont bFont) {
        File file;
        String string = "";
        if (bFont.isBold()) {
            string = "bold ";
        }
        if (bFont.isItalic()) {
            string = string + "italic ";
        }
        if ((file = new File(fontBank, string = string + (int)bFont.getSize() + "pt " + bFont.getName() + ".bin")).exists()) {
            return file;
        }
        return null;
    }

    public static void addFontNamesToSet(OfflineApp offlineApp, Component component, Set<String> set) {
        int n;
        if (component.type.is(offlineApp.schema.type("ontrolOx::Label"))) {
            int n2 = component.getInt("fontName");
            n = component.getInt("fontSize");
            int n3 = component.getInt("fontAttributes");
            String string = OntFontUtil.makeFontString(n2, n, n3);
            set.add(string);
        }
        if (component.type.is(offlineApp.schema.type("ontrolOx::ScheduleLabelSet"))) {
            set.add("9pt Tahoma");
            set.add("12pt Tahoma");
        }
        Component[] componentArray = component.getChildren();
        for (n = 0; n < componentArray.length; ++n) {
            OntFontUtil.addFontNamesToSet(offlineApp, componentArray[n], set);
        }
    }
}

