/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona;

import com.ontrol.sedona.ox.BOxEditor;
import com.ontrol.sedona.types.BImageFileOx;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import javax.baja.file.FileUtil;
import javax.imageio.ImageIO;
import sedona.Component;
import sedona.Env;
import sedona.Slot;
import sedona.offline.OfflineApp;

public class OntImageUtil {
    public static File oxImageBank = new File(Env.home, "ontrol/imageBank");

    public static void makeDirectories() {
        File file = oxImageBank;
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(file, "natives")).exists()) {
            file.mkdirs();
        }
    }

    public static File convertNativeToPng(File file) {
        try {
            String string = file.getName();
            string = string.substring(0, string.lastIndexOf(46)) + ".png";
            File file2 = new File(oxImageBank, string);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)OntImageUtil.convertNativeToPng(new FileInputStream(file), file.length(), file.getName());
            fileOutputStream.write(byteArrayOutputStream.toByteArray());
            fileOutputStream.close();
            return file2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(fileNotFoundException.getLocalizedMessage());
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static OutputStream convertNativeToPng(InputStream inputStream, long l, String string) {
        byte[] byArray = new byte[32];
        byte[] byArray2 = new byte[1];
        byte[] byArray3 = new byte[2];
        byte[] byArray4 = new byte[2];
        byte[] byArray5 = new byte[27];
        byte[] byArray6 = new byte[(int)l - 64];
        try {
            inputStream.read(byArray);
            inputStream.read(byArray2);
            inputStream.read(byArray3);
            inputStream.read(byArray4);
            inputStream.read(byArray5);
            inputStream.read(byArray6);
            inputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n = (byArray3[1] << 8) + (0xFF & byArray3[0]);
        int n2 = (byArray4[1] << 8) + (0xFF & byArray4[0]);
        int n3 = byArray2[0] == 0 ? 1 : 2;
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = 255;
                int n5 = i * n + j;
                if (byArray2[0] == 0) {
                    n5 = 2 * n5;
                } else {
                    n4 = byArray6[3 * n5];
                    n5 = 3 * n5 + 1;
                }
                int n6 = (0xFF & byArray6[n5]) + ((0xFF & byArray6[n5 + 1]) << 8);
                int n7 = ((n6 & 0xF800) >> 11) * 255 / 31;
                int n8 = ((n6 & 0x7E0) >> 5) * 255 / 63;
                int n9 = ((n6 & 0x1F) << 0) * 255 / 31;
                int n10 = n4 << 24 | n7 << 16 | n8 << 8 | n9;
                bufferedImage.setRGB(j, i, n10);
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream;
    }

    public static File convertImageToNativeFormat(File file) {
        String string = file.getName();
        string = string.substring(0, string.lastIndexOf(46));
        File file2 = new File(file.getParent(), "natives");
        if (!file2.exists()) {
            file2.mkdir();
        }
        File file3 = new File(file2, string + ".bin");
        return OntImageUtil.convertImageToNativeFormat(file, file3);
    }

    public static File convertImageToNativeFormat(File file, File file2) {
        String string = file.getName();
        String string2 = string.substring(0, string.lastIndexOf("."));
        try {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            BufferedImage bufferedImage = ImageIO.read(file);
            int n2 = bufferedImage.getTransparency() == 3 ? 1 : 0;
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            if (n3 >= 320 && n4 >= 240) {
                n2 = 0;
            }
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.print(string2);
            for (int i = 32 - string2.length(); i > 0; --i) {
                fileOutputStream.write(0);
            }
            fileOutputStream.write(n2);
            fileOutputStream.write(n3 & 0xFF);
            fileOutputStream.write(n3 >> 8);
            fileOutputStream.write(n4 & 0xFF);
            fileOutputStream.write(n4 >> 8);
            for (n = 0; n < 27; ++n) {
                fileOutputStream.write(0);
            }
            for (n = 0; n < n4; ++n) {
                for (int i = 0; i < n3; ++i) {
                    int n5 = bufferedImage.getRGB(i, n);
                    Color color = new Color(n5, true);
                    int n6 = color.getRed() >> 3;
                    int n7 = color.getGreen() >> 2;
                    int n8 = color.getBlue() >> 3;
                    int n9 = n6 << 11 | n7 << 5 | n8;
                    if (n2 == 1) {
                        fileOutputStream.write(color.getAlpha());
                    }
                    fileOutputStream.write(n9 & 0xFF);
                    fileOutputStream.write(n9 >> 8);
                }
            }
            printStream.close();
            return file2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static File convertToPng(File file) throws FileNotFoundException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        File file2 = new File(oxImageBank, FileUtil.getBase((String)file.getName()) + ".png");
        if (ImageIO.write((RenderedImage)ImageIO.read(file), "png", file2)) {
            return file2;
        }
        return null;
    }

    public static BImageFileOx makeImageFileOx(BOxEditor bOxEditor, String string) {
        if (string.isEmpty()) {
            return BImageFileOx.makeNull();
        }
        BImageFileOx bImageFileOx = BImageFileOx.make(string, "png");
        if (!bImageFileOx.isNull() && bImageFileOx.getFile() == null) {
            File file = new File(oxImageBank, "natives/" + bImageFileOx.getImageFileName() + ".bin");
            bOxEditor.receiveFile(file, "images");
            if (file.exists()) {
                OntImageUtil.convertNativeToPng(file);
            }
        }
        return bImageFileOx;
    }

    public static HashSet<String> getImageNamesInApp(OfflineApp offlineApp) {
        HashSet<String> hashSet = new HashSet<String>();
        OntImageUtil.addImageNamesToSet(offlineApp, (Component)offlineApp, hashSet);
        return hashSet;
    }

    public static void addImageNamesToSet(OfflineApp offlineApp, Component component, Set<String> set) {
        int n;
        Slot[] slotArray;
        if (component.type.is(offlineApp.schema.type("ontrolOx::Widget")) || component.type.is(offlineApp.schema.type("ontrolOx::OxPage"))) {
            slotArray = component.type.slots;
            for (n = 0; n < slotArray.length; ++n) {
                String string;
                Slot slot = slotArray[n];
                if (slot.name.endsWith("mageFileName")) {
                    string = component.getStr(slot);
                    if (string.isEmpty()) continue;
                    set.add(string);
                    continue;
                }
                if (!slot.name.endsWith("mageFileNamePrefix") || (string = component.getStr(slot)).isEmpty()) continue;
                for (int i = 0; i < component.getInt("maxIndex"); ++i) {
                    set.add(string + i);
                }
            }
        }
        slotArray = component.getChildren();
        for (n = 0; n < slotArray.length; ++n) {
            OntImageUtil.addImageNamesToSet(offlineApp, (Component)slotArray[n], set);
        }
    }
}

