/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.io.ByteBuffer;
import javax.baja.log.Log;
import javax.baja.sedona.dasp.BRouteHandler;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;
import sedona.dasp.DaspMsg;

public class BSerialPtpRouter
extends BRouteHandler
implements BISerialHelperParent {
    public static final Property interMessageDelay = BSerialPtpRouter.newProperty((int)0, (int)10, null);
    public static final Property serialPortConfig = BSerialPtpRouter.newProperty((int)0, (BValue)new BSerialHelper(), null);
    public static final Action openPort = BSerialPtpRouter.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BSerialPtpRouter.class);
    public static final Log logger = Log.getLog((String)"SerialPtpRouter");
    private BISerialPort serialPort;
    private InputStream in;
    private OutputStream out;
    private reroute reRoute = new reroute();
    private route route = new route();
    private boolean isAlive = false;

    public int getInterMessageDelay() {
        return this.getInt(interMessageDelay);
    }

    public void setInterMessageDelay(int n) {
        this.setInt(interMessageDelay, n, null);
    }

    public BSerialHelper getSerialPortConfig() {
        return (BSerialHelper)this.get(serialPortConfig);
    }

    public void setSerialPortConfig(BSerialHelper bSerialHelper) {
        this.set(serialPortConfig, (BValue)bSerialHelper, null);
    }

    public void openPort() {
        this.invoke(openPort, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public boolean canRoute(String string) {
        return "ip".equals(string);
    }

    public void reopenPort() {
        this.doOpenPort();
    }

    public void stationStarted() throws Exception {
        this.doOpenPort();
        this.route.start();
        this.reRoute.start();
        super.stationStarted();
    }

    public void stopped() throws Exception {
        this.in.close();
        this.out.close();
        if (this.serialPort != null) {
            this.serialPort.close();
        }
        super.stopped();
    }

    public void doOpenPort() {
        System.out.println(".........opening port");
        try {
            this.serialPort = this.getSerialPortConfig().open(this.getName());
            BISerialService bISerialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            this.serialPort.enableReceiveTimeout(bISerialService.getMinTimeout());
            this.in = this.serialPort.getInputStream();
            this.out = this.serialPort.getOutputStream();
            this.isAlive = true;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            unsupportedOperationException.printStackTrace();
        }
        catch (Exception exception) {
            logger.error("Unable top open port " + this.getSerialPortConfig().getPortName() + ". " + exception.getLocalizedMessage());
        }
    }

    public void route(DaspMsg daspMsg, String string) {
        this.reRoute.rQueue.enqueue((Object)daspMsg);
    }

    class route
    extends Thread {
        ByteBuffer inBuffer = new ByteBuffer(0);

        route() {
        }

        @Override
        public void run() {
            this.routeMessages();
        }

        private final void routeMessages() {
            byte[] byArray = new byte[512];
            this.inBuffer.reset();
            while (true) {
                if (BSerialPtpRouter.this.isAlive) {
                    try {
                        int n = BSerialPtpRouter.this.in.read(byArray);
                        if (n > 0) {
                            this.inBuffer.write(byArray, 0, n);
                            try {
                                com.ontrol.sedona.comm.BSerialPtpRouter$route.sleep(2L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        int n2 = this.inBuffer.getLength();
                        if (n2 <= 0) continue;
                        byte[] byArray2 = new byte[n2];
                        this.inBuffer.read(byArray2, 0, n2);
                        this.inBuffer.reset();
                        logger.trace(">> " + n2, byArray2);
                        BSerialPtpRouter.this.reroute(DaspMsg.decode((byte[])byArray2, (int)n2));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    continue;
                }
                this.inBuffer.reset();
            }
        }
    }

    class reroute
    extends Thread {
        private final Queue rQueue = new Queue(10);

        reroute() {
        }

        @Override
        public void run() {
            this.rerouteMessages();
        }

        private void rerouteMessages() {
            while (true) {
                if (BSerialPtpRouter.this.isAlive) {
                    try {
                        DaspMsg daspMsg = (DaspMsg)this.rQueue.dequeue(10);
                        if (daspMsg == null) continue;
                        byte[] byArray = new byte[512];
                        int n = daspMsg.encode(byArray);
                        logger.trace("<< " + n, byArray, 0, n);
                        try {
                            BSerialPtpRouter.this.out.write(byArray, 0, n);
                            reroute.sleep(BSerialPtpRouter.this.getInterMessageDelay());
                        }
                        catch (IOException iOException) {
                            BSerialPtpRouter.this.isAlive = false;
                            iOException.printStackTrace();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                this.rQueue.clear();
                BSerialPtpRouter.this.doOpenPort();
            }
        }
    }
}

