/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.fieldeditors;

import com.ontrol.sedona.types.BOxText;
import com.tridium.ui.BOptionDialog;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BOxTextFE
extends BWbFieldEditor {
    public static final Action valueChanged = BOxTextFE.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BOxTextFE.class);
    BOxText obj;
    int fieldWidth;
    int maxItems;
    boolean usePrefix;
    boolean isSimpleText;
    String[] itemLabels = new String[]{"Text"};
    BGridPane valuesPane = new BGridPane(4);
    BTextField prefix = new BTextField();
    BTextField suffix = new BTextField();
    BTextField[] values;
    BLabel remaining = new BLabel("Remaining .. characters");
    BLabel warning = new BLabel(BImage.make((String)"module://icons/x16/warning.png"));
    private static BBrush solidBlack = BBrush.makeSolid((BColor)BColor.black);
    private static BBrush solidRed = BBrush.makeSolid((BColor)BColor.red);

    public void valueChanged() {
        this.invoke(valueChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject bObject, Context context) {
        Object object;
        this.obj = (BOxText)bObject;
        BFacets bFacets = context.getFacets();
        this.fieldWidth = bFacets.geti("fieldWidth", 8);
        this.isSimpleText = bFacets.getb("isSimpleText", false);
        if (!this.isSimpleText) {
            this.maxItems = bFacets.geti("maxItems", 0);
            this.usePrefix = bFacets.getb("usePrefix", true);
            object = bFacets.gets("itemLabels", null);
            this.itemLabels = object == null ? null : ((String)object).split(";");
        }
        object = new BGridPane(2);
        object.add(null, (BValue)new BLabel("prefix"));
        object.add(null, (BValue)this.prefix);
        object.setHalign(BHalign.left);
        this.composeValuesPane();
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)new BLabel("suffix"));
        bGridPane.add(null, (BValue)this.suffix);
        bGridPane.setHalign(BHalign.left);
        BEdgePane bEdgePane = new BEdgePane((BWidget)(this.usePrefix ? object : new BNullWidget()), (BWidget)(this.usePrefix ? bGridPane : new BNullWidget()), (BWidget)new BNullWidget(), (BWidget)new BNullWidget(), (BWidget)this.valuesPane);
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.add(null, (BValue)this.warning);
        bGridPane2.add(null, (BValue)this.remaining);
        this.prefix.setText(this.obj.getPrefixValue());
        this.suffix.setText(this.obj.getSuffixValue());
        this.linkTo((BComponent)this.prefix, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.suffix, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo((BComponent)this.prefix, (Slot)BTextField.textModified, (Slot)valueChanged);
        this.linkTo((BComponent)this.suffix, (Slot)BTextField.textModified, (Slot)valueChanged);
        this.setContent((BWidget)new BEdgePane((BWidget)new BNullWidget(), (BWidget)bGridPane2, (BWidget)new BNullWidget(), (BWidget)new BNullWidget(), (BWidget)bEdgePane));
        this.updateFooter();
    }

    protected BObject doSaveValue(BObject bObject, Context context) {
        return this.getCurrentState();
    }

    public void doValueChanged() {
        this.updateFooter();
    }

    private BOxText getCurrentState() {
        String[] stringArray = new String[this.values.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.values[i].getText();
        }
        return BOxText.make(this.prefix.getText(), this.suffix.getText(), stringArray);
    }

    private void composeValuesPane() {
        int n;
        this.valuesPane.removeAll();
        if (this.usePrefix) {
            this.valuesPane.add(null, (BValue)new BNullWidget());
            this.valuesPane.add(null, (BValue)new BLabel("Text values:", BFont.make((BFont)BFont.DEFAULT, (int)4)));
            this.valuesPane.add(null, (BValue)new BNullWidget());
            this.valuesPane.add(null, (BValue)new BNullWidget());
        }
        if (this.itemLabels != null) {
            this.values = new BTextField[this.itemLabels.length];
            for (n = 0; n < this.values.length; ++n) {
                this.values[n] = new BTextField(this.obj.getItemValue(n));
                this.valuesPane.add(null, (BValue)new BLabel(this.itemLabels[n]));
                this.valuesPane.add(null, (BValue)this.values[n]);
                this.valuesPane.add(null, (BValue)new BNullWidget());
                this.valuesPane.add(null, (BValue)new BNullWidget());
            }
        } else {
            this.values = new BTextField[this.obj.getItemValues().length];
            for (n = 0; n < this.values.length; ++n) {
                this.values[n] = new BTextField(this.obj.getItemValue(n));
                this.valuesPane.add(null, (BValue)new BLabel("text " + n));
                this.valuesPane.add(null, (BValue)this.values[n]);
                this.valuesPane.add(null, (BValue)new BButton((Command)new removeLineCommand((BWidget)this, "+", n), false, true));
                BButton bButton = new BButton((Command)new addLineCommand((BWidget)this, "+", n), false, true);
                bButton.setEnabled(this.maxItems == 0 || this.values.length < this.maxItems);
                this.valuesPane.add(null, (BValue)bButton);
            }
        }
        for (n = 0; n < this.values.length; ++n) {
            this.linkTo((BComponent)this.values[n], (Slot)BTextField.textModified, (Slot)setModified);
            this.linkTo((BComponent)this.values[n], (Slot)BTextField.textModified, (Slot)valueChanged);
        }
        this.valuesPane.relayout();
    }

    private void updateFooter() {
        BOptionDialog bOptionDialog = (BOptionDialog)this.getParent();
        String string = this.getCurrentState().toString();
        int n = this.fieldWidth - string.getBytes().length;
        if (n >= 0) {
            this.remaining.setText("Remaining " + n + " characters");
            this.remaining.setForeground(solidBlack);
            this.warning.setVisible(false);
            if (bOptionDialog != null) {
                bOptionDialog.getOkButton().setEnabled(true);
            }
        } else {
            this.remaining.setText("Too long!");
            this.remaining.setForeground(solidRed);
            this.warning.setVisible(true);
            if (bOptionDialog != null) {
                bOptionDialog.getOkButton().setEnabled(false);
            }
        }
        this.warning.setBlink(n < 0);
    }

    private void updateValuesPane() {
        this.composeValuesPane();
    }

    private class removeLineCommand
    extends Command {
        int index;

        public removeLineCommand(BWidget bWidget, String string, int n) {
            super(bWidget, string);
            this.index = n;
        }

        public CommandArtifact doInvoke() {
            String[] stringArray = new String[BOxTextFE.this.values.length - 1];
            System.arraycopy(BOxTextFE.this.obj.getItemValues(), 0, stringArray, 0, this.index);
            System.arraycopy(BOxTextFE.this.obj.getItemValues(), this.index + 1, stringArray, this.index, stringArray.length - this.index);
            BOxTextFE.this.obj = BOxText.make(BOxTextFE.this.prefix.getText(), BOxTextFE.this.suffix.getText(), stringArray);
            BOxTextFE.this.updateValuesPane();
            return null;
        }

        public BImage getIcon() {
            return BImage.make((String)"module://icons/x16/subtract.png");
        }
    }

    private class addLineCommand
    extends Command {
        int index;

        public addLineCommand(BWidget bWidget, String string, int n) {
            super(bWidget, string);
            this.index = n;
        }

        public CommandArtifact doInvoke() {
            String[] stringArray = new String[BOxTextFE.this.values.length + 1];
            System.arraycopy(BOxTextFE.this.obj.getItemValues(), 0, stringArray, 0, this.index + 1);
            System.arraycopy(BOxTextFE.this.obj.getItemValues(), this.index + 1, stringArray, this.index + 2, BOxTextFE.this.values.length - this.index - 1);
            stringArray[this.index + 1] = "";
            BOxTextFE.this.obj = BOxText.make(BOxTextFE.this.prefix.getText(), BOxTextFE.this.suffix.getText(), stringArray);
            BOxTextFE.this.updateValuesPane();
            return null;
        }

        public BImage getIcon() {
            return BImage.make((String)"module://icons/x16/add.png");
        }
    }
}

