/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ox;

import com.ontrol.sedona.OntImageUtil;
import com.ontrol.sedona.OntLinkUtil;
import com.ontrol.sedona.ox.BOxEditor;
import com.ontrol.sedona.ox.BOxWidget;
import com.ontrol.sedona.ox.OxUtil;
import com.ontrol.sedona.types.BImageFileOx;
import com.ontrol.sedona.types.BSedonaSlotOrdText;
import com.tridium.nsedona.sys.BSedonaComponent;
import java.io.File;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BSize;
import javax.baja.gx.Graphics;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScaleMode;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import sedona.Component;

public class BOxCanvasPane
extends BCanvasPane {
    public static final Property viewSize = BOxCanvasPane.newProperty((int)1, (BValue)BSize.make((double)300.0, (double)240.0), null);
    public static final Property scale = BOxCanvasPane.newProperty((int)5, (BValue)BScaleMode.none, null);
    public static final Property halign = BOxCanvasPane.newProperty((int)5, (BValue)BHalign.center, null);
    public static final Property valign = BOxCanvasPane.newProperty((int)5, (BValue)BValign.center, null);
    public static final Property background = BOxCanvasPane.newProperty((int)5, (BValue)BBrush.NULL, null);
    public static final Property backgroundColor = BOxCanvasPane.newProperty((int)0, (BValue)BColor.white, null);
    public static final Property image = BOxCanvasPane.newProperty((int)0, (BValue)BImageFileOx.NULL, (BFacets)BFacets.make((String)"width", (BIDataValue)BInteger.make((int)320), (String)"height", (BIDataValue)BInteger.make((int)240)));
    public static final Property touchTimeout = BOxCanvasPane.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt((BUnit)UnitDatabase.getUnit((String)"second"), (int)0, (int)255));
    public static final Property touch = BOxCanvasPane.newProperty((int)0, (BValue)BSedonaSlotOrdText.DEFAULT_BOOL_OUT, null);
    public static final Property imageId = BOxCanvasPane.newProperty((int)0, (BValue)BSedonaSlotOrdText.DEFAULT_INT_IN, null);
    public static final Property maxImageId = BOxCanvasPane.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BOxCanvasPane.class);
    private BOxEditor editor;
    int inValue = 0;

    public BColor getBackgroundColor() {
        return (BColor)this.get(backgroundColor);
    }

    public void setBackgroundColor(BColor bColor) {
        this.set(backgroundColor, (BValue)bColor, null);
    }

    public BImageFileOx getImage() {
        return (BImageFileOx)this.get(image);
    }

    public void setImage(BImageFileOx bImageFileOx) {
        this.set(image, (BValue)bImageFileOx, null);
    }

    public int getTouchTimeout() {
        return this.getInt(touchTimeout);
    }

    public void setTouchTimeout(int n) {
        this.setInt(touchTimeout, n, null);
    }

    public BSedonaSlotOrdText getTouch() {
        return (BSedonaSlotOrdText)this.get(touch);
    }

    public void setTouch(BSedonaSlotOrdText bSedonaSlotOrdText) {
        this.set(touch, (BValue)bSedonaSlotOrdText, null);
    }

    public BSedonaSlotOrdText getImageId() {
        return (BSedonaSlotOrdText)this.get(imageId);
    }

    public void setImageId(BSedonaSlotOrdText bSedonaSlotOrdText) {
        this.set(imageId, (BValue)bSedonaSlotOrdText, null);
    }

    public int getMaxImageId() {
        return this.getInt(maxImageId);
    }

    public void setMaxImageId(int n) {
        this.setInt(maxImageId, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOxCanvasPane() {
    }

    public BOxCanvasPane(BOxEditor bOxEditor, int n, int n2) {
        this.editor = bOxEditor;
        this.setViewSize(BSize.make((double)n, (double)n2));
    }

    public boolean isChildLegal(BComponent bComponent) {
        if (bComponent instanceof BOxWidget) {
            BOxWidget bOxWidget = (BOxWidget)bComponent;
            try {
                if (bOxWidget.getComponent() == null) {
                    bOxWidget.setComponent(new BSedonaComponent(this.editor.newSedonaOxComponent(bOxWidget)));
                }
                return true;
            }
            catch (Exception exception) {
                BDialog.warning((BWidget)this.editor, (String)"Sorry", (Object)("Installed ontrolOx kit does not define type: " + bComponent.getTypeDisplayName(null)));
            }
        }
        return false;
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        BOxWidget bOxWidget = (BOxWidget)this.get(property);
        bOxWidget.setEditor(this.editor);
        bOxWidget.hideUnmatchedCustomProperties(this.editor);
        SlotCursor slotCursor = bOxWidget.getProperties();
        while (slotCursor.next()) {
            Property property2 = slotCursor.property();
            if (bOxWidget.getComponent().s().slot(property2.getName()) == null && !property2.getName().equals("layout") && !property2.getFacets().getb("customHandling", false)) {
                bOxWidget.hideProperty(property2);
            }
            String string = property2.getFacets().gets("sedonaSlotName", property2.getName());
            sedona.Slot slot = this.editor.getSedonaSlot(bOxWidget.getType().getTypeName(), string);
            if (slot != null && slot.type.id == 8) {
                bOxWidget.setFacets((Slot)property2, BFacets.make((BFacets)property2.getFacets(), (BFacets)BFacets.make((String)"fieldWidth", (int)(this.editor.readIntFacet(slot, "max", 1) - 1))));
            }
            if (!Flags.isDefaultOnClone((BComplex)bOxWidget, (Slot)property2)) continue;
            bOxWidget.set(property2, property2.getDefaultValue());
        }
        if (!bOxWidget.getComponent().isMounted()) {
            this.rename(property, OxUtil.generateUniqueName(bOxWidget.defaultName(), (BComponent)this));
        }
        bOxWidget.set_name_(bOxWidget.getName());
    }

    public void loadValues(BSedonaComponent bSedonaComponent) {
        Component component = bSedonaComponent.s();
        this.setBackgroundColor(OxUtil.rgb565toBColor(component.getInt("backgroundColor")));
        this.setTouchTimeout(component.getInt("touchTimeout"));
        this.setTouch((BSedonaSlotOrdText)OntLinkUtil.makeSsotFromSedonaComp(this.getTouch(), bSedonaComponent, "touch"));
        if (component.slot("imageId") == null) {
            this.setFlags((Slot)imageId, this.getFlags((Slot)imageId) | 1 | 4);
            this.setFlags((Slot)maxImageId, this.getFlags((Slot)maxImageId) | 1 | 4);
            this.setImage(OntImageUtil.makeImageFileOx(this.editor, component.getStr("imageFileName")));
        } else {
            this.inValue = component.getInt("imageId");
            this.setImageId((BSedonaSlotOrdText)OntLinkUtil.makeSsotFromSedonaComp(this.getImageId(), bSedonaComponent, "imageId"));
            this.setMaxImageId(component.getInt("maxImageId"));
            String string = component.getStr("imageFileName");
            this.setImage(OntImageUtil.makeImageFileOx(this.editor, string + (this.getMaxImageId() <= 0 ? "" : "0")));
            for (int i = 1; i <= this.getMaxImageId(); ++i) {
                OntImageUtil.makeImageFileOx(this.editor, string + i);
            }
        }
    }

    public void saveValues(BSedonaComponent bSedonaComponent) {
        bSedonaComponent.set("backgroundColor", (BValue)BInteger.make((int)OxUtil.BColorToRgb565(this.getBackgroundColor())));
        bSedonaComponent.set("touchTimeout", (BValue)BInteger.make((int)this.getTouchTimeout()));
        OntLinkUtil.makeLinkFromWidgetProp(bSedonaComponent, "touch", this.getTouch());
        BString bString = this.getImage().imageCommit();
        if (bSedonaComponent.slot("imageId") != null) {
            OntLinkUtil.makeLinkFromWidgetProp(bSedonaComponent, "imageId", this.getImageId());
            bSedonaComponent.set("maxImageId", (BValue)BInteger.make((int)this.getMaxImageId()));
            if (this.getMaxImageId() <= 0) {
                bSedonaComponent.set("imageFileName", (BValue)bString);
            } else {
                String string = bString.getString();
                if (string.length() > 0) {
                    string = string.substring(0, string.length() - 1);
                }
                bSedonaComponent.set("imageFileName", (BValue)BString.make((String)string));
            }
        } else {
            bSedonaComponent.set("imageFileName", (BValue)bString);
        }
    }

    File[] getImageFiles() {
        if (this.getImage().isNull()) {
            return null;
        }
        int n = this.getMaxImageId();
        if (n <= 0) {
            return new File[]{this.getImage().getFile()};
        }
        File[] fileArray = new File[n + 1];
        for (int i = 0; i <= n; ++i) {
            fileArray[i] = this.getImage().getFile(i);
        }
        return fileArray;
    }

    public void paint(Graphics graphics) {
        BSize bSize = this.getViewSize();
        double d = bSize.width();
        double d2 = bSize.height();
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        int n = (int)((d3 - d) / 2.0);
        int n2 = (int)((d4 - d2) / 2.0);
        graphics.setBrush(BBrush.makeSolid((BColor)this.getBackgroundColor()));
        graphics.fillRect((double)n, (double)n2, d, d2);
        if (this.getMaxImageId() <= 0) {
            graphics.drawImage(this.getImage().getImage(), (double)n, (double)n2);
        } else {
            int n3 = Math.min(this.getMaxImageId(), Math.max(this.inValue, 0));
            graphics.drawImage(this.getImage().getImage(n3), (double)n, (double)n2);
        }
        super.paint(graphics);
    }

    public BOxEditor getEditor() {
        return this.editor;
    }
}

