/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ox;

import com.ontrol.sedona.FileTransferW;
import com.ontrol.sedona.OntFontUtil;
import com.ontrol.sedona.OntImageUtil;
import com.ontrol.sedona.ox.BOxCanvasPane;
import com.ontrol.sedona.ox.BOxEditorPane;
import com.ontrol.sedona.ox.BOxMedia;
import com.ontrol.sedona.ox.BOxProfile;
import com.ontrol.sedona.ox.BOxWidget;
import com.ontrol.sedona.ox.OxEditorController;
import com.ontrol.sedona.ox.OxUtil;
import com.tridium.nsedona.sys.BISedonaSpace;
import com.tridium.nsedona.sys.BSedonaComponent;
import com.tridium.px.editor.BPxEditorPane;
import java.io.File;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.BPxProfile;
import javax.baja.px.editor.event.PxEvent;
import javax.baja.px.editor.event.PxListener;
import javax.baja.px.editor.event.PxSelectionEvent;
import javax.baja.px.editor.event.PxUserDefinedEvent;
import javax.baja.sedona.sys.BSedonaBoolean;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import sedona.Component;
import sedona.Schema;
import sedona.Slot;
import sedona.util.Log;

public class BOxEditor
extends BPxEditor {
    public static final Type TYPE = Sys.loadType(BOxEditor.class);
    public boolean requireReload = false;
    BWidget widget = null;
    BISedonaSpace sedonaSpace;
    public static final Log logger = new Log("OntrolOx");
    public BEnumRange availableFonts;
    BSedonaComponent plat;
    BSedonaComponent oxBase;
    BSedonaComponent oxPageComponent;
    Schema schema = null;
    OxEditorSubscriber subscriber = new OxEditorSubscriber();
    int freeFlashSpace;

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.setMedia(BOxMedia.INSTANCE);
        this.setController(new OxEditorController(this));
        this.addPxListener(new OxListener());
        OntImageUtil.makeDirectories();
        this.availableFonts = OntFontUtil.getSystemFonts();
    }

    public void prime() {
        this.setActivePage();
    }

    public boolean isEditable() {
        return true;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isFileBased() {
        return false;
    }

    public PxProperty[] getPxProperties() {
        return new PxProperty[0];
    }

    public PxLayer[] getPxLayers() {
        return new PxLayer[0];
    }

    public BWidget getWidget() {
        return this.widget;
    }

    public boolean isEditor() {
        return true;
    }

    public BPxProfile getPxProfile() {
        return new BOxProfile(this);
    }

    public BWidget loadPx(BObject bObject, Context context) {
        Object object;
        this.oxPageComponent = (BSedonaComponent)bObject;
        this.initializeStuff();
        BOxEditorPane bOxEditorPane = new BOxEditorPane(480, 420);
        BOxCanvasPane bOxCanvasPane = new BOxCanvasPane(this, 320, 240);
        bOxCanvasPane.loadValues(this.oxPageComponent);
        this.oxPageComponent.lease(1);
        BWidget[] bWidgetArray = this.oxPageComponent.getProperties();
        while (bWidgetArray.next(BSedonaComponent.class)) {
            BSedonaComponent bSedonaComponent = (BSedonaComponent)bWidgetArray.get();
            if (!bSedonaComponent.stype().is(this.schema.type("ontrolOx::Widget"))) continue;
            try {
                object = "ontrolSedonaUtil:" + bSedonaComponent.stype().name;
                BOxWidget bOxWidget = (BOxWidget)Sys.getType((String)object).getInstance();
                bOxWidget.setComponent(bSedonaComponent);
                bOxCanvasPane.add(bSedonaComponent.getName(), (BValue)bOxWidget, context);
                bOxWidget.updateFromComponent();
            }
            catch (ModuleException moduleException) {
                BDialog.warning((BWidget)this, (String)"Error", (Object)BString.make((String)"ModuleException: ontrolSedonaUtil"), (Throwable)moduleException);
            }
            catch (TypeException typeException) {
                BDialog.warning((BWidget)this, (String)"Error", (Object)BString.make((String)("TypeException " + bSedonaComponent.stype().name)));
            }
        }
        if (this.requireReload) {
            bWidgetArray = bOxCanvasPane.getChildWidgets();
            for (int i = 0; i < bWidgetArray.length; ++i) {
                object = (BOxWidget)bWidgetArray[i];
                object.updateFromComponent();
            }
        }
        bOxEditorPane.add("oxpage", (BValue)bOxCanvasPane);
        this.widget = bOxEditorPane;
        return this.widget;
    }

    public BObject doSaveValue(BObject bObject, Context context) {
        Object object;
        int n;
        this.oxPageComponent = (BSedonaComponent)bObject;
        this.setActivePage();
        BPxEditorPane bPxEditorPane = (BPxEditorPane)this.getContent();
        BOxCanvasPane bOxCanvasPane = (BOxCanvasPane)bPxEditorPane.getRootContainer().getRoot().get("oxpage");
        bOxCanvasPane.saveValues(this.oxPageComponent);
        BWidget[] bWidgetArray = bOxCanvasPane.getChildWidgets();
        BComponent[] bComponentArray = this.oxPageComponent.getChildComponents();
        for (n = 0; n < bComponentArray.length; ++n) {
            object = (BSedonaComponent)bComponentArray[n];
            if (!object.stype().is(this.schema.type("ontrolOx::Widget")) || bOxCanvasPane.get(object.getDisplayName(context)) != null) continue;
            this.oxPageComponent.remove((BComplex)object);
        }
        for (n = 0; n < bWidgetArray.length; ++n) {
            try {
                object = (BOxWidget)bWidgetArray[n];
                if (!((BOxWidget)((Object)object)).getComponent().isMounted()) {
                    Component component = this.newSedonaOxComponent((BOxWidget)((Object)object));
                    String string = ((BOxWidget)((Object)object)).get_name_();
                    if (string.isEmpty()) {
                        string = OxUtil.generateUniqueName(((BOxWidget)((Object)object)).defaultName(), (BComponent)this.oxPageComponent);
                    }
                    this.oxPageComponent.add(string, (BValue)new BSedonaComponent(component));
                    ((BOxWidget)((Object)object)).setComponent((BSedonaComponent)this.oxPageComponent.get(string));
                    bOxCanvasPane.rename(bOxCanvasPane.getProperty(object.getName()), string);
                }
                ((BOxWidget)((Object)object)).saveToComponent();
                continue;
            }
            catch (Exception exception) {
                BDialog.error((BWidget)this, (Object)("Error while saving.\n" + exception.getMessage()));
                exception.printStackTrace();
            }
        }
        return this.oxPageComponent;
    }

    protected Component newSedonaOxComponent(BOxWidget bOxWidget) throws Exception {
        return this.sedonaSpace.newInstance("ontrolOx::" + bOxWidget.getType().getTypeName());
    }

    public sedona.Type getSedonaType(String string, String string2) {
        return this.schema.type(string + "::" + string2);
    }

    protected Slot getSedonaSlot(String string, String string2) {
        return this.getSedonaType("ontrolOx", string).slot(string2);
    }

    protected int readIntFacet(Slot slot, String string, int n) {
        if (slot == null) {
            return 0;
        }
        return slot.facets.geti(string, n);
    }

    private void initializeStuff() {
        this.sedonaSpace = (BISedonaSpace)this.oxPageComponent.getSpace();
        try {
            this.schema = this.sedonaSpace.getSchema();
        }
        catch (Exception exception) {
            logger.error("OxEditor load error while getting schema", (Throwable)exception);
        }
        BSedonaComponent bSedonaComponent = (BSedonaComponent)((BComponentSpace)this.sedonaSpace).getRootComponent();
        this.plat = this.findComponentOfType(bSedonaComponent, this.schema.type("sys::PlatformService"));
        this.oxBase = this.findComponentOfType(bSedonaComponent, this.schema.type("ontrolOx::OxBase"));
        this.subscriber.subscribe((BComponent)this.plat);
    }

    private void setActivePage() {
        if (this.oxBase == null) {
            return;
        }
        this.oxBase.set("activePageId", (BValue)BInteger.make((int)this.oxPageComponent.s().id()));
        Action action = this.oxBase.action("trigBacklight");
        if (action != null) {
            if (action.getParameterType() == null) {
                this.oxBase.invoke(action, null);
            } else {
                this.oxBase.invoke(action, (BValue)BSedonaBoolean.make((boolean)true));
            }
        }
    }

    private BSedonaComponent findComponentOfType(BSedonaComponent bSedonaComponent, sedona.Type type) {
        bSedonaComponent.loadSlots();
        BSedonaComponent[] bSedonaComponentArray = bSedonaComponent.kids();
        for (int i = 0; i < bSedonaComponentArray.length; ++i) {
            if (bSedonaComponentArray[i].stype().is(type)) {
                return bSedonaComponentArray[i];
            }
            BSedonaComponent bSedonaComponent2 = this.findComponentOfType(bSedonaComponentArray[i], type);
            if (bSedonaComponent2 == null || !bSedonaComponent2.stype().is(type)) continue;
            return bSedonaComponent2;
        }
        return null;
    }

    public void receiveFile(File file, String string) {
        BProgressDialog.open((BWidget)this, (String)"Receiving files...", (BProgressDialog.Worker)new FileTransferW(this.sedonaSpace, true, file, string));
    }

    private class OxListener
    implements PxListener {
        private OxListener() {
        }

        public void pxEvent(PxEvent pxEvent) {
            if (pxEvent.getEventType() == 2) {
                BWidget[] bWidgetArray = ((PxSelectionEvent)pxEvent).getWidgets();
                for (int i = 0; i < bWidgetArray.length; ++i) {
                    if (!bWidgetArray[i].getType().equals(BOxEditorPane.TYPE)) continue;
                    BOxEditor.this.getSelection().deselect(bWidgetArray[i]);
                    break;
                }
            }
        }
    }

    private class OxEditorSubscriber
    extends Subscriber {
        private OxEditorSubscriber() {
        }

        public void event(BComponentEvent bComponentEvent) {
            if (bComponentEvent.getSlotName().equals("freeFlashSpace")) {
                try {
                    BOxEditor.this.freeFlashSpace = ((BInteger)bComponentEvent.getValue()).getInt();
                }
                catch (Exception exception) {
                    String string = ((BString)bComponentEvent.getValue()).getString();
                    BOxEditor.this.freeFlashSpace = Integer.parseInt(string.substring(0, string.indexOf("/")));
                }
                BOxEditor.this.firePxEvent((PxEvent)new PxUserDefinedEvent(null));
            }
        }
    }
}

