/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ox;

import com.ontrol.sedona.FileTransferW;
import com.ontrol.sedona.OntLinkUtil;
import com.ontrol.sedona.ox.BOxCanvasPane;
import com.ontrol.sedona.ox.BOxEditor;
import com.ontrol.sedona.ox.BOxWidget;
import com.ontrol.sedona.ox.OxImageInterface;
import com.ontrol.sedona.ox.OxTextInterface;
import com.tridium.px.editor.BPxEditorPane;
import java.io.File;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.BPxSideBar;
import javax.baja.px.editor.event.PxEvent;
import javax.baja.px.editor.event.PxListener;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BSplitPane;
import sedona.Component;
import sedona.Link;
import sedona.Slot;

public class BOxFilesPane
extends BPxSideBar
implements PxListener {
    public static final Type TYPE = Sys.loadType(BOxFilesPane.class);
    BOxEditor editor;
    private BAbstractButton sendFilesButton = this.newButton(new commandToTransferFiles());
    private BAbstractButton setHomePageButton = this.newButton(new commandToSetHomePage());
    private BList fontslist = new BList();
    private BList imageslist = new BList();
    private BLabel freeFlashSpaceLabel = new BLabel();
    static BImage imageicon = BImage.make((String)"module://icons/x16/widgets/image.png");
    static BImage fonticon = BImage.make((String)"module://icons/x16/widgets/label.png");

    public Type getType() {
        return TYPE;
    }

    public BOxFilesPane() {
        super(null);
    }

    public BOxFilesPane(BOxEditor bOxEditor) {
        super((BPxEditor)bOxEditor);
        this.editor = bOxEditor;
        bOxEditor.addPxListener(this);
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, (BValue)this.sendFilesButton);
        bToolBar.add(null, (BValue)this.setHomePageButton);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setLeft((BWidget)this.freeFlashSpaceLabel);
        bEdgePane.setRight((BWidget)bToolBar);
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setTop((BWidget)bEdgePane);
        BSplitPane bSplitPane = new BSplitPane((BWidget)this.fontslist, (BWidget)this.imageslist);
        bSplitPane.setContinuousLayout(false);
        bSplitPane.setDividerWidth(1.0);
        bEdgePane2.setCenter((BWidget)bSplitPane);
        this.setContent((BWidget)bEdgePane2);
    }

    private void setFreeFlashSpaceLabel() {
        this.freeFlashSpaceLabel.setText(" Free flash space = " + this.editor.freeFlashSpace + " KB");
    }

    public void pxEvent(PxEvent pxEvent) {
        switch (pxEvent.getEventType()) {
            case 0: 
            case 7: {
                this.setFreeFlashSpaceLabel();
            }
            case 3: {
                this.formListWidget();
            }
        }
    }

    private void formListWidget() {
        this.fontslist.removeAllItems();
        this.imageslist.removeAllItems();
        BPxEditorPane bPxEditorPane = (BPxEditorPane)this.editor.getContent();
        BOxCanvasPane bOxCanvasPane = (BOxCanvasPane)bPxEditorPane.getRootContainer().getRoot().get("oxpage");
        File[] fileArray = bOxCanvasPane.getImageFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (file == null || this.imageslist.indexOfItem((Object)file) >= 0) continue;
                this.imageslist.addItem(imageicon, (Object)file.getName());
            }
        }
        BWidget[] bWidgetArray = bOxCanvasPane.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            int n;
            File[] fileArray2;
            BOxWidget bOxWidget = (BOxWidget)bWidgetArray[i];
            if (bOxWidget instanceof OxImageInterface) {
                fileArray2 = ((OxImageInterface)((Object)bOxWidget)).getImageFiles();
                for (n = 0; n < fileArray2.length; ++n) {
                    File file = fileArray2[n];
                    if (file == null || this.imageslist.indexOfItem((Object)file) >= 0) continue;
                    this.imageslist.addItem(imageicon, (Object)file.getName());
                }
            }
            if (!(bOxWidget instanceof OxTextInterface)) continue;
            fileArray2 = ((OxTextInterface)((Object)bOxWidget)).getRequiredFonts();
            for (n = 0; n < fileArray2.length; ++n) {
                if (this.fontslist.indexOfItem((Object)fileArray2[n]) >= 0) continue;
                this.fontslist.addItem(fonticon, (Object)fileArray2[n]);
            }
        }
        this.imageslist.getModel().updateList();
        this.fontslist.getModel().updateList();
    }

    public String getSideBarDescription() {
        return "Files";
    }

    public BImage getSideBarIcon() {
        return BImage.make((String)"module://icons/x16/folder.png");
    }

    private class commandToTransferFiles
    extends Command {
        public commandToTransferFiles() {
            super((BWidget)BOxFilesPane.this, "send files to device", BImage.make((String)"module://ontrolSedonaUtil/com/ontrol/sedona/icons/x16/sendFiles.png"), null, "Transfer files to device");
        }

        public CommandArtifact doInvoke() throws Exception {
            int n;
            Object[] objectArray = BOxFilesPane.this.imageslist.getSelectedItems();
            Object[] objectArray2 = BOxFilesPane.this.fontslist.getSelectedItems();
            FileTransferW fileTransferW = new FileTransferW(BOxFilesPane.this.editor.sedonaSpace, false);
            for (n = 0; n < objectArray.length; ++n) {
                fileTransferW.addImageFile((String)objectArray[n]);
            }
            for (n = 0; n < objectArray2.length; ++n) {
                fileTransferW.addFontFile((BFont)objectArray2[n]);
            }
            if (fileTransferW.getFileCount() == 0) {
                BDialog.message((BWidget)BOxFilesPane.this.editor, (String)"File Transfer", (Object)"No files selected. Please select one or more files to transfer.");
            } else {
                BProgressDialog.open((BWidget)BOxFilesPane.this.editor, (String)"Transferring files...", (BProgressDialog.Worker)fileTransferW);
            }
            BOxFilesPane.this.setFreeFlashSpaceLabel();
            return null;
        }
    }

    private class commandToSetHomePage
    extends Command {
        public commandToSetHomePage() {
            super((BWidget)BOxFilesPane.this, "set as home page", BImage.make((String)"module://icons/x16/home.png"), null, "Set as home page");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (4 == BDialog.confirm((BWidget)BOxFilesPane.this.editor, (Object)"Are you sure you want to set this as the device's home page?")) {
                Component component = BOxFilesPane.this.editor.oxBase.s();
                Component component2 = BOxFilesPane.this.editor.oxPageComponent.s();
                Slot slot = component.slot("homePageId");
                Link link = OntLinkUtil.getLinkToFromSlot(true, BOxFilesPane.this.editor.oxBase, slot.id);
                OntLinkUtil.removeLink(BOxFilesPane.this.editor.sedonaSpace, link);
                BOxFilesPane.this.editor.sedonaSpace.addLink(component2, component2.slot("pageId"), component, slot);
            }
            return null;
        }
    }
}

