/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ox;

import com.ontrol.sedona.OntImageUtil;
import com.ontrol.sedona.OntLinkUtil;
import com.ontrol.sedona.enums.BShapeEnum;
import com.ontrol.sedona.ox.BOxEditor;
import com.ontrol.sedona.ox.OxImageInterface;
import com.ontrol.sedona.ox.OxTextInterface;
import com.ontrol.sedona.ox.OxUtil;
import com.ontrol.sedona.types.BImageFileOx;
import com.ontrol.sedona.types.BOxInteger;
import com.ontrol.sedona.types.BOxText;
import com.ontrol.sedona.types.BSedonaMetadata;
import com.ontrol.sedona.types.BSedonaSlotOrdText;
import com.tridium.nsedona.sys.BSedonaComponent;
import java.io.IOException;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BEllipseGeom;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.sedona.sys.BSedonaBoolean;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import sedona.Component;
import sedona.Slot;

public abstract class BOxWidget
extends BWidget {
    public static final String SEDONA_SLOT_NAME = "sedonaSlotName";
    public static final String CUSTOM_HANDLING = "customHandling";
    public static final String ITEM_LABELS = "itemLabels";
    public static final BFacets FACET_CUSTOM_HANDLING = BFacets.make((String)"customHandling", (BIDataValue)BBoolean.make((boolean)true));
    public static final Property _name_ = BOxWidget.newProperty((int)65, (String)BString.DEFAULT.getString(), (BFacets)FACET_CUSTOM_HANDLING);
    public static final Property meta = BOxWidget.newProperty((int)0, (BValue)BSedonaMetadata.DEFAULT, null);
    public static final Property shape = BOxWidget.newProperty((int)0, (BValue)BDynamicEnum.make((BEnum)BDynamicEnum.make((BEnum)BShapeEnum.make(0))), null);
    public static final Property blink = BOxWidget.newProperty((int)64, (BValue)BSedonaSlotOrdText.DEFAULT_BOOL_IN, null);
    public static final Property visibility = BOxWidget.newProperty((int)64, (BValue)BSedonaSlotOrdText.DEFAULT_BOOL_IN, null);
    public static final Property touch = BOxWidget.newProperty((int)64, (BValue)BSedonaSlotOrdText.DEFAULT_BOOL_OUT, null);
    public static final Type TYPE = Sys.loadType(BOxWidget.class);
    protected BSedonaComponent sedComp = null;
    protected BOxEditor editor = null;
    protected BValue inVal;

    public String get_name_() {
        return this.getString(_name_);
    }

    public void set_name_(String string) {
        this.setString(_name_, string, null);
    }

    public BSedonaMetadata getMeta() {
        return (BSedonaMetadata)this.get(meta);
    }

    public void setMeta(BSedonaMetadata bSedonaMetadata) {
        this.set(meta, (BValue)bSedonaMetadata, null);
    }

    public BDynamicEnum getShape() {
        return (BDynamicEnum)this.get(shape);
    }

    public void setShape(BDynamicEnum bDynamicEnum) {
        this.set(shape, (BValue)bDynamicEnum, null);
    }

    public BSedonaSlotOrdText getBlink() {
        return (BSedonaSlotOrdText)this.get(blink);
    }

    public void setBlink(BSedonaSlotOrdText bSedonaSlotOrdText) {
        this.set(blink, (BValue)bSedonaSlotOrdText, null);
    }

    public BSedonaSlotOrdText getVisibility() {
        return (BSedonaSlotOrdText)this.get(visibility);
    }

    public void setVisibility(BSedonaSlotOrdText bSedonaSlotOrdText) {
        this.set(visibility, (BValue)bSedonaSlotOrdText, null);
    }

    public BSedonaSlotOrdText getTouch() {
        return (BSedonaSlotOrdText)this.get(touch);
    }

    public void setTouch(BSedonaSlotOrdText bSedonaSlotOrdText) {
        this.set(touch, (BValue)bSedonaSlotOrdText, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BOxWidget() {
        this.setLayout(BLayout.makeAbs((double)this.getLayout().getX(), (double)this.getLayout().getY(), (double)100.0, (double)20.0));
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == layout) {
            BLayout bLayout = this.getLayout();
            double d = bLayout.getX();
            double d2 = bLayout.getY();
            double d3 = bLayout.getWidth();
            double d4 = bLayout.getHeight();
            if (d < 0.0 || d2 < 0.0 || d + d3 > 320.0 || d2 + d4 > 240.0) {
                this.correctLayout();
            } else if (bLayout.getXUnit() != 0 || bLayout.getYUnit() != 0 || bLayout.getWidthUnit() != 0 || bLayout.getHeightUnit() != 0) {
                this.correctLayout();
            }
        }
    }

    public void computePreferredSize() {
        if (this instanceof OxImageInterface) {
            OxImageInterface oxImageInterface = (OxImageInterface)((Object)this);
            double d = 0.0;
            double d2 = 0.0;
            BImage[] bImageArray = oxImageInterface.getImages();
            for (int i = 0; i < bImageArray.length; ++i) {
                BImage bImage = bImageArray[i];
                d = Math.max(d, bImage.getWidth());
                d2 = Math.max(d2, bImage.getHeight());
            }
            if (d > 0.0 && d2 > 0.0) {
                this.setPreferredSize(d, d2);
            } else {
                this.setPreferredSize(this.getLayout().getWidth(), this.getLayout().getHeight());
            }
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.paintBackground(graphics);
        this.paintImage(graphics);
        this.paintText(graphics);
    }

    protected boolean getInValue(boolean bl) {
        if (this.inVal == null) {
            return bl;
        }
        return ((BSedonaBoolean)this.inVal).getBoolean();
    }

    protected int getInValue(int n) {
        if (this.inVal == null) {
            return n;
        }
        return ((BInteger)this.inVal).getInt();
    }

    protected float getInValue(float f) {
        if (this.inVal == null) {
            return f;
        }
        return ((BFloat)this.inVal).getFloat();
    }

    protected void hideProperty(Property property) {
        this.setFlags((javax.baja.sys.Slot)property, this.getFlags((javax.baja.sys.Slot)property) | 1 | 4);
    }

    public abstract String defaultName();

    public void init(BOxEditor bOxEditor) {
    }

    public void hideUnmatchedCustomProperties(BOxEditor bOxEditor) {
    }

    public void updateFromComponent() {
        Component component = this.sedComp.s();
        this.setLayout(BLayout.makeAbs((double)component.getInt("x"), (double)component.getInt("y"), (double)component.getInt("width"), (double)component.getInt("height")));
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next()) {
            Property property = slotCursor.property();
            Slot slot = this.sedComp.sslot(property.getName());
            if (slot == null) continue;
            this.set(property, this.fromOxSedonaProp(property));
            if (OntLinkUtil.getLinkToFromSlot(true, this.sedComp, slot.id) == null || property.getType().is(BSedonaSlotOrdText.TYPE)) continue;
            this.setFlags((javax.baja.sys.Slot)property, this.getFlags((javax.baja.sys.Slot)property) | 1);
        }
        this.inVal = this.sedComp.get("in");
    }

    protected void saveToComponent() throws Exception {
        if (this.sedComp == null) {
            return;
        }
        BLayout bLayout = this.getLayout();
        this.sedComp.set("x", (BValue)BInteger.make((int)((int)bLayout.getX())));
        this.sedComp.set("y", (BValue)BInteger.make((int)((int)bLayout.getY())));
        this.sedComp.set("width", (BValue)BInteger.make((int)((int)bLayout.getWidth())));
        this.sedComp.set("height", (BValue)BInteger.make((int)((int)bLayout.getHeight())));
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.next()) {
            if (this.sedComp.slot(slotCursor.property().getName()) == null) continue;
            this.setOxSedonaProp(slotCursor.property());
        }
        this.sedComp.lease();
    }

    private BValue fromOxSedonaProp(Property property) {
        Type type = property.getType();
        String string = property.getName();
        Component component = this.sedComp.s();
        if (type.is(BSedonaSlotOrdText.TYPE)) {
            return OntLinkUtil.makeSsotFromSedonaComp((BSedonaSlotOrdText)this.get(property), this.sedComp, string);
        }
        if (type.is(BSedonaMetadata.TYPE)) {
            return BSedonaMetadata.make(component.getInt(string));
        }
        if (type.is(BColor.TYPE)) {
            return OxUtil.rgb565toBColor(component.getInt(string));
        }
        if (type.is(BImageFileOx.TYPE)) {
            return OntImageUtil.makeImageFileOx(this.editor, component.getStr(string));
        }
        if (type.is(BDynamicEnum.TYPE)) {
            return BDynamicEnum.make((int)component.getInt(string), (BEnumRange)((BDynamicEnum)this.get(string)).getRange());
        }
        if (type.is(BFrozenEnum.TYPE)) {
            return BDynamicEnum.make((int)component.getInt(string), (BEnumRange)((BEnum)this.get(string)).getRange());
        }
        if (type.is(BString.TYPE)) {
            return this.convertSedonaPropertyToString(component, string);
        }
        if (type.is(BOxText.TYPE)) {
            return BOxText.make(this.convertSedonaPropertyToString(component, string).getString());
        }
        if (type.is(BInteger.TYPE)) {
            return BInteger.make((int)component.getInt(string));
        }
        if (type.is(BOxInteger.TYPE)) {
            return BOxInteger.make(component.getInt(string));
        }
        if (type.is(BBoolean.TYPE)) {
            return BBoolean.make((boolean)component.getBool(string));
        }
        if (type.is(BFloat.TYPE)) {
            return BFloat.make((float)component.getFloat(string));
        }
        return null;
    }

    private void setOxSedonaProp(Property property) throws IOException {
        String string = property.getName();
        Type type = property.getType();
        BValue bValue = this.get(string);
        BInteger bInteger = null;
        if (type.is(BSedonaSlotOrdText.TYPE)) {
            if (!OntLinkUtil.makeLinkFromWidgetProp(this.sedComp, string, (BSedonaSlotOrdText)this.get(property))) {
                BDialog.message((BWidget)this.getShell(), (Object)("Can't make link with " + string + " slot"));
            }
            return;
        }
        if (type.is(BSedonaMetadata.TYPE)) {
            bInteger = BInteger.make((int)((BSedonaMetadata)bValue).getPositionedMeta(this.getLayout()));
        } else if (type.is(BDynamicEnum.TYPE)) {
            bInteger = BInteger.make((int)((BDynamicEnum)bValue).getOrdinal());
        } else if (type.is(BColor.TYPE)) {
            bInteger = BInteger.make((int)OxUtil.BColorToRgb565((BColor)bValue));
        } else if (type.is(BImageFileOx.TYPE)) {
            bInteger = ((BImageFileOx)bValue).imageCommit();
        } else if (type.is(BString.TYPE)) {
            bInteger = this.convertStringToSedonaProperty(this.sedComp.s(), string, (BString)bValue);
        } else if (type.is(BOxText.TYPE)) {
            bInteger = this.convertStringToSedonaProperty(this.sedComp.s(), string, BString.make((String)((BOxText)bValue).toString()));
        } else if (type.is(BInteger.TYPE)) {
            bInteger = (BInteger)bValue;
        } else if (type.is(BOxInteger.TYPE)) {
            bInteger = BInteger.make((int)((BOxInteger)bValue).getInt());
        } else if (type.is(BBoolean.TYPE)) {
            bInteger = ((BBoolean)bValue).getBoolean() ? BSedonaBoolean.True : BSedonaBoolean.False;
        } else if (type.is(BFloat.TYPE)) {
            bInteger = (BFloat)bValue;
        }
        if (bInteger == null) {
            BDialog.message((BWidget)this.getShell(), (Object)("Can't set property " + string));
        } else {
            this.sedComp.set(string, (BValue)bInteger);
        }
    }

    private void correctLayout() {
        BLayout bLayout = this.getLayout();
        double d = bLayout.getX();
        double d2 = bLayout.getY();
        double d3 = bLayout.getWidth();
        double d4 = bLayout.getHeight();
        d3 = Math.max(0.0, Math.min(d3, 320.0));
        d4 = Math.max(0.0, Math.min(d4, 240.0));
        d = Math.max(d, 0.0);
        d2 = Math.max(d2, 0.0);
        d = Math.min(d, 320.0 - d3);
        d2 = Math.min(d2, 240.0 - d4);
        this.setLayout(BLayout.makeAbs((double)d, (double)d2, (double)d3, (double)d4));
    }

    protected BColor getBackgroundColor() {
        return BColor.yellow;
    }

    public abstract boolean paintBackground();

    protected void paintBackground(Graphics graphics) {
        if (this.paintBackground()) {
            graphics.setBrush(BBrush.makeSolid((BColor)this.getBackgroundColor()));
            if (this.getShape().getOrdinal() == 1) {
                graphics.fill((IGeom)BEllipseGeom.make((double)0.0, (double)0.0, (double)this.getWidth(), (double)this.getHeight()));
            } else {
                graphics.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
            }
        }
    }

    public void paintText(Graphics graphics) {
        if (!(this instanceof OxTextInterface)) {
            return;
        }
        OxTextInterface oxTextInterface = (OxTextInterface)((Object)this);
        String string = oxTextInterface.getPaintText();
        if (string.length() == 0) {
            return;
        }
        int n = string.length();
        String string2 = "";
        int n2 = oxTextInterface.getSubscriptDigitCount();
        if (n2 > 0 && n2 < n) {
            string2 = string.substring(n - n2);
            string = string.substring(0, n - n2);
        }
        BFont bFont = oxTextInterface.getPaintFont();
        BFont bFont2 = BFont.make((BFont)bFont, (double)(bFont.getSize() / 2.0));
        double d = 0.0;
        double d2 = (this.getHeight() + bFont.getAscent() - bFont.getDescent()) / 2.0;
        double d3 = bFont.width(string) + bFont2.width(string2);
        if (oxTextInterface.getAlignment() == BHalign.right) {
            d = this.getWidth() - d3;
        }
        if (oxTextInterface.getAlignment() == BHalign.center) {
            d = (this.getWidth() - d3) / 2.0;
        }
        graphics.setFont(bFont);
        graphics.setBrush(BBrush.makeSolid((BColor)oxTextInterface.getTextColor()));
        graphics.drawString(string, d, d2);
        graphics.setFont(bFont2);
        if (string2.length() > 0) {
            graphics.drawString(string2, d + bFont.width(string), d2);
        }
    }

    protected void paintImage(Graphics graphics) {
        if (this instanceof OxImageInterface) {
            OxImageInterface oxImageInterface = (OxImageInterface)((Object)this);
            BImage bImage = oxImageInterface.getImage();
            int n = 0;
            int n2 = 0;
            if (this.getWidth() > bImage.getWidth()) {
                n = (int)(this.getWidth() - bImage.getWidth()) / 2;
            }
            if (this.getHeight() > bImage.getHeight()) {
                n2 = (int)(this.getHeight() - bImage.getHeight()) / 2;
            }
            graphics.drawImage(bImage, (double)n, (double)n2);
        }
    }

    protected BString convertSedonaPropertyToString(Component component, String string) {
        if (component.slot(string).isAsStr()) {
            return BString.make((String)component.getStr(string));
        }
        byte[] byArray = component.getBuf(string).bytes();
        for (int i = 0; i < byArray.length; ++i) {
            byte[] byArray2;
            int n = byArray[i] & 0xFF;
            if (n == 0) {
                byArray2 = new byte[i];
                System.arraycopy(byArray, 0, byArray2, 0, i);
                return BString.make((String)new String(byArray2));
            }
            if (n <= 127) continue;
            if (n < 192) {
                byArray2 = new byte[byArray.length + 1];
                System.arraycopy(byArray, 0, byArray2, 0, i);
                System.arraycopy(byArray, i, byArray2, i + 1, byArray.length - i);
                byArray2[i] = -62;
                byArray = byArray2;
            }
            ++i;
        }
        return BString.make((String)new String(byArray));
    }

    protected BValue convertStringToSedonaProperty(Component component, String string, BString bString) {
        String string2 = bString.getString();
        if (component.slot(string).isAsStr()) {
            return BString.make((String)string2);
        }
        return BBlob.make((byte[])OxUtil.stringToBytes(string2));
    }

    protected void setComponent(BSedonaComponent bSedonaComponent) {
        this.sedComp = bSedonaComponent;
    }

    protected BSedonaComponent getComponent() {
        return this.sedComp;
    }

    protected void setEditor(BOxEditor bOxEditor) {
        this.editor = bOxEditor;
    }

    protected BOxEditor getEditor() {
        return this.editor;
    }
}

