/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ox.widgets;

import com.ontrol.sedona.OntFontUtil;
import com.ontrol.sedona.ox.BOxCanvasPane;
import com.ontrol.sedona.ox.BOxWidget;
import com.ontrol.sedona.ox.OxTextInterface;
import com.ontrol.sedona.types.BOxInteger;
import java.io.File;
import javax.baja.gx.BFont;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import sedona.Component;

public abstract class BLabel
extends BOxWidget
implements OxTextInterface {
    public static final Property font = BLabel.newProperty((int)0, (BValue)BDynamicEnum.make((int)0), (BFacets)FACET_CUSTOM_HANDLING);
    public static final Property subscriptDigits = BLabel.newProperty((int)0, (BValue)BOxInteger.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.makeInt((int)0, (int)7), (BFacets)FACET_CUSTOM_HANDLING));
    public static final Property transparent = BLabel.newProperty((int)0, (boolean)false, (BFacets)FACET_CUSTOM_HANDLING);
    public static final Property alignment = BLabel.newProperty((int)0, (BValue)BHalign.make((int)0), (BFacets)FACET_CUSTOM_HANDLING);
    public static final Type TYPE = Sys.loadType(BLabel.class);

    public BDynamicEnum getFont() {
        return (BDynamicEnum)this.get(font);
    }

    public void setFont(BDynamicEnum bDynamicEnum) {
        this.set(font, (BValue)bDynamicEnum, null);
    }

    public BOxInteger getSubscriptDigits() {
        return (BOxInteger)this.get(subscriptDigits);
    }

    public void setSubscriptDigits(BOxInteger bOxInteger) {
        this.set(subscriptDigits, (BValue)bOxInteger, null);
    }

    public boolean getTransparent() {
        return this.getBoolean(transparent);
    }

    public void setTransparent(boolean bl) {
        this.setBoolean(transparent, bl, null);
    }

    @Override
    public BHalign getAlignment() {
        return (BHalign)this.get(alignment);
    }

    public void setAlignment(BHalign bHalign) {
        this.set(alignment, (BValue)bHalign, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        BOxCanvasPane bOxCanvasPane = (BOxCanvasPane)this.getParent();
        BEnumRange bEnumRange = bOxCanvasPane.getEditor().availableFonts;
        int n = bEnumRange.tagToOrdinal("$316pt$20Tahoma");
        if (this.getFont().getRange().equals((Object)BEnumRange.NULL)) {
            this.setFont(BDynamicEnum.make((int)n, (BEnumRange)bEnumRange));
        }
    }

    @Override
    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == alignment && this.getAlignment() == BHalign.fill) {
            BDialog.error((BWidget)this.getShell(), (Object)"FILL not supported!");
            this.setAlignment(BHalign.center);
        }
    }

    @Override
    public void updateFromComponent() {
        block2: {
            super.updateFromComponent();
            Component component = this.sedComp.s();
            int n = component.getInt("attributes");
            this.setSubscriptDigits(BOxInteger.make(n & 7));
            this.setTransparent((n & 8) == 0);
            this.setAlignment(BHalign.make((int)((n & 0x30) >> 4)));
            int n2 = component.getInt("fontSize");
            int n3 = component.getInt("fontName");
            int n4 = component.getInt("fontAttributes");
            String string = OntFontUtil.makeFontString(n3, n2, n4);
            String string2 = SlotPath.escape((String)string);
            try {
                this.setFont(BDynamicEnum.make((int)this.editor.availableFonts.tagToOrdinal(string2), (BEnumRange)this.editor.availableFonts));
            }
            catch (InvalidEnumException invalidEnumException) {
                File file = new File(OntFontUtil.fontBank, string + ".bin");
                this.editor.receiveFile(file, "fonts");
                if (!file.exists()) break block2;
                this.editor.availableFonts = OntFontUtil.getSystemFonts();
                this.editor.requireReload = true;
            }
        }
    }

    @Override
    public void saveToComponent() throws Exception {
        super.saveToComponent();
        int n = this.getAlignment().getOrdinal() << 4;
        n |= this.getTransparent() ? 0 : 8;
        this.sedComp.set("attributes", (BValue)BInteger.make((int)(n |= Math.max(0, Math.min(7, this.getSubscriptDigits().getInt())))));
        if (!this.getFont().isNull()) {
            BFont bFont = this.getPaintFont();
            this.sedComp.set("fontSize", (BValue)BInteger.make((int)((int)bFont.getSize())));
            this.sedComp.set("fontName", (BValue)BDynamicEnum.make((int)(bFont.getName().equals("Lato") ? 1 : 0)));
            this.sedComp.set("fontAttributes", OntFontUtil.makeFontAttr(bFont));
        }
    }

    @Override
    public BFont getPaintFont() {
        try {
            return BFont.make((String)SlotPath.unescape((String)this.getFont().getTag()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return OntFontUtil.DEFAULT_FONT;
        }
    }

    @Override
    public int getSubscriptDigitCount() {
        return this.getSubscriptDigits().getInt();
    }

    @Override
    public boolean paintBackground() {
        return !this.getTransparent();
    }

    @Override
    public BFont[] getRequiredFonts() {
        return new BFont[]{this.getPaintFont()};
    }
}

