/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ox.widgets;

import com.ontrol.sedona.OntImageUtil;
import com.ontrol.sedona.ox.BOxWidget;
import com.ontrol.sedona.ox.OxImageInterface;
import com.ontrol.sedona.types.BImageFileOx;
import com.ontrol.sedona.types.BSedonaSlotOrdText;
import java.io.File;
import javax.baja.gx.BImage;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import sedona.Component;

public class BNumericSelectImage
extends BOxWidget
implements OxImageInterface {
    public static final Property in = BNumericSelectImage.newProperty((int)64, (BValue)BSedonaSlotOrdText.DEFAULT_BYTE_IN, null);
    public static final Property imageZero = BNumericSelectImage.newProperty((int)0, (BValue)BImageFileOx.NULL, (BFacets)FACET_CUSTOM_HANDLING);
    public static final Property maxIndex = BNumericSelectImage.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BNumericSelectImage.class);

    public BSedonaSlotOrdText getIn() {
        return (BSedonaSlotOrdText)this.get(in);
    }

    public void setIn(BSedonaSlotOrdText bSedonaSlotOrdText) {
        this.set(in, (BValue)bSedonaSlotOrdText, null);
    }

    public BImageFileOx getImageZero() {
        return (BImageFileOx)this.get(imageZero);
    }

    public void setImageZero(BImageFileOx bImageFileOx) {
        this.set(imageZero, (BValue)bImageFileOx, null);
    }

    public int getMaxIndex() {
        return this.getInt(maxIndex);
    }

    public void setMaxIndex(int n) {
        this.setInt(maxIndex, n, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BNumericSelectImage() {
        this.hideProperty(shape);
    }

    @Override
    public void updateFromComponent() {
        super.updateFromComponent();
        Component component = this.sedComp.s();
        String string = component.getStr("imageFileNamePrefix");
        if (!string.isEmpty()) {
            this.setImageZero(OntImageUtil.makeImageFileOx(this.editor, string + "0"));
            for (int i = 1; i <= component.getInt("maxIndex"); ++i) {
                OntImageUtil.makeImageFileOx(this.editor, string + i);
            }
        }
    }

    @Override
    public void saveToComponent() throws Exception {
        super.saveToComponent();
        String string = this.getImageZero().getFileExtension();
        String string2 = this.getImageZero().imageCommit().getString();
        if (!string2.isEmpty()) {
            string2 = string2.substring(0, string2.length() - 1);
            for (int i = 1; i <= this.getMaxIndex(); ++i) {
                BImageFileOx bImageFileOx = BImageFileOx.make(string2 + i, string);
                bImageFileOx.imageCommit();
            }
        }
        this.sedComp.set("imageFileNamePrefix", (BValue)BString.make((String)string2));
    }

    @Override
    public BImage getImage() {
        return this.getImageZero().getImage(Math.min(this.getMaxIndex(), Math.max(this.getInValue(0), 0)));
    }

    @Override
    public BImage[] getImages() {
        return this.getImageZero().getImages(this.getMaxIndex());
    }

    @Override
    public File[] getImageFiles() {
        return this.getImageZero().getImageFiles(this.getMaxIndex());
    }

    @Override
    public boolean paintBackground() {
        return false;
    }

    @Override
    public String defaultName() {
        return "SelImg";
    }
}

