/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.types;

import com.ontrol.sedona.OntImageUtil;
import java.io.File;
import java.io.IOException;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import sedona.util.FileUtil;

public class BImageFileOx
extends BStruct {
    public static final Property imageFileName = BImageFileOx.newProperty((int)0, (String)"", null);
    public static final Property fileExtension = BImageFileOx.newProperty((int)0, (String)"null", null);
    public static final Type TYPE = Sys.loadType(BImageFileOx.class);
    public static final BImageFileOx NULL = new BImageFileOx("", "");

    public String getImageFileName() {
        return this.getString(imageFileName);
    }

    public void setImageFileName(String string) {
        this.setString(imageFileName, string, null);
    }

    public String getFileExtension() {
        return this.getString(fileExtension);
    }

    public void setFileExtension(String string) {
        this.setString(fileExtension, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BImageFileOx() {
        this.setImageFileName("");
        this.setFileExtension("");
    }

    private BImageFileOx(String string, String string2) {
        this.setImageFileName(string);
        this.setFileExtension(string2);
    }

    public String toString(Context context) {
        String string = this.getImageFileName();
        if (!string.isEmpty() && !this.getFileExtension().isEmpty()) {
            string = string + "." + this.getFileExtension();
        }
        return string;
    }

    public boolean isNull() {
        return this.getImageFileName().isEmpty();
    }

    public static BImageFileOx make(String string, String string2) {
        return new BImageFileOx(string, string2);
    }

    public static BImageFileOx make(String string) {
        return new BImageFileOx(FileUtil.getBase((String)string), FileUtil.getExtension((String)string));
    }

    public static BImageFileOx make(File file) {
        return BImageFileOx.make(file.getName());
    }

    public static BImageFileOx makeNull() {
        return new BImageFileOx("", "");
    }

    public File getFile() {
        File file;
        if (!this.isNull() && (file = new File(OntImageUtil.oxImageBank, this.getImageFileName() + "." + this.getFileExtension())).exists()) {
            return file;
        }
        return null;
    }

    public File getFile(int n) {
        BOrd bOrd = this.getOrd();
        if (bOrd != null) {
            String string = this.getImageFileName();
            String string2 = this.getFileExtension();
            while (Character.isDigit(string.charAt(string.length() - 1))) {
                string = string.substring(0, string.length() - 1);
            }
            File file = new File(OntImageUtil.oxImageBank, string + n + "." + string2);
            if (file.exists()) {
                return file;
            }
        }
        return null;
    }

    public File[] getImageFiles(int n) {
        if (this == NULL || n <= 0) {
            return new File[0];
        }
        File[] fileArray = new File[n + 1];
        for (int i = 0; i <= n; ++i) {
            fileArray[i] = this.getFile(i);
        }
        return fileArray;
    }

    public BOrd getOrd() {
        File file = this.getFile();
        if (file != null && file.exists()) {
            return BFileSystem.INSTANCE.localFileToOrd(file);
        }
        return null;
    }

    public BImage getImage() {
        BOrd bOrd = this.getOrd();
        if (bOrd == null) {
            return BImage.NULL;
        }
        return BImage.make((BOrd)this.getOrd());
    }

    public BImage getImage(int n) {
        File file = this.getFile(n);
        if (file != null) {
            return BImage.make((BOrd)BFileSystem.INSTANCE.localFileToOrd(file));
        }
        return BImage.NULL;
    }

    public BImage[] getImages(int n) {
        BImage[] bImageArray = new BImage[n + 1];
        for (int i = 0; i <= n; ++i) {
            bImageArray[i] = this.getImage(i);
        }
        return bImageArray;
    }

    public BString imageCommit() {
        if (!this.isNull() && !this.getFileExtension().equalsIgnoreCase("png")) {
            try {
                File file = OntImageUtil.convertToPng(this.getFile());
                if (file != null) {
                    this.setFileExtension("png");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return BString.make((String)this.getImageFileName());
    }
}

