/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.types;

import com.tridium.sys.Nre;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.util.BIValidator;
import javax.baja.util.CannotValidateException;

public final class BOxInteger
extends BSimple
implements BIValidator {
    private static final BOxInteger ZERO = new BOxInteger(0);
    private static final BOxInteger ONE = new BOxInteger(1);
    private static final BOxInteger TWO = new BOxInteger(2);
    private static final BOxInteger THREE = new BOxInteger(3);
    private static final BOxInteger FOUR = new BOxInteger(4);
    private static final BOxInteger FIVE = new BOxInteger(5);
    public static final BOxInteger MIN = new BOxInteger(Integer.MIN_VALUE);
    public static final BOxInteger MAX = new BOxInteger(Integer.MAX_VALUE);
    public static final BOxInteger DEFAULT = ZERO;
    public static final Type TYPE = Sys.loadType(BOxInteger.class);
    private int value;

    public static BOxInteger make(int n) {
        switch (n) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case -2147483648: {
                return MIN;
            }
            case 0x7FFFFFFF: {
                return MAX;
            }
        }
        return new BOxInteger(n);
    }

    public static BOxInteger make(String string) {
        return BOxInteger.make(BOxInteger.decode(string));
    }

    private BOxInteger(int n) {
        this.value = n;
    }

    public int getInt() {
        return this.value;
    }

    public long getLong() {
        return this.value;
    }

    public float getFloat() {
        return this.value;
    }

    public double getDouble() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof BOxInteger) {
            return ((BOxInteger)((Object)object)).value == this.value;
        }
        return false;
    }

    public int compareTo(Object object) {
        int n = this.value;
        int n2 = ((BNumber)object).getInt();
        if (n == n2) {
            return 0;
        }
        if (n < n2) {
            return -1;
        }
        return 1;
    }

    public String toString(Context context) {
        return BOxInteger.toString(this.value, context);
    }

    public void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.value);
    }

    public BObject decode(DataInput dataInput) throws IOException {
        return BOxInteger.make(dataInput.readInt());
    }

    public String encodeToString() throws IOException {
        return BOxInteger.encode(this.value);
    }

    public BObject decodeFromString(String string) throws IOException {
        try {
            return BOxInteger.make(string);
        }
        catch (RuntimeException runtimeException) {
            throw new IOException("Invalid integer: " + string);
        }
    }

    public static int decode(String string) {
        if (string.equals("min")) {
            return Integer.MIN_VALUE;
        }
        if (string.equals("max")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(string);
    }

    public static String encode(int n) {
        if (n == Integer.MIN_VALUE) {
            return "min";
        }
        if (n == Integer.MAX_VALUE) {
            return "max";
        }
        return String.valueOf(n);
    }

    public static String toString(int n, Context context) {
        BUnit bUnit;
        Object object;
        int n2 = 10;
        BUnit bUnit2 = null;
        int n3 = Nre.unitConversion;
        boolean bl = true;
        if (context != null) {
            object = (BNumber)context.getFacet("radix");
            if (object != null) {
                n2 = object.getInt();
            }
            if ((bUnit2 = (BUnit)context.getFacet("units")) != null && bUnit2.isNull()) {
                bUnit2 = null;
            }
            n3 = context.getFacets().geti("unitConversion", n3);
            bl = context.getFacets().getb("showUnits", bl);
        }
        if (n3 != 0 && bUnit2 != null && (bUnit = (object = BUnitConversion.make((int)n3)).getDesiredUnit(bUnit2)) != bUnit2) {
            n = (int)bUnit2.convertTo(bUnit, (double)n);
            bUnit2 = bUnit;
        }
        object = n == Integer.MIN_VALUE ? "min" : (n == Integer.MAX_VALUE ? "max" : Integer.toString(n, n2));
        if (bl && bUnit2 != null) {
            object = (String)object + ' ' + bUnit2.getSymbol();
        }
        return object;
    }

    public Type getType() {
        return TYPE;
    }

    public void validate(BObject bObject, Context context) throws CannotValidateException {
        int n = ((BInteger)context.getFacet("min")).getInt();
        int n2 = ((BInteger)context.getFacet("max")).getInt();
        if (this.value < n || this.value > n2) {
            throw new CannotValidateException("Value must be between " + n + " and " + n2);
        }
    }
}

