/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.types;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIValidator;
import javax.baja.util.CannotValidateException;

public final class BOxNumericLabelText
extends BSimple
implements BIValidator {
    public static final BOxNumericLabelText DEFAULT = new BOxNumericLabelText("", 1, "", true, 0);
    public static final BOxNumericLabelText NOSHOW = new BOxNumericLabelText("", 1, "", false, 0);
    public static final BOxNumericLabelText NULL = new BOxNumericLabelText("null", 1, "", false, 0);
    public static final Type TYPE = Sys.loadType(BOxNumericLabelText.class);
    private String prefix;
    private String suffix;
    private int precision;
    private boolean showValue;
    private int maxLen;

    private BOxNumericLabelText(String string, int n, String string2, boolean bl, int n2) {
        this.prefix = string;
        this.precision = n;
        this.suffix = string2;
        this.showValue = bl;
        this.maxLen = n2;
    }

    public int hashCode() {
        return this.toString(null).hashCode();
    }

    public void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput dataInput) throws IOException {
        return this.decodeFromString(dataInput.readUTF());
    }

    public String encodeToString() throws IOException {
        return this.toString(null);
    }

    public BObject decodeFromString(String string) throws IOException {
        return BOxNumericLabelText.make(string, 0);
    }

    public boolean equals(Object object) {
        if (object instanceof BOxNumericLabelText) {
            BOxNumericLabelText bOxNumericLabelText = (BOxNumericLabelText)((Object)object);
            return this.prefix.equals(bOxNumericLabelText.prefix) && this.suffix.equals(bOxNumericLabelText.suffix) && this.precision == bOxNumericLabelText.precision && this.showValue == bOxNumericLabelText.showValue;
        }
        return false;
    }

    public String toString(Context context) {
        if (this.isNull()) {
            return "null";
        }
        String string = this.prefix;
        if (this.showValue) {
            string = string + "%." + this.precision + "f";
        }
        return string + this.suffix;
    }

    public void validate(BObject bObject, Context context) throws CannotValidateException {
        if (this.maxLen > 0 && this.toString(null).length() > this.maxLen) {
            throw new CannotValidateException("Text can't be longer than " + this.maxLen + " characters");
        }
    }

    public static BOxNumericLabelText make(String string, int n, String string2, boolean bl, int n2) {
        return new BOxNumericLabelText(string, n, string2, bl, n2);
    }

    public static BOxNumericLabelText make(String string, int n) {
        if (string.equals("null")) {
            return null;
        }
        String string2 = "";
        String string3 = "";
        int n2 = 0;
        boolean bl = false;
        int n3 = string.indexOf("%.");
        if (n3 >= 0 && n3 <= string.length() - 4) {
            int n4 = string.charAt(n3 + 2) - 48;
            if (n4 >= 0 && n4 <= 9 && string.charAt(n3 + 3) == 'f') {
                bl = true;
                n2 = n4;
                string3 = string.substring(0, n3);
                if (string.length() > n3 + 4) {
                    string2 = string.substring(n3 + 4);
                }
            }
        } else {
            string3 = string;
        }
        return BOxNumericLabelText.make(string3, n2, string2, bl, n);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean getShowValue() {
        return this.showValue;
    }

    public int getMaxLen() {
        return this.maxLen;
    }

    public String getPrefixForPaint() {
        return this.prefix.replaceAll("%%", "%");
    }

    public String getSuffixForPaint() {
        return this.suffix.replaceAll("%%", "%");
    }

    public String numberFormat(double d) {
        int n = this.getPrecision();
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(n);
        decimalFormat.setMinimumFractionDigits(n);
        return decimalFormat.format(d);
    }

    public String getPaintValueString(double d) {
        return this.showValue ? this.numberFormat(d) : "";
    }

    public Type getType() {
        return TYPE;
    }
}

