/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui;

import com.ontrol.sedona.OntImageUtil;
import com.ontrol.sedona.types.BImageFileOx;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.imageio.ImageIO;

public class BImageFileOxFe
extends BWbFieldEditor {
    public static final Type TYPE = Sys.loadType(BImageFileOxFe.class);
    static BImage browseIcon = BImage.make((String)"module://icons/x16/open.png");
    BTextField field = new BTextField("", 60);
    BButton button = new BButton((Command)new Browse((BWidget)this));
    int width;
    int height;
    static final int MAX_FILENAME_LENGTH = 12;

    public Type getType() {
        return TYPE;
    }

    public BImageFileOxFe() {
        this.button.setButtonStyle(BButtonStyle.toolBar);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setStretchColumn(0);
        bGridPane.add(null, (BValue)this.field);
        bGridPane.add(null, (BValue)this.button);
        this.setContent((BWidget)bGridPane);
        this.linkTo("lk0", (BComponent)this.field, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.field, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.field.setEnabled(bl);
        this.button.setEnabled(bl);
    }

    protected void doSetReadonly(boolean bl) {
        this.field.setEditable(!bl);
        this.button.setEnabled(!bl);
    }

    protected void doLoadValue(BObject bObject, Context context) {
        BImageFileOx bImageFileOx = (BImageFileOx)bObject;
        this.field.setText(bImageFileOx.toString());
        BFacets bFacets = context.getFacets();
        this.width = bFacets.geti("width", 0);
        this.height = bFacets.geti("height", 0);
    }

    protected BObject doSaveValue(BObject bObject, Context context) {
        BImageFileOx bImageFileOx = (BImageFileOx)bObject;
        String string = this.field.getText();
        if (string.isEmpty()) {
            bImageFileOx.setImageFileName("");
            bImageFileOx.setFileExtension("");
        } else {
            bImageFileOx.setImageFileName(FileUtil.getBase((String)string));
            bImageFileOx.setFileExtension(FileUtil.getExtension((String)string));
        }
        return bImageFileOx;
    }

    protected class FileLengthFilter
    implements IFileFilter {
        int maxLength;

        public FileLengthFilter(int n) {
            this.maxLength = n;
        }

        public String getDescription(Context context) {
            return "image files with names 3 to " + this.maxLength + " characters long";
        }

        public boolean accept(BIFile bIFile) {
            int n = FileUtil.getBase((String)bIFile.getFileName()).length();
            return ExtFileFilter.images.accept(bIFile) && n > 2 && n <= this.maxLength;
        }
    }

    class Browse
    extends Command {
        public Browse(BWidget bWidget) {
            super(bWidget, "");
        }

        public BImage getIcon() {
            return browseIcon;
        }

        public CommandArtifact doInvoke() throws IOException {
            String string;
            File file;
            BFileChooser bFileChooser = BFileChooser.makeOpen((BWidget)BImageFileOxFe.this);
            bFileChooser.addFilter((IFileFilter)new FileLengthFilter(12));
            bFileChooser.setCurrentDirectory(BFileSystem.INSTANCE.localFileToOrd(OntImageUtil.oxImageBank));
            BOrd bOrd = bFileChooser.show();
            if (bOrd != null && (file = new File(OntImageUtil.oxImageBank, string = bOrd.resolve().getFilePath().getName())).exists()) {
                BufferedImage bufferedImage = ImageIO.read(file);
                if (BImageFileOxFe.this.width > 0 && bufferedImage.getWidth() != BImageFileOxFe.this.width) {
                    throw new IOException("Image must be " + BImageFileOxFe.this.width + " pixels wide.");
                }
                if (BImageFileOxFe.this.height > 0 && bufferedImage.getHeight() != BImageFileOxFe.this.height) {
                    throw new IOException("Image must be " + BImageFileOxFe.this.height + " pixels high.");
                }
                BImageFileOxFe.this.field.setText(string);
                return null;
            }
            BImageFileOxFe.this.field.setText("");
            return null;
        }
    }
}

