/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui;

import com.ontrol.sedona.ui.SedonaAddressNode;
import com.tridium.modbusCore.client.point.BModbusClientBooleanProxyExt;
import com.tridium.modbusCore.client.point.BModbusClientNumericProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.nsedona.sys.BSedonaComponent;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.workbench.view.BWbView;

public class BModbusAddressView
extends BWbView {
    BTreeTable treetable;
    public static final Type TYPE = Sys.loadType(BModbusAddressView.class);

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BSedonaComponent bSedonaComponent = (BSedonaComponent)bObject;
        this.treetable = new BTreeTable((TreeTableModel)new model(bSedonaComponent), (TreeTableController)new controller());
        this.setContent((BWidget)this.treetable);
    }

    private class CopyCommand
    extends Command {
        boolean isWritable;

        public CopyCommand(boolean bl, String string) {
            super((BWidget)BModbusAddressView.this, string);
            this.isWritable = bl;
        }

        public CommandArtifact doInvoke() throws Exception {
            BModbusClientNumericProxyExt bModbusClientNumericProxyExt;
            Object object;
            Clipboard.getDefault().setContents(null);
            int n = BModbusAddressView.this.treetable.getSelection().getRow();
            if (n < 1) {
                return null;
            }
            TreeTableNode treeTableNode = BModbusAddressView.this.treetable.getTreeTableModel().rowToNode(n);
            if (!(treeTableNode instanceof modbusAddressNode)) {
                return null;
            }
            modbusAddressNode modbusAddressNode2 = (modbusAddressNode)treeTableNode;
            String string = (String)modbusAddressNode2.getModbusAddress();
            if (string.isEmpty()) {
                return null;
            }
            BFlexAddress bFlexAddress = new BFlexAddress();
            bFlexAddress.setAddressFormat(BAddressFormatEnum.decimal);
            bFlexAddress.setAddress(string);
            if (modbusAddressNode2.isNumeric()) {
                object = this.isWritable ? new BNumericWritable() : new BNumericPoint();
                bModbusClientNumericProxyExt = new BModbusClientNumericProxyExt();
                bModbusClientNumericProxyExt.setDataType(BDataTypeEnum.signedInteger);
            } else {
                object = this.isWritable ? new BBooleanWritable() : new BBooleanPoint();
                bModbusClientNumericProxyExt = new BModbusClientBooleanProxyExt();
            }
            bModbusClientNumericProxyExt.setDataAddress(bFlexAddress);
            object.setProxyExt((BAbstractProxyExt)bModbusClientNumericProxyExt);
            Clipboard.getDefault().setContents(TransferEnvelope.make((Mark)new Mark((BObject)object, (String)treeTableNode.getValueAt(0))));
            return null;
        }
    }

    private class controller
    extends TreeTableController {
        private controller() {
        }

        protected BMenu makePopup(TreeTableSubject treeTableSubject) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, (Command)new CopyCommand(false, "Copy as modbus point"));
            bMenu.add(null, (Command)new CopyCommand(true, "Copy as modbus writable point"));
            return bMenu;
        }
    }

    class modbusAddressNode
    extends SedonaAddressNode {
        modbusAddressNode(TreeTableModel treeTableModel, BComponent bComponent) {
            super(treeTableModel, bComponent, true);
        }

        modbusAddressNode(TreeTableNode treeTableNode, BComponent bComponent, BIcon bIcon) {
            super(treeTableNode, bComponent, bIcon);
        }

        modbusAddressNode(TreeTableNode treeTableNode, String string, int n, BIcon bIcon) {
            super(treeTableNode, string, n, bIcon);
        }

        @Override
        TreeTableNode newNode(TreeTableNode treeTableNode, BComponent bComponent, BIcon bIcon) {
            return new modbusAddressNode(treeTableNode, bComponent, bIcon);
        }

        @Override
        TreeTableNode newNode(TreeTableNode treeTableNode, String string, int n, BIcon bIcon) {
            return new modbusAddressNode(treeTableNode, string, n, bIcon);
        }

        public Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.getText();
                }
                case 1: {
                    return this.getModbusAddress();
                }
                case 2: {
                    return this.getRegisterType();
                }
            }
            return null;
        }

        public Object getModbusAddress() {
            if (this.obj instanceof BSedonaComponent) {
                return "";
            }
            if (this.compId > 31 && this.slotId > 227) {
                return "na";
            }
            int n = 100 * this.compId + this.slotId;
            if (this.slotId >= 100) {
                n = 0xF000 | this.compId << 7 | this.slotId - 100;
            }
            if (n > 65535) {
                return "na";
            }
            return String.valueOf(n);
        }

        public Object getRegisterType() {
            if (this.obj instanceof BSedonaComponent) {
                return "";
            }
            if (this.isNumeric()) {
                return "Holding (numeric)";
            }
            return "Coil (boolean)";
        }
    }

    class model
    extends TreeTableModel {
        TreeTableNode root;
        final String[] colNames = new String[]{"Component/Slot", "Modbus Register Address (decimal)", "Modbus Register Type"};

        public model(BSedonaComponent bSedonaComponent) throws Exception {
            this.root = new modbusAddressNode(this, bSedonaComponent.getComponentSpace().getRootComponent());
        }

        public String getColumnName(int n) {
            return this.colNames[n];
        }

        public int getColumnCount() {
            return 3;
        }

        public TreeTableNode getRoot(int n) {
            return n == 0 ? this.root : null;
        }

        public int getRootCount() {
            return 1;
        }
    }
}

