/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui;

import com.ontrol.sedona.FileTransferW;
import com.ontrol.sedona.OntFontUtil;
import com.ontrol.sedona.OntImageUtil;
import com.tridium.nsedona.sox.BSoxSession;
import com.tridium.nsedona.sys.BSedonaComponent;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.tooltasks.GetApp;
import com.tridium.sedonaProvisioning.tooltasks.SaveApp;
import com.tridium.workbench.fieldeditors.BDirectoryOrdFE;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Array;
import javax.baja.workbench.view.BWbComponentView;
import sedona.Byte;
import sedona.Schema;
import sedona.Slot;
import sedona.Str;
import sedona.Value;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.util.FileUtil;

public class BOxFileTransfer
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BOxFileTransfer.class);
    SoxClient soxclient;
    Schema schema;
    ProvCx pcx;
    BSedonaComponent platform;
    File saxfile;
    Array imageFiles = new Array(File.class);
    Array fontFiles = new Array(File.class);
    BDirectoryOrdFE getDirOrd = null;
    final BTextField zipFileName = new BTextField();

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.platform = (BSedonaComponent)bObject;
        this.platform.getSpace().getSession();
        BSoxSession bSoxSession = (BSoxSession)this.platform.getSpace().getSession();
        this.soxclient = bSoxSession.getClient();
        this.schema = this.soxclient.readSchema();
        this.pcx = new ProvCx(bSoxSession.openPlatformSession(null), this.getCurrentContext());
        FilePath filePath = this.pcx.getProvStore().getStoreRoot().merge("apps");
        BProgressDialog.open((BWidget)this, (String)"Please wait", (BProgressDialog.Worker)new initWorker());
        BGridPane bGridPane = new BGridPane(4);
        bGridPane.setStretchColumn(2);
        bGridPane.setColumnGap(40.0);
        bGridPane.setRowAlign(BValign.top);
        bGridPane.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"image.png")), "IMAGE FILES", BFont.make((BFont)BFont.DEFAULT, (int)5)));
        bGridPane.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"text.png")), "FONT FILES", BFont.make((BFont)BFont.DEFAULT, (int)5)));
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)this.makeFilelistPane(this.imageFiles));
        bGridPane.add(null, (BValue)this.makeFilelistPane(this.fontFiles));
        bGridPane.add(null, (BValue)new BNullWidget());
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setRowGap(10.0);
        bGridPane2.setColumnAlign(BHalign.fill);
        bGridPane2.add(null, (BValue)new BButton((Command)new commandToGetMissingFiles((BWidget)this)));
        bGridPane2.add(null, (BValue)new BButton((Command)new commandToGetAllFiles((BWidget)this)));
        bGridPane2.add(null, (BValue)new BButton((Command)new commandToTransferFiles((BWidget)this)));
        bGridPane2.add(null, (BValue)new BButton((Command)new commandToTransferOneFile((BWidget)this)));
        bGridPane2.add(null, (BValue)new BButton((Command)new commandToReceiveOneFile((BWidget)this)));
        bGridPane.add(null, (BValue)bGridPane2);
        BBorderPane bBorderPane = new BBorderPane((BWidget)bGridPane, "Files used in App");
        bBorderPane.setBorder(BBorder.solid);
        bBorderPane.setPadding(BInsets.make((double)15.0));
        bBorderPane.setMargin(BInsets.make((double)15.0));
        BGridPane bGridPane3 = new BGridPane(2);
        bGridPane3.setRowGap(15.0);
        bGridPane3.setColumnAlign(BHalign.fill);
        bGridPane3.setHalign(BHalign.left);
        bGridPane3.setValign(BValign.top);
        bGridPane3.add(null, (BValue)new BLabel("Save in"));
        this.getDirOrd = new BDirectoryOrdFE();
        this.getDirOrd.getTextField().setEditable(false);
        this.getDirOrd.loadValue((BObject)BFileSystem.INSTANCE.getAbsoluteOrd(filePath));
        this.getDirOrd.setReadonly(false);
        bGridPane3.add(null, (BValue)this.getDirOrd);
        bGridPane3.add(null, (BValue)new BLabel("App name"));
        this.zipFileName.setText(this.defaultSaxFileName() + ".zip");
        bGridPane3.add(null, (BValue)this.zipFileName);
        bGridPane3.add(null, (BValue)new BNullWidget());
        BGridPane bGridPane4 = new BGridPane(2);
        bGridPane4.setHalign(BHalign.right);
        bGridPane4.setColumnAlign(BHalign.right);
        bGridPane4.add(null, (BValue)new BNullWidget());
        bGridPane4.add(null, (BValue)new BButton((Command)new commandToSaveFiles((BWidget)this)));
        bGridPane3.add(null, (BValue)bGridPane4);
        BBorderPane bBorderPane2 = new BBorderPane((BWidget)bGridPane3, "App & Files Backup");
        bBorderPane2.setBorder(BBorder.solid);
        bBorderPane2.setPadding(BInsets.make((double)15.0));
        bBorderPane2.setMargin(BInsets.make((double)15.0));
        BGridPane bGridPane5 = new BGridPane(1);
        bGridPane5.setColumnAlign(BHalign.fill);
        bGridPane5.add(null, (BValue)bBorderPane);
        bGridPane5.add(null, (BValue)bBorderPane2);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BWizardHeader(BImage.make((String)"module://icons/x32/wizard.png"), "App Files Helper", "File transfers to/from device"));
        bEdgePane.setCenter((BWidget)bGridPane5);
        this.setContent((BWidget)bEdgePane);
    }

    private String defaultSaxFileName() throws Exception {
        String string = "app-";
        SoxComponent soxComponent = this.soxclient.loadApp();
        string = string + this.soxclient.readProp(0, soxComponent.slot("deviceName")) + "-";
        string = string + this.soxclient.readProp(0, soxComponent.slot("appName")) + "-";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        string = string + simpleDateFormat.format(new Date());
        return string;
    }

    private BGridPane makeFilelistPane(Array array) {
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setColumnAlign(BHalign.left);
        for (int i = 0; i < array.size(); ++i) {
            File file = (File)array.get(i);
            bGridPane.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)(file.exists() ? "job/success.png" : "job/failed.png")))));
            bGridPane.add(null, (BValue)new BLabel(FileUtil.getBase((String)file.getName())));
        }
        return bGridPane;
    }

    private FilePath getAppDir(BDirectoryOrdFE bDirectoryOrdFE) {
        try {
            BOrd bOrd = (BOrd)bDirectoryOrdFE.saveValue();
            OrdQuery[] ordQueryArray = bOrd.parse();
            return (FilePath)ordQueryArray[ordQueryArray.length - 1];
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void addToZipFile(File file, String string, ZipOutputStream zipOutputStream) throws Exception {
        int n;
        if (!file.exists()) {
            return;
        }
        String string2 = file.getName();
        if (string != null) {
            string2 = string + "/" + string2;
        }
        ZipEntry zipEntry = new ZipEntry(string2);
        zipOutputStream.putNextEntry(zipEntry);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        while ((n = fileInputStream.read(byArray)) >= 0) {
            zipOutputStream.write(byArray, 0, n);
        }
        zipOutputStream.closeEntry();
        fileInputStream.close();
    }

    private void seekImageFiles() throws Exception {
        this.seekImageFiles("OxPage", "imageFileName");
        this.seekImageFiles("NumericKeypad", "imageFileName");
        this.seekImageFiles("PushButtonImage", "imageFileName");
        this.seekImageFiles("BooleanImage", "falseImageFileName");
        this.seekImageFiles("BooleanImage", "trueImageFileName");
        this.seekImageFiles("TimeKeypad", "imageFileName");
        this.seekImageFilesFromNumericSelectOmageComps();
    }

    private void seekImageFiles(String string, String string2) throws Exception {
        SoxComponent[] soxComponentArray = this.loadCompsOfType(string);
        for (int i = 0; i < soxComponentArray.length; ++i) {
            File file;
            String string3 = ((Str)this.soxclient.readProp((SoxComponent)soxComponentArray[i], (Slot)soxComponentArray[i].slot((String)string2))).val;
            if (string3.length() <= 0 || this.imageFiles.contains((Object)(file = new File(OntImageUtil.oxImageBank, string3 + ".png")))) continue;
            this.imageFiles.add((Object)file);
        }
    }

    private SoxComponent[] loadCompsOfType(String string) throws Exception {
        sedona.Type type = this.schema.type("ontrolOx::" + string);
        if (type == null) {
            return new SoxComponent[0];
        }
        int[] nArray = this.soxclient.queryService(type);
        return this.soxclient.load(nArray);
    }

    private void seekImageFilesFromNumericSelectOmageComps() throws Exception {
        SoxComponent[] soxComponentArray = this.loadCompsOfType("NumericSelectImage");
        for (int i = 0; i < soxComponentArray.length; ++i) {
            String string = ((Str)this.soxclient.readProp((SoxComponent)soxComponentArray[i], (Slot)soxComponentArray[i].slot((String)"imageFileNamePrefix"))).val;
            int n = ((Byte)this.soxclient.readProp((SoxComponent)soxComponentArray[i], (Slot)soxComponentArray[i].slot((String)"maxIndex"))).val;
            if (string.length() <= 0) continue;
            for (int j = 0; j <= n; ++j) {
                File file = new File(OntImageUtil.oxImageBank, string + j + ".png");
                if (this.imageFiles.contains((Object)file)) continue;
                this.imageFiles.add((Object)file);
            }
        }
    }

    private void seekFontFiles() throws Exception {
        int[] nArray = this.soxclient.queryService(this.schema.type("ontrolOx::Label"));
        SoxComponent[] soxComponentArray = this.soxclient.load(nArray);
        for (int i = 0; i < soxComponentArray.length; ++i) {
            SoxComponent soxComponent = soxComponentArray[i];
            int n = ((Byte)this.soxclient.readProp((SoxComponent)soxComponent, (Slot)soxComponent.slot((String)"fontName"))).val;
            int n2 = ((Byte)this.soxclient.readProp((SoxComponent)soxComponent, (Slot)soxComponent.slot((String)"fontSize"))).val;
            int n3 = ((Byte)this.soxclient.readProp((SoxComponent)soxComponent, (Slot)soxComponent.slot((String)"fontAttributes"))).val;
            String string = OntFontUtil.makeFontString(n, n2, n3);
            File file = new File(OntFontUtil.fontBank, string + ".bin");
            if (this.fontFiles.contains((Object)file)) continue;
            this.fontFiles.add((Object)file);
        }
    }

    private void getFiles(boolean bl) {
        int n = BDialog.confirm((BWidget)this, (Object)BString.make((String)"This will receive files from device into imageBank and fontBank folders, overwriting existing files if they exist. Please confirm."));
        if (n == 8) {
            return;
        }
        Array array = new Array(File.class, this.imageFiles.size());
        for (int i = 0; i < this.imageFiles.size(); ++i) {
            File file = (File)this.imageFiles.get(i);
            if (!bl && file.exists()) continue;
            array.add((Object)new File(file.getParent(), "natives/" + FileUtil.getBase((String)file.getName()) + ".bin"));
        }
        Array array2 = new Array(File.class);
        for (int i = 0; i < this.fontFiles.size(); ++i) {
            File file = (File)this.fontFiles.get(i);
            if (!bl && file.exists()) continue;
            array2.add((Object)file);
        }
        FileTransferW fileTransferW = new FileTransferW(this.soxclient, true);
        fileTransferW.addFileArray(array2, "fonts");
        fileTransferW.addFileArray(array, "images");
        BProgressDialog.open((BWidget)this, (String)"Getting files...", (BProgressDialog.Worker)fileTransferW);
        for (int i = 0; i < array.size(); ++i) {
            File file = (File)array.get(i);
            if (!file.exists()) continue;
            OntImageUtil.convertNativeToPng(file);
        }
    }

    private class initWorker
    extends BProgressDialog.Worker {
        public void doCancel() throws Exception {
        }

        public void doRun() throws Exception {
            this.getDialog().getProgressBar().setIndeterminate(true);
            this.updateProgress("Saving application");
            new SaveApp().execute(BOxFileTransfer.this.pcx);
            this.updateProgress("Getting application");
            BOxFileTransfer.this.saxfile = new File(Sys.getBajaHome(), "sedona/ontrol/app.sax");
            FilePath filePath = BFileSystem.INSTANCE.localFileToPath(BOxFileTransfer.this.saxfile);
            GetApp getApp = new GetApp(filePath, false);
            getApp.execute(BOxFileTransfer.this.pcx);
            this.updateProgress("Discovering used images");
            BOxFileTransfer.this.seekImageFiles();
            this.updateProgress("Discovering used fonts");
            BOxFileTransfer.this.seekFontFiles();
        }
    }

    private class commandToTransferOneFile
    extends Command {
        public commandToTransferOneFile(BWidget bWidget) {
            super(bWidget, "Transfer custom file");
        }

        public CommandArtifact doInvoke() throws Exception {
            String string;
            String string2;
            BFileChooser bFileChooser = BFileChooser.makeOpen((BWidget)BOxFileTransfer.this);
            BOrd bOrd = bFileChooser.show();
            if (bOrd != null && (string2 = BDialog.prompt((BWidget)BOxFileTransfer.this, (String)"Destination Directory", (String)"", (int)20)) != null && BDialog.confirm((BWidget)BOxFileTransfer.this, (Object)BString.make((String)(string = "Transfer file " + bOrd.toString() + " to " + string2 + " directory?"))) == 4) {
                FileTransferW fileTransferW = new FileTransferW(BOxFileTransfer.this.soxclient, false);
                fileTransferW.addFile(bOrd, string2);
                BProgressDialog.open((BWidget)BOxFileTransfer.this, (String)"Transferring file...", (BProgressDialog.Worker)fileTransferW);
            }
            return null;
        }
    }

    private class commandToReceiveOneFile
    extends Command {
        public commandToReceiveOneFile(BWidget bWidget) {
            super(bWidget, "Receive custom file");
        }

        public CommandArtifact doInvoke() throws Exception {
            String string;
            String string2 = BDialog.prompt((BWidget)BOxFileTransfer.this, (String)"Receive file with name:", (String)"", (int)20);
            if (string2 != null && string2 != "" && (string = BDialog.prompt((BWidget)BOxFileTransfer.this, (String)"Receive file from directory:", (String)"", (int)20)) != null && string != "") {
                FileTransferW fileTransferW = new FileTransferW(BOxFileTransfer.this.soxclient, true);
                File file = new File(Sys.getBajaHome(), "sedona/ontrol/" + string2);
                fileTransferW.addFile(file, string);
                BProgressDialog.open((BWidget)BOxFileTransfer.this, (String)("Receiving file " + string + "/" + string2), (BProgressDialog.Worker)fileTransferW);
            }
            return null;
        }
    }

    private class commandToTransferFiles
    extends Command {
        public commandToTransferFiles(BWidget bWidget) {
            super(bWidget, "Clean up device memory");
        }

        public CommandArtifact doInvoke() throws Exception {
            int n = BDialog.confirm((BWidget)BOxFileTransfer.this, (Object)BString.make((String)"This will first delete image and font folders on device flash memory,\nthen transfer the required files. Please confirm."));
            if (n == 8) {
                return null;
            }
            BOxFileTransfer.this.soxclient.invoke(BOxFileTransfer.this.platform.s().id(), BOxFileTransfer.this.platform.sslot("deleteFile"), (Value)Str.make((String)"fonts/*"));
            BOxFileTransfer.this.soxclient.invoke(BOxFileTransfer.this.platform.s().id(), BOxFileTransfer.this.platform.sslot("deleteFile"), (Value)Str.make((String)"images/*"));
            Array array = new Array(File.class);
            for (int i = 0; i < BOxFileTransfer.this.imageFiles.size(); ++i) {
                File file = OntImageUtil.convertImageToNativeFormat((File)BOxFileTransfer.this.imageFiles.get(i));
                if (file == null) continue;
                array.add((Object)file);
            }
            FileTransferW fileTransferW = new FileTransferW(BOxFileTransfer.this.soxclient, false);
            fileTransferW.addFileArray(BOxFileTransfer.this.fontFiles, "fonts");
            fileTransferW.addFileArray(array, "images");
            BProgressDialog.open((BWidget)BOxFileTransfer.this, (String)"Transferring files...", (BProgressDialog.Worker)fileTransferW);
            return null;
        }
    }

    private class commandToGetMissingFiles
    extends Command {
        public commandToGetMissingFiles(BWidget bWidget) {
            super(bWidget, "Get missing files from device");
        }

        public CommandArtifact doInvoke() throws Exception {
            BOxFileTransfer.this.getFiles(false);
            return null;
        }
    }

    private class commandToGetAllFiles
    extends Command {
        public commandToGetAllFiles(BWidget bWidget) {
            super(bWidget, "Get all files from device");
        }

        public CommandArtifact doInvoke() throws Exception {
            BOxFileTransfer.this.getFiles(true);
            return null;
        }
    }

    private class commandToSaveFiles
    extends Command {
        public commandToSaveFiles(BWidget bWidget) {
            super(bWidget, "Save app & files (Backup)");
        }

        public CommandArtifact doInvoke() throws Exception {
            int n;
            String string = BOxFileTransfer.this.zipFileName.getText();
            if (!string.endsWith(".zip")) {
                string = string + ".zip";
            }
            FilePath filePath = BOxFileTransfer.this.getAppDir(BOxFileTransfer.this.getDirOrd).merge(string);
            File file = BFileSystem.INSTANCE.pathToLocalFile(filePath);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
            BOxFileTransfer.this.addToZipFile(BOxFileTransfer.this.saxfile, null, zipOutputStream);
            for (n = 0; n < BOxFileTransfer.this.fontFiles.size(); ++n) {
                BOxFileTransfer.this.addToZipFile((File)BOxFileTransfer.this.fontFiles.get(n), "fontBank", zipOutputStream);
            }
            for (n = 0; n < BOxFileTransfer.this.imageFiles.size(); ++n) {
                BOxFileTransfer.this.addToZipFile((File)BOxFileTransfer.this.imageFiles.get(n), "imageBank", zipOutputStream);
            }
            zipOutputStream.close();
            fileOutputStream.close();
            BDialog.info((BWidget)BOxFileTransfer.this, (Object)BString.make((String)(file.getName() + "  saved.")));
            return null;
        }
    }
}

