/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui.tools;

import com.ontrol.sedona.OntImageUtil;
import com.ontrol.sedona.fieldeditors.BImageDisplayFE;
import com.ontrol.sedona.ox.BOxEditorPane;
import com.ontrol.sedona.ui.tools.RionToolsStep;
import com.tridium.nd.ui.sysdef.BTextOutputPane;
import com.tridium.sedonaProvisioning.ui.tools.BToolWizard;
import com.tridium.ui.wizard.step.CannotCommitException;
import com.tridium.ui.wizard.step.ICommitLog;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import com.tridium.workbench.fieldeditors.BImageFE;
import java.io.File;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import sedona.sox.SoxFile;

public class ChangeLogoTool
extends RionToolsStep {
    BLabel imgLabel;
    BImageFE imgSelect;
    BTextOutputPane outPane;

    public ChangeLogoTool(BToolWizard bToolWizard) {
        super(bToolWizard);
        this.addCommit(new Commit());
    }

    protected String header() {
        return "Change power-up logo";
    }

    protected String description() {
        return "Change power-up logo";
    }

    protected WidgetUiHandler makeUiHandler() {
        return new uiHandler();
    }

    class Commit
    implements WizardStep.ICommit {
        Commit() {
        }

        public void log(String string) {
            if (string != null) {
                ChangeLogoTool.this.outPane.append(string + '\n');
            }
        }

        public void commit(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, ICommitLog iCommitLog, Context context) throws CannotCommitException {
            this.log("Checking image file...");
            BImage bImage = ChangeLogoTool.this.imgLabel.getImage();
            BOrdList bOrdList = bImage.getOrdList();
            if (bOrdList.size() > 0) {
                BOrd bOrd = bOrdList.get(0);
                if (!bOrd.isNull()) {
                    File file = BFileSystem.INSTANCE.pathToLocalFile((bOrd = bOrd.relativizeToSession()).resolve().getFilePath());
                    if (file.exists()) {
                        this.log("Converting image");
                        File file2 = OntImageUtil.convertImageToNativeFormat(file);
                        this.log("Transferring to device");
                        try {
                            ChangeLogoTool.this.provCx.fileTransfer().putFile(SoxFile.make((File)file2), "system/logo.bin");
                        }
                        catch (Exception exception) {
                            this.log("Error transferring file");
                            exception.printStackTrace();
                        }
                    } else {
                        this.log("Image file doesn't exist!");
                    }
                } else {
                    this.log("Null file!");
                }
            } else {
                this.log("No image file selected!");
            }
            this.log("Finished.");
        }
    }

    class uiHandler
    extends WidgetUiHandler {
        uiHandler() {
        }

        public StepArtifact create(WizardStep wizardStep, StepModel stepModel, IWizardView iWizardView, Context context) {
            BOrd bOrd;
            File file;
            Object object;
            BImage bImage = BImage.make((String)"module://ontrolSedonaUtil/com/ontrol/sedona/icons/ontrol.png");
            try {
                object = File.createTempFile("logo", ".bin");
                ChangeLogoTool.this.provCx.fileTransfer().getFile("system/logo.bin", SoxFile.make((File)object));
                file = OntImageUtil.convertNativeToPng(object);
                bOrd = BFileSystem.INSTANCE.localFileToOrd(file);
                bImage = BImage.make((BOrd)bOrd);
                file.deleteOnExit();
                object.deleteOnExit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ChangeLogoTool.this.outPane = new BTextOutputPane("");
            ChangeLogoTool.this.imgLabel = new BLabel(bImage);
            ChangeLogoTool.this.imgLabel.setLayout(BLayout.makeAbs((double)80.0, (double)90.0, (double)320.0, (double)240.0));
            ChangeLogoTool.this.imgLabel.setBackground(BBrush.makeSolid((BColor)BColor.white));
            ChangeLogoTool.this.imgSelect = new BImageDisplayFE(ChangeLogoTool.this.imgLabel);
            ChangeLogoTool.this.imgSelect.linkTo(null, (BComponent)ChangeLogoTool.this.imgSelect, (Slot)BImageDisplayFE.setModified, (Slot)BImageDisplayFE.updateImage);
            object = new BOxEditorPane(480, 420);
            object.add(null, (BValue)ChangeLogoTool.this.imgLabel);
            file = new BGridPane(2);
            file.add(null, (BValue)new BLabel("Select new image file"));
            file.add(null, (BValue)ChangeLogoTool.this.imgSelect);
            bOrd = new BEdgePane((BWidget)file, null, null, null, (BWidget)ChangeLogoTool.this.outPane);
            this.setWidget((BWidget)new BEdgePane(null, null, null, (BWidget)bOrd, (BWidget)object));
            return super.create(wizardStep, stepModel, iWizardView, context);
        }
    }
}

