/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui.tools;

import com.ontrol.sedona.OntFontUtil;
import com.ontrol.sedona.OntImageUtil;
import com.ontrol.sedona.ui.tools.RionToolsStep;
import com.tridium.nd.ui.sysdef.BTextOutputPane;
import com.tridium.nsedona.sox.SoxPlatformSession;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.ui.tools.BToolWizard;
import com.tridium.ui.wizard.step.CannotCommitException;
import com.tridium.ui.wizard.step.ICommitLog;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import java.io.File;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import sedona.Str;
import sedona.Type;
import sedona.Value;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.SoxFile;

public class CleanUpStep
extends RionToolsStep {
    BLabel imageList;
    BLabel fontsList;

    public CleanUpStep(BToolWizard bToolWizard) {
        super(bToolWizard);
        this.addCommit(new Commit());
    }

    protected String header() {
        return "Clean Up Memory";
    }

    protected String description() {
        return "Deletes all image and font files in device memory, then retransfers only images and files needed by app";
    }

    protected WidgetUiHandler makeUiHandler() {
        return new cleanUpUiHandler();
    }

    class cleanUpUiHandler
    extends WidgetUiHandler {
        cleanUpUiHandler() {
        }

        public StepArtifact create(WizardStep wizardStep, StepModel stepModel, IWizardView iWizardView, Context context) {
            CleanUpStep.this.imageList = new BLabel("", BHalign.left);
            CleanUpStep.this.fontsList = new BLabel("", BHalign.left);
            CleanUpStep.this.outPane = new BTextOutputPane("Click 'Finish' to clean-up device memory");
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.setHalign(BHalign.left);
            bGridPane.setRowAlign(BValign.top);
            bGridPane.setColumnGap(80.0);
            bGridPane.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"image.png")), "Images", BFont.make((BFont)BFont.DEFAULT, (int)1)));
            bGridPane.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"text.png")), "Fonts", BFont.make((BFont)BFont.DEFAULT, (int)1)));
            bGridPane.add(null, (BValue)CleanUpStep.this.imageList);
            bGridPane.add(null, (BValue)CleanUpStep.this.fontsList);
            BGridPane bGridPane2 = new BGridPane(1);
            bGridPane2.setColumnAlign(BHalign.fill);
            bGridPane2.setStretchRow(1);
            bGridPane2.add(null, (BValue)new BNullWidget());
            bGridPane2.add(null, (BValue)new BNullWidget());
            bGridPane2.add(null, (BValue)new BBorderPane((BWidget)bGridPane, "FILE LIST"));
            BEdgePane bEdgePane = new BEdgePane(null, null, (BWidget)bGridPane2, (BWidget)CleanUpStep.this.outPane, null);
            BBorderPane bBorderPane = new BBorderPane((BWidget)bEdgePane, 5.0, 5.0, 5.0, 5.0);
            this.setWidget((BWidget)bBorderPane);
            BProgressDialog.open((BWidget)CleanUpStep.this.wizard, (String)"Loading", (BProgressDialog.Worker)new RionToolsStep.getDecodeAnalyzeApp(CleanUpStep.this));
            CleanUpStep.this.imageList.setText(CleanUpStep.this.filesArrayToString(CleanUpStep.this.imageFileNames));
            CleanUpStep.this.fontsList.setText(CleanUpStep.this.filesArrayToString(CleanUpStep.this.fontFileNames));
            return super.create(wizardStep, stepModel, iWizardView, context);
        }
    }

    class Commit
    implements WizardStep.ICommit,
    ProvCx.IProvLog {
        Commit() {
        }

        public void commit(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, ICommitLog iCommitLog, Context context) throws CannotCommitException {
            CleanUpStep.this.provCx.addLog((ProvCx.IProvLog)this);
            new Thread(new commitJob()).start();
        }

        public void log(String string) {
            if (string != null) {
                CleanUpStep.this.outPane.append(string + '\n');
            }
        }

        public void log(String string, double d) {
        }

        class commitJob
        implements Runnable {
            commitJob() {
            }

            @Override
            public final void run() {
                CleanUpStep.this.outPane.clear();
                SoxPlatformSession soxPlatformSession = (SoxPlatformSession)CleanUpStep.this.provCx.session();
                SoxClient soxClient = soxPlatformSession.client;
                try {
                    File file;
                    String string;
                    int n;
                    int n2;
                    Commit.this.log("Checking local copies of image and font files...");
                    for (n2 = 0; n2 < CleanUpStep.this.imageFileNames.size(); ++n2) {
                        CleanUpStep.this.getImageFile((String)CleanUpStep.this.imageFileNames.get(n2), false);
                    }
                    for (n2 = 0; n2 < CleanUpStep.this.fontFileNames.size(); ++n2) {
                        CleanUpStep.this.getFontFile((String)CleanUpStep.this.fontFileNames.get(n2), false);
                    }
                    Commit.this.log("Deleting files in device...");
                    Type type = soxPlatformSession.getSchema().type("sys::PlatformService");
                    int n3 = soxClient.queryService(type)[0];
                    SoxComponent soxComponent = soxClient.load(n3);
                    soxClient.invoke(soxComponent.id(), soxComponent.slot("deleteFile"), (Value)Str.make((String)"fonts/*"));
                    soxClient.invoke(soxComponent.id(), soxComponent.slot("deleteFile"), (Value)Str.make((String)"images/*"));
                    for (n = 0; n < CleanUpStep.this.imageFileNames.size(); ++n) {
                        string = (String)CleanUpStep.this.imageFileNames.get(n);
                        file = new File(OntImageUtil.oxImageBank, string + ".png");
                        if (file.exists()) {
                            File file2 = OntImageUtil.convertImageToNativeFormat(file);
                            Commit.this.log("Transferring image file " + file2.getName());
                            CleanUpStep.this.provCx.fileTransfer().putFile(SoxFile.make((File)file2), "images/" + string + ".bin");
                            continue;
                        }
                        Commit.this.log("WARNING: " + file.getName() + " doesn't exist.");
                    }
                    for (n = 0; n < CleanUpStep.this.fontFileNames.size(); ++n) {
                        string = (String)CleanUpStep.this.fontFileNames.get(n) + ".bin";
                        file = new File(OntFontUtil.fontBank, string);
                        Commit.this.log("Transferring font file " + string);
                        CleanUpStep.this.provCx.fileTransfer().putFile(SoxFile.make((File)file), "fonts/" + string);
                    }
                    Commit.this.log("\nFinished.");
                }
                catch (Exception exception) {
                    Commit.this.log("ERROR: " + exception.getMessage());
                    Commit.this.log("Operation incomplete!");
                    exception.printStackTrace();
                    return;
                }
            }
        }
    }
}

