/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui.tools;

import com.ontrol.sedona.OntFontUtil;
import com.ontrol.sedona.OntImageUtil;
import com.ontrol.sedona.ui.tools.RionToolsStep;
import com.tridium.nd.ui.sysdef.BTextOutputPane;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.ui.tools.BToolWizard;
import com.tridium.ui.wizard.step.CannotCommitException;
import com.tridium.ui.wizard.step.ICommitLog;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import com.tridium.workbench.fieldeditors.BDirectoryOrdFE;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import sedona.Env;
import sedona.Slot;
import sedona.sox.SoxFile;

public class GetAppWithFilesFirstStep
extends RionToolsStep {
    BDirectoryOrdFE getDirOrd;
    BCheckBox saveCksums;
    BTextField getAppName;
    BLabel imageList;
    BLabel fontsList;

    public GetAppWithFilesFirstStep(BToolWizard bToolWizard) {
        super(bToolWizard);
        this.addCommit(new Commit());
    }

    protected String header() {
        return "Get App with files";
    }

    protected String description() {
        return "Backup app & files to zip file";
    }

    protected WidgetUiHandler makeUiHandler() {
        return new getAppUiHandler();
    }

    class Commit
    implements WizardStep.ICommit,
    ProvCx.IProvLog {
        Commit() {
        }

        public void log(String string) {
            if (string != null) {
                GetAppWithFilesFirstStep.this.outPane.append(string + '\n');
            }
        }

        public void log(String string, double d) {
        }

        public void commit(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, ICommitLog iCommitLog, Context context) throws CannotCommitException {
            GetAppWithFilesFirstStep.this.provCx.addLog((ProvCx.IProvLog)this);
            try {
                String string;
                BOrd bOrd = (BOrd)GetAppWithFilesFirstStep.this.getDirOrd.saveValue();
                OrdQuery[] ordQueryArray = bOrd.parse();
                FilePath filePath = (FilePath)ordQueryArray[ordQueryArray.length - 1];
                File file = BFileSystem.INSTANCE.pathToLocalFile(filePath);
                if (!file.exists()) {
                    file.mkdirs();
                }
                if (!(string = GetAppWithFilesFirstStep.this.getAppName.getText()).endsWith(".zip")) {
                    string = string + ".zip";
                }
                FilePath filePath2 = filePath.merge(string);
                File file2 = BFileSystem.INSTANCE.pathToLocalFile(filePath2);
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
                this.log("Transferring files from device...");
                BProgressDialog.open((BWidget)GetAppWithFilesFirstStep.this.wizard, (String)"\nTransferring from device", (BProgressDialog.Worker)new fileTransferWorker(zipOutputStream));
                this.log("Writing zip file " + file2.getPath());
                string = string.substring(0, string.length() - 4) + ".sax";
                filePath2 = filePath.merge(string);
                File file3 = BFileSystem.INSTANCE.pathToLocalFile(filePath2);
                GetAppWithFilesFirstStep.this.offlineApp.encodeAppXml(file3, !GetAppWithFilesFirstStep.this.saveCksums.getSelected());
                this.addToZipFile(file3, null, zipOutputStream);
                file3.delete();
                zipOutputStream.close();
                fileOutputStream.close();
                this.log("Done!");
            }
            catch (Exception exception) {
                this.log("\n" + exception.getLocalizedMessage() + "\n");
                throw new CannotCommitException((Throwable)exception);
            }
        }

        private void addToZipFile(File file, String string, ZipOutputStream zipOutputStream) throws Exception {
            int n;
            if (!file.exists()) {
                return;
            }
            String string2 = file.getName();
            if (string != null) {
                string2 = string + "/" + string2;
            }
            ZipEntry zipEntry = new ZipEntry(string2);
            zipOutputStream.putNextEntry(zipEntry);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = fileInputStream.read(byArray)) >= 0) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
            fileInputStream.close();
        }

        private class fileTransferWorker
        extends BProgressDialog.Worker {
            ZipOutputStream out;

            fileTransferWorker(ZipOutputStream zipOutputStream) {
                this.out = zipOutputStream;
            }

            boolean transferFileFromDevice(String string, File file) {
                try {
                    GetAppWithFilesFirstStep.this.provCx.fileTransfer().getFile(string + "/" + file.getName(), SoxFile.make((File)file));
                    return true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return false;
                }
            }

            public final void doRun() throws Exception {
                File file;
                String string;
                int n;
                BProgressDialog bProgressDialog = this.getDialog();
                bProgressDialog.getProgressBar().setIndeterminate(true);
                for (n = 0; n < GetAppWithFilesFirstStep.this.imageFileNames.size(); ++n) {
                    string = (String)GetAppWithFilesFirstStep.this.imageFileNames.get(n);
                    this.updateProgress("getting " + string + ".png");
                    file = new File(OntImageUtil.oxImageBank, "natives/" + string + ".bin");
                    if (this.transferFileFromDevice("images", file)) {
                        Commit.this.addToZipFile(OntImageUtil.convertNativeToPng(file), "imageBank", this.out);
                        continue;
                    }
                    Commit.this.log("! can't receive " + string + ".png");
                }
                for (n = 0; n < GetAppWithFilesFirstStep.this.fontFileNames.size(); ++n) {
                    string = (String)GetAppWithFilesFirstStep.this.fontFileNames.get(n);
                    this.updateProgress("getting " + string);
                    file = new File(OntFontUtil.fontBank, string + ".bin");
                    if (!file.exists()) {
                        this.transferFileFromDevice("fonts", file);
                    }
                    if (!file.exists()) continue;
                    Commit.this.addToZipFile(file, "fontBank", this.out);
                }
            }

            public final void doCancel() throws Exception {
            }
        }
    }

    class getAppUiHandler
    extends WidgetUiHandler {
        getAppUiHandler() {
        }

        public StepArtifact create(WizardStep wizardStep, StepModel stepModel, IWizardView iWizardView, Context context) {
            GetAppWithFilesFirstStep.this.imageList = new BLabel("", BHalign.left);
            GetAppWithFilesFirstStep.this.fontsList = new BLabel("", BHalign.left);
            GetAppWithFilesFirstStep.this.saveCksums = new BCheckBox("Save kit checksums in sax file", false);
            GetAppWithFilesFirstStep.this.getAppName = new BTextField("", 60);
            GetAppWithFilesFirstStep.this.getDirOrd = new BDirectoryOrdFE();
            GetAppWithFilesFirstStep.this.getDirOrd.getTextField().setEditable(false);
            GetAppWithFilesFirstStep.this.outPane = new BTextOutputPane("Ready to transfer files from device.");
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.add(null, (BValue)new BLabel("Save in"));
            bGridPane.add(null, (BValue)GetAppWithFilesFirstStep.this.getDirOrd);
            bGridPane.add(null, (BValue)new BLabel("Save file name"));
            bGridPane.add(null, (BValue)GetAppWithFilesFirstStep.this.getAppName);
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)GetAppWithFilesFirstStep.this.saveCksums);
            BGridPane bGridPane2 = new BGridPane(2);
            bGridPane2.setHalign(BHalign.left);
            bGridPane2.setRowAlign(BValign.top);
            bGridPane2.setColumnGap(80.0);
            bGridPane2.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"image.png")), "Images", BFont.make((BFont)BFont.DEFAULT, (int)1)));
            bGridPane2.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"text.png")), "Fonts", BFont.make((BFont)BFont.DEFAULT, (int)1)));
            bGridPane2.add(null, (BValue)GetAppWithFilesFirstStep.this.imageList);
            bGridPane2.add(null, (BValue)GetAppWithFilesFirstStep.this.fontsList);
            BGridPane bGridPane3 = new BGridPane(1);
            bGridPane3.setColumnAlign(BHalign.fill);
            bGridPane3.setStretchRow(1);
            bGridPane3.add(null, (BValue)bGridPane);
            bGridPane3.add(null, (BValue)new BNullWidget());
            bGridPane3.add(null, (BValue)new BBorderPane((BWidget)bGridPane2, "FILE LIST"));
            BEdgePane bEdgePane = new BEdgePane(null, null, (BWidget)bGridPane3, (BWidget)GetAppWithFilesFirstStep.this.outPane, null);
            BBorderPane bBorderPane = new BBorderPane((BWidget)bEdgePane, 5.0, 5.0, 5.0, 5.0);
            BProgressDialog.open((BWidget)GetAppWithFilesFirstStep.this.wizard, (String)"Loading", (BProgressDialog.Worker)new RionToolsStep.getDecodeAnalyzeApp(GetAppWithFilesFirstStep.this));
            GetAppWithFilesFirstStep.this.getDirOrd.loadValue((BObject)BFileSystem.INSTANCE.localFileToOrd(new File(Env.home.getAbsolutePath() + "/store/apps")));
            GetAppWithFilesFirstStep.this.getAppName.setText(this.makeDefaultGetAppName());
            GetAppWithFilesFirstStep.this.imageList.setText(GetAppWithFilesFirstStep.this.filesArrayToString(GetAppWithFilesFirstStep.this.imageFileNames));
            GetAppWithFilesFirstStep.this.fontsList.setText(GetAppWithFilesFirstStep.this.filesArrayToString(GetAppWithFilesFirstStep.this.fontFileNames));
            this.setWidget((BWidget)bBorderPane);
            return super.create(wizardStep, stepModel, iWizardView, context);
        }

        private final String makeDefaultGetAppName() {
            String string = "app-";
            if (GetAppWithFilesFirstStep.this.offlineApp != null) {
                String string2;
                Slot slot;
                String string3;
                Slot slot2 = GetAppWithFilesFirstStep.this.offlineApp.slot("deviceName");
                if (slot2 != null && (string3 = GetAppWithFilesFirstStep.this.offlineApp.getStr(slot2)).length() > 0) {
                    string = string + string3 + '-';
                }
                if ((slot = GetAppWithFilesFirstStep.this.offlineApp.slot("appName")) != null && (string2 = GetAppWithFilesFirstStep.this.offlineApp.getStr(slot)).length() > 0) {
                    string = string + string2 + '-';
                }
            }
            string = string + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + ".zip";
            return string;
        }
    }
}

