/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui.tools;

import com.ontrol.sedona.OntImageUtil;
import com.ontrol.sedona.ui.tools.BOntrolRionTools;
import com.tridium.nd.ui.sysdef.BTextOutputPane;
import com.tridium.nsedona.sox.SoxPlatformSession;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.ui.tools.BToolWizard;
import com.tridium.sedonaProvisioning.ui.tools.ToolWizardStep;
import com.tridium.ui.wizard.step.CannotCommitException;
import com.tridium.ui.wizard.step.ICommitLog;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import com.tridium.workbench.fieldeditors.BDirectoryOrdFE;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BProgressBar;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import sedona.Buf;
import sedona.offline.OfflineApp;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.SoxFile;

public class GetAppWithFilesV2
extends ToolWizardStep {
    private ProvCx provCx;
    private static BImage dirImage = BImage.make((BIcon)BIcon.std((String)"folder.png"));
    private static BImage fileImage = BImage.make((BIcon)BIcon.std((String)"file.png"));
    int fileCount;
    private BTextOutputPane outPane = new BTextOutputPane("");
    private BDirectoryOrdFE widgetDirSelect = new BDirectoryOrdFE();
    private BCheckBox widgetSaveChecksums = new BCheckBox("Save kit checksums in sax file", false);
    private BCheckBox widgetCopyImages = new BCheckBox((ToggleCommand)new CopyImagesToggle((BWidget)this.wizard, ""));
    private BCheckBox widgetOverwriteImages = new BCheckBox("Overwrite local copies in ImageBank folder", false);
    private BTextField widgetAppName = new BTextField("", 60);
    private BTree widgetDirTree;

    public GetAppWithFilesV2(BToolWizard bToolWizard) {
        super(bToolWizard);
        this.addCommit(new Commit());
        this.provCx = bToolWizard.getProvCx();
    }

    protected String header() {
        return "Get App with files";
    }

    protected String description() {
        return "Backup app & files to zip archive";
    }

    protected BImage headerIcon() {
        return BOntrolRionTools.ontrolIcon;
    }

    protected WidgetUiHandler makeUiHandler() {
        return new getAppUiHandler();
    }

    private class CopyImagesToggle
    extends ToggleCommand {
        public CopyImagesToggle(BWidget bWidget, String string) {
            super(bWidget, string);
        }

        public CommandArtifact doInvoke() throws Exception {
            GetAppWithFilesV2.this.widgetOverwriteImages.setEnabled(GetAppWithFilesV2.this.widgetCopyImages.getSelected());
            return super.doInvoke();
        }
    }

    private class Commit
    implements WizardStep.ICommit {
        private Commit() {
        }

        public void log(String string) {
            if (string != null) {
                GetAppWithFilesV2.this.outPane.append(string + '\n');
            }
        }

        public void commit(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, ICommitLog iCommitLog, Context context) throws CannotCommitException {
            try {
                this.log("saving App");
                GetAppWithFilesV2.this.provCx.session().saveApp();
                BOrd bOrd = (BOrd)GetAppWithFilesV2.this.widgetDirSelect.saveValue();
                OrdQuery[] ordQueryArray = bOrd.parse();
                FilePath filePath = (FilePath)ordQueryArray[ordQueryArray.length - 1];
                String string = GetAppWithFilesV2.this.widgetAppName.getText();
                if (!string.endsWith(".zip")) {
                    string = string + ".zip";
                }
                FilePath filePath2 = filePath.merge(string);
                File file = BFileSystem.INSTANCE.pathToLocalFile(filePath2);
                this.log("writing zip file " + file.getPath());
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
                BProgressDialog.open((BWidget)GetAppWithFilesV2.this.wizard, (String)"Transferring from device", (BProgressDialog.Worker)new fileTransferWorker(zipOutputStream));
                zipOutputStream.close();
                fileOutputStream.close();
                this.log("Done!");
            }
            catch (Exception exception) {
                this.log(exception.getLocalizedMessage());
                throw new CannotCommitException((Throwable)exception);
            }
        }

        private class fileTransferWorker
        extends BProgressDialog.Worker {
            private ZipOutputStream out;
            private BProgressBar progressBar;

            fileTransferWorker(ZipOutputStream zipOutputStream) {
                this.out = zipOutputStream;
            }

            public final void doCancel() throws Exception {
            }

            public final void doRun() throws Exception {
                this.progressBar = this.getDialog().getProgressBar();
                this.progressBar.setMin(0.0);
                this.progressBar.setMax((double)GetAppWithFilesV2.this.fileCount);
                dirTreeNode dirTreeNode2 = (dirTreeNode)GetAppWithFilesV2.this.widgetDirTree.getModel().getRoot(0);
                this.tr(dirTreeNode2, "");
            }

            private void addToZipFile(byte[] byArray, String string, ZipOutputStream zipOutputStream) throws IOException {
                Commit.this.log("adding " + string);
                zipOutputStream.putNextEntry(new ZipEntry(string));
                zipOutputStream.write(byArray);
                zipOutputStream.closeEntry();
            }

            private void tr(dirTreeNode dirTreeNode2, String string) throws Exception {
                int n = dirTreeNode2.getChildCount();
                for (int i = 0; i < n; ++i) {
                    dirTreeNode dirTreeNode3 = (dirTreeNode)dirTreeNode2.getChild(i);
                    String string2 = string + dirTreeNode3.name;
                    if (dirTreeNode3.isDir) {
                        this.tr(dirTreeNode3, string2 + "/");
                        continue;
                    }
                    this.updateProgress("getting " + string2);
                    Buf buf = new Buf();
                    GetAppWithFilesV2.this.provCx.fileTransfer().getFile(string2, SoxFile.make((Buf)buf));
                    this.addToZipFile(buf.trim(), "device/" + string2, this.out);
                    if (string2.endsWith("app.sab")) {
                        this.doSax(buf);
                    } else if (string2.startsWith("images/")) {
                        this.doImage(buf, dirTreeNode3.name);
                    }
                    this.updateProgress((int)this.progressBar.getValue() + 1);
                }
            }

            private void doImage(Buf buf, String string) {
                File file;
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)OntImageUtil.convertNativeToPng(new ByteArrayInputStream(buf.trim()), buf.size, string);
                String string2 = string.substring(0, string.length() - 4) + ".png";
                try {
                    this.addToZipFile(byteArrayOutputStream.toByteArray(), "pc/imageBank/" + string2, this.out);
                }
                catch (IOException iOException) {
                    Commit.this.log("WARNING: Can't convert " + string + " to PNG!");
                    iOException.printStackTrace();
                    return;
                }
                if (GetAppWithFilesV2.this.widgetCopyImages.getSelected() && (!(file = new File(OntImageUtil.oxImageBank, string2)).exists() || GetAppWithFilesV2.this.widgetOverwriteImages.getSelected())) {
                    try {
                        Commit.this.log("copying " + string2 + " to imageBank");
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(byteArrayOutputStream.toByteArray());
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        Commit.this.log("WARNING: Can't copy " + string2 + " to imageBank!");
                        iOException.printStackTrace();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doSax(Buf buf) throws IOException {
                String string = GetAppWithFilesV2.this.widgetAppName.getText();
                if (string.endsWith(".zip")) {
                    string = string.substring(0, string.length() - 4);
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    buf.seek(0);
                    OfflineApp offlineApp = OfflineApp.decodeAppBinary((Buf)buf);
                    offlineApp.encodeAppXml((OutputStream)byteArrayOutputStream, !GetAppWithFilesV2.this.widgetSaveChecksums.getSelected());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Commit.this.log("WARNING: Can't generate sax file!");
                    return;
                }
                finally {
                    this.addToZipFile(byteArrayOutputStream.toByteArray(), "pc/" + string + ".sax", this.out);
                }
            }
        }
    }

    private class dirTreeNode
    extends TreeNode {
        String name;
        boolean isDir;
        dirTreeNode[] children;

        public dirTreeNode(TreeModel treeModel, String string) {
            super(treeModel);
            this.name = string;
            boolean bl = this.isDir = !string.equals("kits.scode") && (string.lastIndexOf(".") != string.length() - 4 || this.isRoot());
            if (this.isDir) {
                Buf buf = new Buf();
                try {
                    GetAppWithFilesV2.this.provCx.fileTransfer().getFile(this.name, SoxFile.make((Buf)buf));
                }
                catch (Exception exception) {
                    GetAppWithFilesV2.this.outPane.append("Error reading file/directory structure from device\n");
                    exception.printStackTrace();
                }
                String string2 = new String(buf.bytes).trim();
                if (!string2.isEmpty()) {
                    String[] stringArray = string2.split(";");
                    this.children = new dirTreeNode[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.children[i] = new dirTreeNode(this.getModel(), stringArray[i]);
                    }
                }
            } else {
                ++GetAppWithFilesV2.this.fileCount;
            }
        }

        private boolean isRoot() {
            return this.name.isEmpty();
        }

        public String getText() {
            return this.isRoot() ? "Device" : this.name;
        }

        public BImage getIcon() {
            return this.isDir ? dirImage : fileImage;
        }

        public boolean hasChildren() {
            return this.children != null;
        }

        public int getChildCount() {
            return this.children == null ? 0 : this.children.length;
        }

        public TreeNode getChild(int n) {
            return this.children[n];
        }
    }

    private class dirTreeModel
    extends TreeModel {
        dirTreeNode rootNode;

        public dirTreeModel() {
            this.rootNode = new dirTreeNode(this, "");
            this.rootNode.setExpanded(true);
            for (int i = 0; i < this.rootNode.children.length; ++i) {
                if (!this.rootNode.children[i].name.equals("kits.scode")) continue;
                return;
            }
            dirTreeNode[] dirTreeNodeArray = new dirTreeNode[this.rootNode.children.length + 1];
            for (int i = 0; i < this.rootNode.children.length; ++i) {
                dirTreeNodeArray[i] = this.rootNode.children[i];
            }
            dirTreeNodeArray[dirTreeNodeArray.length - 1] = new dirTreeNode(this, "kits.scode");
            this.rootNode.children = dirTreeNodeArray;
        }

        public int getRootCount() {
            return 1;
        }

        public TreeNode getRoot(int n) {
            return n == 0 ? this.rootNode : null;
        }
    }

    private class getAppUiHandler
    extends WidgetUiHandler {
        private getAppUiHandler() {
        }

        public StepArtifact create(WizardStep wizardStep, StepModel stepModel, IWizardView iWizardView, Context context) {
            GetAppWithFilesV2.this.widgetDirTree = new BTree((TreeModel)new dirTreeModel());
            GetAppWithFilesV2.this.widgetDirSelect.getTextField().setEditable(false);
            GetAppWithFilesV2.this.widgetDirSelect.loadValue((BObject)this.defaultSaveDirOrd());
            GetAppWithFilesV2.this.widgetAppName.setText(this.defaultSaveFileName());
            GetAppWithFilesV2.this.widgetCopyImages.setText("Copy images to local ImageBank folder");
            GetAppWithFilesV2.this.widgetCopyImages.setSelected(true);
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.add(null, (BValue)new BLabel("Save in"));
            bGridPane.add(null, (BValue)GetAppWithFilesV2.this.widgetDirSelect);
            bGridPane.add(null, (BValue)new BLabel("Save file name"));
            bGridPane.add(null, (BValue)GetAppWithFilesV2.this.widgetAppName);
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)GetAppWithFilesV2.this.widgetSaveChecksums);
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)GetAppWithFilesV2.this.widgetCopyImages);
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)GetAppWithFilesV2.this.widgetOverwriteImages);
            BGridPane bGridPane2 = new BGridPane(1);
            bGridPane2.setColumnAlign(BHalign.fill);
            bGridPane2.setRowAlign(BValign.fill);
            bGridPane2.setStretchRow(1);
            bGridPane2.add(null, (BValue)new BBorderPane((BWidget)bGridPane, ""));
            bGridPane2.add(null, (BValue)new BBorderPane((BWidget)GetAppWithFilesV2.this.widgetDirTree, "Files in device"));
            BEdgePane bEdgePane = new BEdgePane(null, null, (BWidget)bGridPane2, (BWidget)GetAppWithFilesV2.this.outPane, null);
            this.setWidget((BWidget)new BBorderPane((BWidget)bEdgePane, 5.0, 10.0, 5.0, 10.0));
            return super.create(wizardStep, stepModel, iWizardView, context);
        }

        private BOrd defaultSaveDirOrd() {
            ProvCx.ProvStore provStore = GetAppWithFilesV2.this.provCx.getProvStore();
            FilePath filePath = provStore.getStoreRoot().merge("apps");
            return provStore.getFileSpace().getAbsoluteOrd(filePath);
        }

        private String defaultSaveFileName() {
            String string = "app-";
            try {
                SoxPlatformSession soxPlatformSession = (SoxPlatformSession)GetAppWithFilesV2.this.provCx.session();
                SoxClient soxClient = soxPlatformSession.client;
                SoxComponent soxComponent = soxClient.load(0);
                string = string + soxClient.readProp(soxComponent, soxComponent.slot("deviceName")).toString() + '-';
                string = string + soxClient.readProp(soxComponent, soxComponent.slot("appName")).toString() + '-';
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            string = string + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + ".zip";
            return string;
        }
    }
}

