/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui.tools;

import com.ontrol.sedona.OntFileUtil;
import com.ontrol.sedona.OntFontUtil;
import com.ontrol.sedona.ui.tools.RionToolsStep;
import com.tridium.nd.ui.sysdef.BTextOutputPane;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.ui.tools.BToolWizard;
import com.tridium.ui.wizard.step.CannotCommitException;
import com.tridium.ui.wizard.step.ICommitLog;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import com.tridium.workbench.fieldeditors.BDirectoryOrdFE;
import java.io.File;
import javax.baja.file.BFileSystem;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import sedona.Env;
import sedona.sox.SoxFile;

public class MakeInstallPackage
extends RionToolsStep {
    BDirectoryOrdFE getSaveFolder;
    BTextField getAppName;

    public MakeInstallPackage(BToolWizard bToolWizard) {
        super(bToolWizard);
        this.addCommit(new Commit());
    }

    protected String header() {
        return "Make Install Package";
    }

    protected String description() {
        return "Creates a backup that can be installed with Ontrol Utilities software";
    }

    protected WidgetUiHandler makeUiHandler() {
        return new uiHandler();
    }

    class Commit
    implements WizardStep.ICommit,
    ProvCx.IProvLog {
        Commit() {
        }

        public void log(String string) {
            if (string != null) {
                MakeInstallPackage.this.outPane.append(string + '\n');
            }
        }

        public void log(String string, double d) {
        }

        public void commit(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, ICommitLog iCommitLog, Context context) throws CannotCommitException {
            MakeInstallPackage.this.provCx.addLog((ProvCx.IProvLog)this);
            File file = null;
            try {
                file = MakeInstallPackage.this.resolveFolder((BOrd)MakeInstallPackage.this.getSaveFolder.saveValue());
            }
            catch (Exception exception) {
                this.log("Operation aborted. Can't resolve save folder!");
                this.log(exception.getMessage());
                exception.printStackTrace();
                throw new CannotCommitException("Can't resolve save folder.");
            }
            File file2 = new File(file, MakeInstallPackage.this.getAppName.getText());
            if (!this.txSingleFileToBackup(file2, "", "app.sab", "app.sab")) {
                throw new CannotCommitException("Unable to copy app.sab");
            }
            if (!this.txSingleFileToBackup(file2, "", "kits.scode", "kits.scode")) {
                throw new CannotCommitException("Unable to copy kits.scode");
            }
            this.txSingleFileToBackup(file2, "m", "m.zip", "manifests zip");
            File file3 = new File(file2, "system");
            if (!file3.exists()) {
                file3.mkdirs();
            }
            this.txSingleFileToBackup(file2, "system", "logo.bin", "logo.bin");
            this.log("\nStarting image files transfer...");
            BProgressDialog.open((BWidget)MakeInstallPackage.this.wizard, (String)"\nTransferring from device", (BProgressDialog.Worker)new fileTransfer(MakeInstallPackage.this.imageFileNames, "images", file2));
            this.log("\nAdding font files...");
            File file4 = new File(file2, "fonts");
            if (!file4.exists()) {
                file4.mkdirs();
            }
            for (int i = MakeInstallPackage.this.fontFileNames.size() - 1; i >= 0; --i) {
                String string = (String)MakeInstallPackage.this.fontFileNames.get(i);
                File file5 = new File(OntFontUtil.fontBank, string + ".bin");
                if (file5.exists()) {
                    if (OntFileUtil.copyFile(file5, new File(file4, string + ".bin"))) {
                        this.log("Added font " + string + " from local fontBank folder.");
                        MakeInstallPackage.this.fontFileNames.remove(i);
                        continue;
                    }
                    this.log("Error copying " + string + ".bin from fontBank folder. Will try retrieving from device.");
                    continue;
                }
                this.log("Can't find local copy of font" + string + ". Will try retrieving from device.");
            }
            if (MakeInstallPackage.this.fontFileNames.size() > 0) {
                this.log("\nStarting font files transfer...\n");
                BProgressDialog.open((BWidget)MakeInstallPackage.this.wizard, (String)"\nTransferring from device", (BProgressDialog.Worker)new fileTransfer(MakeInstallPackage.this.fontFileNames, "fonts", file2));
            }
            this.log("\nDone!");
            this.log("Your backup is here: " + file2.getPath());
        }

        private boolean txSingleFileToBackup(File file, String string, String string2, String string3) {
            this.log("\nChecking for " + string3 + " on device (" + string + "/" + string2 + ")");
            File file2 = this.newFile(file, string, string2);
            if (file2 != null) {
                if (this.transferFileFromDevice(string, file2)) {
                    this.log(string3 + " added to backup.");
                    return true;
                }
                this.log(string3 + " file doesn't exist or can't be retrieved.");
                file2.delete();
            }
            return false;
        }

        private File newFile(File file, String string, String string2) {
            File file2 = new File(file, string);
            if (!file2.exists() && !file2.mkdirs()) {
                this.log("Can't make folder " + string);
                return null;
            }
            return new File(file2, string2);
        }

        private boolean transferFileFromDevice(String string, File file) {
            try {
                this.log("Receiving " + file.getName());
                String string2 = string.isEmpty() ? "" : string + "/";
                MakeInstallPackage.this.provCx.fileTransfer().getFile(string2 + file.getName(), SoxFile.make((File)file));
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }

        private class fileTransfer
        extends BProgressDialog.Worker {
            Array fileNames = new Array(String.class);
            String folderInDevice;
            File saveFolder;

            fileTransfer(Array array, String string, File file) {
                this.fileNames = array;
                this.folderInDevice = string;
                this.saveFolder = file;
            }

            public final void doRun() throws Exception {
                File file = new File(this.saveFolder, this.folderInDevice);
                if (!file.exists() && !file.mkdirs()) {
                    throw new Exception("Unable to create folder " + file.getPath());
                }
                int n = this.fileNames.size();
                BProgressDialog bProgressDialog = this.getDialog();
                bProgressDialog.getProgressBar().setMax((double)n);
                bProgressDialog.setTitle("Transferring " + n + " files from " + this.folderInDevice + " folder");
                Commit.this.log(bProgressDialog.getTitle());
                for (int i = 0; i < n; ++i) {
                    String string = (String)this.fileNames.get(i);
                    this.updateProgress(i, "getting file : " + string);
                    File file2 = new File(file, string + ".bin");
                    if (Commit.this.transferFileFromDevice(this.folderInDevice, file2)) continue;
                    Commit.this.log("! can't receive file : " + string);
                }
            }

            public final void doCancel() throws Exception {
                Commit.this.log("!!! Operation cancelled !!!");
            }
        }
    }

    class uiHandler
    extends WidgetUiHandler {
        uiHandler() {
        }

        public StepArtifact create(WizardStep wizardStep, StepModel stepModel, IWizardView iWizardView, Context context) {
            BProgressDialog.open((BWidget)MakeInstallPackage.this.wizard, (String)"Loading", (BProgressDialog.Worker)new RionToolsStep.getDecodeAnalyzeApp(MakeInstallPackage.this));
            MakeInstallPackage.this.outPane = new BTextOutputPane("Ready to transfer files from device.\n");
            MakeInstallPackage.this.getSaveFolder = new BDirectoryOrdFE();
            MakeInstallPackage.this.getAppName = new BTextField("", 60);
            MakeInstallPackage.this.getSaveFolder.getTextField().setEditable(false);
            MakeInstallPackage.this.getSaveFolder.loadValue((BObject)BFileSystem.INSTANCE.localFileToOrd(new File(Env.home.getAbsolutePath() + "/store/ontrol")));
            MakeInstallPackage.this.getAppName.setText(MakeInstallPackage.this.makeDefaultGetAppName());
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.add(null, (BValue)new BLabel("Save in"));
            bGridPane.add(null, (BValue)MakeInstallPackage.this.getSaveFolder);
            bGridPane.add(null, (BValue)new BLabel("Save name"));
            bGridPane.add(null, (BValue)MakeInstallPackage.this.getAppName);
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)new BNullWidget());
            BEdgePane bEdgePane = new BEdgePane(null, null, (BWidget)bGridPane, (BWidget)MakeInstallPackage.this.outPane, null);
            this.setWidget((BWidget)new BBorderPane((BWidget)bEdgePane, 5.0, 5.0, 5.0, 5.0));
            return super.create(wizardStep, stepModel, iWizardView, context);
        }
    }
}

