/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui.tools;

import com.ontrol.sedona.OntFileUtil;
import com.ontrol.sedona.OntFontUtil;
import com.ontrol.sedona.OntImageUtil;
import com.ontrol.sedona.ui.tools.BOntrolRionTools;
import com.tridium.nd.ui.sysdef.BTextOutputPane;
import com.tridium.nsedona.env.KitDb;
import com.tridium.nsedona.env.SedonaEnv;
import com.tridium.nsedona.kitmgr.KitManagerModel;
import com.tridium.nsedona.sox.SoxPlatformSession;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.tooltasks.BuildApp;
import com.tridium.sedonaProvisioning.tooltasks.BuildScode;
import com.tridium.sedonaProvisioning.tooltasks.TransferFiles;
import com.tridium.sedonaProvisioning.ui.tools.BToolWizard;
import com.tridium.sedonaProvisioning.ui.tools.ToolWizardStep;
import com.tridium.ui.wizard.step.CannotCommitException;
import com.tridium.ui.wizard.step.ICommitLog;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import sedona.Env;
import sedona.Kit;
import sedona.Slot;
import sedona.Str;
import sedona.Type;
import sedona.Value;
import sedona.offline.OfflineApp;
import sedona.platform.PlatformManifest;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.SoxFile;
import sedona.util.Version;
import sedona.xml.XContent;
import sedona.xml.XElem;
import sedona.xml.XParser;

public class PutAppWithFilesFirstStep
extends ToolWizardStep {
    private BTextOutputPane outPane;
    private BTextField widgetBackupFileName;
    private BCheckBox widgetUseLocalFonts;
    private BCheckBox widgetUseLatestKits;
    private BButton widgetRestartButton;
    private ProvCx provCx;
    private File backupFile;
    private File propertiesFile = new File(Env.home, "ontrol/ontrol.properties");
    private Properties props = new Properties();
    private SoxComponent platform;
    private String platformId;
    private File saxFile = null;

    public PutAppWithFilesFirstStep(BToolWizard bToolWizard) {
        super(bToolWizard);
        this.addCommit(new Commit());
        this.provCx = bToolWizard.getProvCx();
    }

    protected String header() {
        return "Restore App with files";
    }

    protected String description() {
        return "Restore app from a backup zip or sax file to device, together with associated image and font files";
    }

    protected BImage headerIcon() {
        return BOntrolRionTools.ontrolIcon;
    }

    protected WidgetUiHandler makeUiHandler() {
        return new putAppUiHandler();
    }

    private boolean isZipFile(String string) {
        return string.endsWith("zip");
    }

    private boolean isSaxFile(String string) {
        return string.endsWith("sax");
    }

    private void loadParams() {
        try {
            this.props.load(new FileInputStream(this.propertiesFile));
            String string = this.props.getProperty("rionTools.defaultPutArchiveFile");
            this.backupFile = new File(string);
            this.widgetBackupFileName.setText(string);
            this.widgetUseLocalFonts.setSelected(this.props.getProperty("rionTools.useLocalFontsForPut", "true").equals("true"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveParams() {
        this.props.setProperty("rionTools.defaultPutArchiveFile", this.widgetBackupFileName.getText());
        this.props.setProperty("rionTools.useLocalFontsForPut", this.widgetUseLocalFonts.getSelected() ? "true" : "false");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.propertiesFile);
            this.props.store(fileOutputStream, "");
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void checkSaxFile() throws Exception {
        int n;
        boolean bl = false;
        PlatformManifest platformManifest = this.provCx.env().platformDb().getPlatformManifest(this.platformId);
        for (int i = 0; i < platformManifest.nativeKits.length; ++i) {
            if (!platformManifest.nativeKits[i].name().equals("ontrolPlatform")) continue;
            this.outPane.append("This platform requires ontrolPlatform kit.\n");
            bl = true;
            break;
        }
        XParser xParser = XParser.make((File)this.saxFile);
        XElem xElem = xParser.parse(false);
        XElem xElem2 = xElem.elem("schema");
        XElem[] xElemArray = xElem2.elems();
        if (this.widgetUseLatestKits.getSelected()) {
            for (n = 0; n < xElemArray.length; ++n) {
                xElemArray[n].removeAttr("checksum");
            }
        }
        if (bl) {
            for (n = 0; n < xElemArray.length; ++n) {
                if (!xElemArray[n].get("name").equals("ontrolPlatform")) continue;
                bl = false;
                this.outPane.append("ontrolPlatform kit already in backup sax.\n");
            }
        }
        if (bl) {
            this.outPane.append("ontrolPlatform kit will be added.\n");
            XElem xElem3 = new XElem("kit");
            xElem3.addAttr("name", "ontrolPlatform");
            xElem2.addContent((XContent)xElem3);
        }
        this.saxFile = new File(Env.home, "ontrol/temp.sax");
        xElem.write(this.saxFile);
    }

    private File extractSaxFileFromBackupZip(File file) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        byte[] byArray = new byte[2048];
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            String string2 = string.substring(string.lastIndexOf(47) + 1, string.lastIndexOf("."));
            String string3 = string.substring(string.lastIndexOf("."));
            if (!string3.equals(".sax")) continue;
            File file2 = File.createTempFile(string2, string3);
            file2.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            int n = 0;
            while ((n = zipInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            this.outPane.append("Extracted " + string + "\n");
            zipInputStream.close();
            return file2;
        }
        zipInputStream.close();
        return null;
    }

    private void processBackupArchive(File file, SoxClient soxClient) throws Exception {
        ZipEntry zipEntry;
        File[] fileArray = new File[99];
        String[] stringArray = new String[99];
        int n = 0;
        int n2 = 0;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
        byte[] byArray = new byte[2048];
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string;
            Object object;
            String string2 = zipEntry.getName();
            String string3 = string2.substring(string2.lastIndexOf(47) + 1, string2.lastIndexOf("."));
            String string4 = string2.substring(string2.lastIndexOf("."));
            String string5 = "";
            int n3 = string2.lastIndexOf(47);
            if (n3 > 0) {
                string5 = string2.substring(0, n3);
            }
            File file2 = File.createTempFile(string3, string4);
            file2.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            int n4 = 0;
            while ((n4 = zipInputStream.read(byArray)) > 0) {
                fileOutputStream.write(byArray, 0, n4);
            }
            fileOutputStream.close();
            this.outPane.append("Extracted " + string2 + "\n");
            if ((string5.equals("fonts") || string5.equals("fontBank")) && string4.equals(".bin")) {
                object = new File(OntFontUtil.fontBank, file2.getName());
                if (this.widgetUseLocalFonts.getSelected() && ((File)object).exists()) {
                    OntFileUtil.copyFile((File)object, file2);
                }
                string = "fonts";
            } else {
                if (!string5.equals("imageBank") || !string4.equals(".png")) continue;
                object = OntImageUtil.convertImageToNativeFormat(file2);
                OntFileUtil.copyFile((File)object, file2);
                ((File)object).delete();
                string = "images";
            }
            object = string + "/" + string3 + ".bin";
            fileArray[n] = file2;
            stringArray[n] = object;
            ++n;
            n2 = (int)((long)n2 + file2.length());
            this.outPane.append("Added " + (String)object + "(" + file2.length() + " bytes) to transfer list\n");
        }
        zipInputStream.close();
        int n5 = this.readFreeFlashSpace(soxClient);
        int n6 = n2 / 1024 + 2;
        this.outPane.append("\nFree Flash Space: " + n5 + "MB\n");
        this.outPane.append("Total Transfer Size: ~" + n6 + " MB\n\n");
        if (n5 < n6 && BDialog.open((BWidget)this.wizard, (String)"Warning", (Object)"Memory on device is not sufficient to transfer all files. Continue transfer?", (int)12, (BImage)BDialog.WARNING_ICON) == 8) {
            this.outPane.append("WARNING: Image and font files not transferred!\nApp will start, but images will be missing.");
            return;
        }
        for (int i = 0; i < n; ++i) {
            if ((long)(n5 * 1024) < fileArray[i].length()) {
                BDialog.open((BWidget)this.wizard, (String)"Warning", (Object)"Memory on device is not sufficient to transfer more files", (int)1, (BImage)BDialog.WARNING_ICON);
                this.outPane.append("WARNING: Unable to transfer the following files:\n");
                for (int j = i; j < n; ++j) {
                    this.outPane.append("- " + stringArray[j] + "(" + fileArray[i].length() + "bytes)\n");
                }
                break;
            }
            this.outPane.append("Transferring " + stringArray[i] + "(" + fileArray[i].length() + "bytes) -available memory " + n5 + " MB\n");
            this.provCx.fileTransfer().putFile(SoxFile.make((File)fileArray[i]), stringArray[i]);
            n5 = this.readFreeFlashSpace(soxClient);
        }
    }

    private int readFreeFlashSpace(SoxClient soxClient) throws Exception {
        Slot slot = this.platform.slot("freeFlashSpace");
        String string = soxClient.readProp(this.platform, slot).toString();
        return Integer.parseInt(string.substring(0, string.indexOf(47)));
    }

    private void processSaxFile(TransferFiles transferFiles) throws Exception {
        this.outPane.append("saxFile: " + this.saxFile.getName() + "\n");
        if (this.saxFile == null) {
            return;
        }
        this.checkSaxFile();
        OfflineApp offlineApp = OfflineApp.decodeAppXml((File)this.saxFile);
        this.outPane.append("Decoded app file from backup.\n");
        ontKitManagerModel ontKitManagerModel2 = new ontKitManagerModel(offlineApp, this.provCx.env());
        ontKitManagerModel2.load();
        KitDb.KitSummary[] kitSummaryArray = ontKitManagerModel2.commit();
        this.outPane.append("Loaded required kits.\n\n");
        BuildScode buildScode = new BuildScode(kitSummaryArray, transferFiles);
        buildScode.execute(this.provCx);
        BuildApp buildApp = new BuildApp(offlineApp, kitSummaryArray, transferFiles);
        buildApp.execute(this.provCx);
    }

    class ontKitManagerModel
    extends KitManagerModel {
        public ontKitManagerModel(OfflineApp offlineApp, SedonaEnv sedonaEnv) {
            super(offlineApp, sedonaEnv);
        }

        protected PlatformManifest platformManifest() throws Exception {
            PutAppWithFilesFirstStep.this.outPane.append("\nnativeDepends:\n");
            PlatformManifest platformManifest = PutAppWithFilesFirstStep.this.provCx.env().platformDb().getPlatformManifest(PutAppWithFilesFirstStep.this.platformId);
            for (int i = 0; i < platformManifest.nativeKits.length; ++i) {
                PutAppWithFilesFirstStep.this.outPane.append(platformManifest.nativeKits[i].name() + "\n");
            }
            PutAppWithFilesFirstStep.this.outPane.append("\nappChecksums:\n");
            Kit[] kitArray = this.app.schema.kits;
            for (int i = 0; i < kitArray.length; ++i) {
                PutAppWithFilesFirstStep.this.outPane.append(kitArray[i].name + "--" + kitArray[i].manifest.part() + "\n");
            }
            return platformManifest;
        }
    }

    class Commit
    implements WizardStep.ICommit,
    ProvCx.IProvLog {
        Commit() {
        }

        public void log(String string) {
            if (string != null) {
                PutAppWithFilesFirstStep.this.outPane.append(string + '\n');
            }
        }

        public void log(String string, double d) {
        }

        public void commit(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, ICommitLog iCommitLog, Context context) throws CannotCommitException {
            PutAppWithFilesFirstStep.this.provCx.addLog((ProvCx.IProvLog)this);
            new Thread(new Runnable(){

                @Override
                public final void run() {
                    try {
                        if (PutAppWithFilesFirstStep.this.backupFile == null) {
                            throw new CannotCommitException("Null backup file");
                        }
                        TransferFiles transferFiles = new TransferFiles();
                        PutAppWithFilesFirstStep.this.widgetRestartButton.setText("Please Wait...");
                        PutAppWithFilesFirstStep.this.widgetRestartButton.setVisible(true);
                        String string = PutAppWithFilesFirstStep.this.backupFile.getName();
                        if (PutAppWithFilesFirstStep.this.isSaxFile(string)) {
                            PutAppWithFilesFirstStep.this.saxFile = PutAppWithFilesFirstStep.this.backupFile;
                        } else if (PutAppWithFilesFirstStep.this.isZipFile(string)) {
                            PutAppWithFilesFirstStep.this.saxFile = PutAppWithFilesFirstStep.this.extractSaxFileFromBackupZip(PutAppWithFilesFirstStep.this.backupFile);
                        } else {
                            throw new CannotCommitException("Unrecognized backup file type");
                        }
                        if (PutAppWithFilesFirstStep.this.saxFile == null) {
                            throw new CannotCommitException("No sax file");
                        }
                        PutAppWithFilesFirstStep.this.processSaxFile(transferFiles);
                        transferFiles.execute(PutAppWithFilesFirstStep.this.provCx);
                        if (PutAppWithFilesFirstStep.this.isZipFile(string)) {
                            SoxPlatformSession soxPlatformSession = (SoxPlatformSession)PutAppWithFilesFirstStep.this.provCx.session();
                            SoxClient soxClient = soxPlatformSession.client;
                            Slot slot = PutAppWithFilesFirstStep.this.platform.slot("deleteFile");
                            if (slot != null) {
                                soxClient.invoke(PutAppWithFilesFirstStep.this.platform.id(), slot, (Value)Str.make((String)"fonts/*"));
                                soxClient.invoke(PutAppWithFilesFirstStep.this.platform.id(), slot, (Value)Str.make((String)"images/*"));
                                Commit.this.log("Cleared image and font folders in device.\n");
                            }
                            slot = PutAppWithFilesFirstStep.this.platform.slot("freeFlashSpace");
                            String string2 = soxClient.readProp(PutAppWithFilesFirstStep.this.platform, slot).toString();
                            Commit.this.log("Free Flash Space = " + string2 + "\n");
                            PutAppWithFilesFirstStep.this.processBackupArchive(PutAppWithFilesFirstStep.this.backupFile, soxClient);
                        }
                        PutAppWithFilesFirstStep.this.widgetRestartButton.setText("Restart Device");
                        PutAppWithFilesFirstStep.this.widgetRestartButton.setEnabled(true);
                        if (PutAppWithFilesFirstStep.this.isZipFile(string)) {
                            PutAppWithFilesFirstStep.this.saxFile.delete();
                        }
                        PutAppWithFilesFirstStep.this.saveParams();
                        Commit.this.log("\nApp restore complete.");
                        Commit.this.log("Device needs to be restarted for changes to take effect.\n");
                    }
                    catch (Exception exception) {
                        Commit.this.log("ERROR: " + exception.getMessage());
                        exception.printStackTrace();
                    }
                }
            }).start();
        }
    }

    class putAppUiHandler
    extends WidgetUiHandler {
        BLabel widgetImageList = new BLabel("", BHalign.left);
        BLabel widgetFontsList = new BLabel("", BHalign.left);
        BLabel widgetFilesList = new BLabel("", BHalign.left);

        putAppUiHandler() {
        }

        public StepArtifact create(WizardStep wizardStep, StepModel stepModel, IWizardView iWizardView, Context context) {
            PutAppWithFilesFirstStep.this.widgetBackupFileName = new BTextField("", 60, false);
            PutAppWithFilesFirstStep.this.widgetUseLocalFonts = new BCheckBox("Use local copies of font files", true);
            PutAppWithFilesFirstStep.this.widgetUseLatestKits = new BCheckBox("Use latest kits", true);
            PutAppWithFilesFirstStep.this.widgetRestartButton = new BButton((Command)new commandToRestartDevice());
            PutAppWithFilesFirstStep.this.widgetRestartButton.setVisible(false);
            PutAppWithFilesFirstStep.this.widgetRestartButton.setEnabled(false);
            PutAppWithFilesFirstStep.this.outPane = new BTextOutputPane("");
            BButton bButton = new BButton((Command)new commandToSelectFile(), false, true);
            bButton.setButtonStyle(BButtonStyle.toolBar);
            PutAppWithFilesFirstStep.this.loadParams();
            this.analyzeFile();
            BGridPane bGridPane = new BGridPane(3);
            bGridPane.add(null, (BValue)new BLabel("Zip file to restore"));
            bGridPane.add(null, (BValue)PutAppWithFilesFirstStep.this.widgetBackupFileName);
            bGridPane.add(null, (BValue)bButton);
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)PutAppWithFilesFirstStep.this.widgetUseLocalFonts);
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)PutAppWithFilesFirstStep.this.widgetUseLatestKits);
            BGridPane bGridPane2 = new BGridPane(3);
            bGridPane2.setHalign(BHalign.left);
            bGridPane2.setRowAlign(BValign.top);
            bGridPane2.setColumnGap(80.0);
            bGridPane2.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"image.png")), "Images", BFont.make((BFont)BFont.DEFAULT, (int)1)));
            bGridPane2.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"text.png")), "Fonts", BFont.make((BFont)BFont.DEFAULT, (int)1)));
            bGridPane2.add(null, (BValue)new BLabel(BImage.make((BIcon)BIcon.std((String)"file.png")), "Files", BFont.make((BFont)BFont.DEFAULT, (int)1)));
            bGridPane2.add(null, (BValue)this.widgetImageList);
            bGridPane2.add(null, (BValue)this.widgetFontsList);
            bGridPane2.add(null, (BValue)this.widgetFilesList);
            BGridPane bGridPane3 = new BGridPane(1);
            bGridPane3.setColumnAlign(BHalign.fill);
            bGridPane3.setStretchRow(1);
            bGridPane3.add(null, (BValue)bGridPane);
            bGridPane3.add(null, (BValue)new BNullWidget());
            bGridPane3.add(null, (BValue)new BBorderPane((BWidget)bGridPane2, "FILE LIST"));
            BGridPane bGridPane4 = new BGridPane(2);
            bGridPane4.add(null, (BValue)new BNullWidget());
            bGridPane4.add(null, (BValue)PutAppWithFilesFirstStep.this.widgetRestartButton);
            BEdgePane bEdgePane = new BEdgePane(null, (BWidget)new BBorderPane((BWidget)bGridPane4, 10.0, 0.0, 0.0, 0.0), null, null, (BWidget)PutAppWithFilesFirstStep.this.outPane);
            BEdgePane bEdgePane2 = new BEdgePane(null, null, (BWidget)bGridPane3, (BWidget)bEdgePane, null);
            this.setWidget((BWidget)new BBorderPane((BWidget)bEdgePane2, 5.0, 5.0, 5.0, 5.0));
            this.readPlatform();
            return super.create(wizardStep, stepModel, iWizardView, context);
        }

        private void readPlatform() {
            try {
                SoxPlatformSession soxPlatformSession = (SoxPlatformSession)PutAppWithFilesFirstStep.this.provCx.session();
                SoxClient soxClient = soxPlatformSession.client;
                Type type = soxPlatformSession.getSchema().type("sys::PlatformService");
                int n = soxClient.queryService(type)[0];
                PutAppWithFilesFirstStep.this.platform = soxClient.load(n);
                Slot slot = PutAppWithFilesFirstStep.this.platform.slot("firmwareVersion");
                if (slot == null) {
                    slot = PutAppWithFilesFirstStep.this.platform.slot("pionVersion");
                }
                Version version = new Version(soxClient.readProp(PutAppWithFilesFirstStep.this.platform, slot).toString());
                PutAppWithFilesFirstStep.this.platformId = soxClient.readProp(PutAppWithFilesFirstStep.this.platform, PutAppWithFilesFirstStep.this.platform.slot("platformId")).toString();
                PutAppWithFilesFirstStep.this.outPane.append("Firmware version : " + version.toString() + '\n');
            }
            catch (Exception exception) {
                PutAppWithFilesFirstStep.this.outPane.append("Can't read platform from device. " + exception.getLocalizedMessage() + "\n");
                exception.printStackTrace();
            }
        }

        private void analyzeFile() {
            if (PutAppWithFilesFirstStep.this.backupFile == null) {
                return;
            }
            String string = new String();
            String string2 = new String();
            String string3 = new String();
            String string4 = PutAppWithFilesFirstStep.this.backupFile.getName();
            if (PutAppWithFilesFirstStep.this.isZipFile(string4)) {
                try {
                    ZipEntry zipEntry;
                    ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(PutAppWithFilesFirstStep.this.backupFile));
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        String string5 = zipEntry.getName();
                        String string6 = string5.substring(string5.lastIndexOf(47) + 1, string5.lastIndexOf("."));
                        if (string5.startsWith("image")) {
                            string = string + " " + string6 + "\n";
                            continue;
                        }
                        if (string5.startsWith("font")) {
                            string2 = string2 + " " + string6 + "\n";
                            continue;
                        }
                        string3 = string3 + string5 + "\n";
                    }
                    zipInputStream.close();
                    this.widgetImageList.setText(string);
                    this.widgetFontsList.setText(string2);
                    this.widgetFilesList.setText(string3);
                    PutAppWithFilesFirstStep.this.outPane.append("Ready to transfer app & files to device.\n");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    PutAppWithFilesFirstStep.this.outPane.append("Can't find archive file: " + PutAppWithFilesFirstStep.this.backupFile.getAbsolutePath());
                }
                catch (IOException iOException) {
                    PutAppWithFilesFirstStep.this.outPane.append("Error reading archive file: " + PutAppWithFilesFirstStep.this.backupFile.getAbsolutePath());
                }
            } else if (PutAppWithFilesFirstStep.this.isSaxFile(string4)) {
                this.widgetFilesList.setText(string4);
                PutAppWithFilesFirstStep.this.outPane.append("Ready to transfer app to device.\n");
            } else {
                PutAppWithFilesFirstStep.this.outPane.append("Not a backup file!\n");
            }
        }

        private class commandToRestartDevice
        extends Command {
            public commandToRestartDevice() {
                super((BWidget)PutAppWithFilesFirstStep.this.wizard, "Restart Device");
            }

            public CommandArtifact doInvoke() throws Exception {
                PutAppWithFilesFirstStep.this.provCx.session().restart();
                return null;
            }
        }

        private class commandToSelectFile
        extends Command {
            public commandToSelectFile() {
                super((BWidget)PutAppWithFilesFirstStep.this.wizard, "Select zip file", BImage.make((String)"module://icons/x16/open.png"), null, "Select zip file to restore");
            }

            public CommandArtifact doInvoke() throws Exception {
                BFileChooser bFileChooser = BFileChooser.makeOpen((BWidget)PutAppWithFilesFirstStep.this.wizard);
                bFileChooser.setCurrentDirectory(BOrd.make((String)"local:|file:!sedona/store/apps"));
                BOrd bOrd = bFileChooser.show();
                if (bOrd != null) {
                    PutAppWithFilesFirstStep.this.backupFile = BFileSystem.INSTANCE.pathToLocalFile(bOrd.resolve().getFilePath());
                    if (PutAppWithFilesFirstStep.this.backupFile.exists()) {
                        PutAppWithFilesFirstStep.this.widgetBackupFileName.setText(PutAppWithFilesFirstStep.this.backupFile.getPath());
                        putAppUiHandler.this.analyzeFile();
                    }
                }
                return null;
            }
        }
    }
}

