/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui.tools;

import com.ontrol.sedona.OntFileUtil;
import com.ontrol.sedona.ui.tools.BOntrolRionTools;
import com.ontrol.sedona.ui.tools.ZipTreeTableModel;
import com.tridium.nd.ui.sysdef.BTextOutputPane;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.ui.tools.BToolWizard;
import com.tridium.sedonaProvisioning.ui.tools.ToolWizardStep;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableModel;

public class PutAppWithFilesV2
extends ToolWizardStep {
    private ProvCx provCx;
    File backupFile;
    File saxFile;
    private Properties props = new Properties();
    private File propertiesFile = new File(Sys.getBajaHome(), "sedona/ontrol/ontrol.properties");
    ArrayList<ZipItem> zippedFileNodes = new ArrayList();
    private BTextField widgetBackupFileName = new BTextField("", 60, false);
    private BCheckBox widgetUseLocalFonts = new BCheckBox("Use local copies of font files", true);
    private BTreeTable widgetDirTree;
    private BTextOutputPane outPane = new BTextOutputPane("");

    public PutAppWithFilesV2(BToolWizard bToolWizard) {
        super(bToolWizard);
        this.provCx = bToolWizard.getProvCx();
    }

    protected String header() {
        return "Restore App with files";
    }

    protected String description() {
        return "Restore app from a backup zip or sax file to device, together with associated image and font files";
    }

    protected BImage headerIcon() {
        return BOntrolRionTools.ontrolIcon;
    }

    protected WidgetUiHandler makeUiHandler() {
        return new putAppUiHandler();
    }

    protected void log(String string) {
        if (string != null) {
            this.outPane.append(string + '\n');
        }
    }

    class ZipItem
    implements Comparable<ZipItem> {
        private String directory = "";
        private String fileName;
        private boolean required;
        private boolean restore;

        public String getDirectory() {
            return this.directory;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean getRequired() {
            return this.required;
        }

        public boolean getRestore() {
            return this.restore;
        }

        public ZipItem(String string) {
            int n = string.lastIndexOf(47);
            if (n > 0) {
                this.fileName = string.substring(n + 1);
                this.directory = string.substring(0, n + 1);
            } else {
                this.fileName = string;
            }
        }

        @Override
        public int compareTo(ZipItem zipItem) {
            String string = this.toString();
            String string2 = zipItem.toString();
            if (string.contains("/") & !string2.contains("/")) {
                return -1;
            }
            if (string2.contains("/") & !string.contains("/")) {
                return 1;
            }
            return string.compareTo(string2);
        }

        public boolean equals(Object object) {
            return false;
        }

        public String toString() {
            return this.directory + this.fileName;
        }
    }

    class putAppUiHandler
    extends WidgetUiHandler {
        putAppUiHandler() {
        }

        public StepArtifact create(WizardStep wizardStep, StepModel stepModel, IWizardView iWizardView, Context context) {
            BButton bButton = new BButton((Command)new commandToSelectFile(), false, true);
            bButton.setButtonStyle(BButtonStyle.toolBar);
            PutAppWithFilesV2.this.widgetDirTree = new BTreeTable((TreeTableModel)new ZipTreeTableModel());
            PutAppWithFilesV2.this.widgetDirTree.setCellRenderer((TableCellRenderer)((ZipTreeTableModel)PutAppWithFilesV2.this.widgetDirTree.getModel()).getRenderer());
            PutAppWithFilesV2.this.widgetDirTree.setController((TableController)((ZipTreeTableModel)PutAppWithFilesV2.this.widgetDirTree.getModel()).getTableController());
            this.loadParams();
            try {
                this.analyzeZip();
            }
            catch (IOException iOException) {
                PutAppWithFilesV2.this.outPane.append("ERROR: Can't read archive file!");
                iOException.printStackTrace();
            }
            BGridPane bGridPane = new BGridPane(3);
            bGridPane.add(null, (BValue)new BLabel("Zip or sax file to restore"));
            bGridPane.add(null, (BValue)PutAppWithFilesV2.this.widgetBackupFileName);
            bGridPane.add(null, (BValue)bButton);
            bGridPane.add(null, (BValue)new BNullWidget());
            bGridPane.add(null, (BValue)PutAppWithFilesV2.this.widgetUseLocalFonts);
            BEdgePane bEdgePane = new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane, ""), null, null, null, (BWidget)new BBorderPane((BWidget)PutAppWithFilesV2.this.widgetDirTree, "Files in backup"));
            BEdgePane bEdgePane2 = new BEdgePane(null, null, (BWidget)bEdgePane, (BWidget)PutAppWithFilesV2.this.outPane, null);
            this.setWidget((BWidget)new BBorderPane((BWidget)bEdgePane2, 5.0, 10.0, 5.0, 10.0));
            return super.create(wizardStep, stepModel, iWizardView, context);
        }

        private void loadParams() {
            try {
                PutAppWithFilesV2.this.props.load(new FileInputStream(PutAppWithFilesV2.this.propertiesFile));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            String string = PutAppWithFilesV2.this.props.getProperty("rionTools.defaultPutArchiveFile");
            PutAppWithFilesV2.this.backupFile = new File(string);
            PutAppWithFilesV2.this.widgetBackupFileName.setText(string);
            PutAppWithFilesV2.this.widgetUseLocalFonts.setSelected(PutAppWithFilesV2.this.props.getProperty("rionTools.useLocalFontsForPut", "true").equals("true"));
        }

        protected void analyzeZip() throws IOException {
            ZipEntry zipEntry;
            PutAppWithFilesV2.this.zippedFileNodes.clear();
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(PutAppWithFilesV2.this.backupFile));
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                String string = zipEntry.getName();
                PutAppWithFilesV2.this.zippedFileNodes.add(new ZipItem(string));
                if (!string.endsWith(".sax")) continue;
                PutAppWithFilesV2.this.saxFile = OntFileUtil.extractFileFromZip(zipInputStream, zipEntry);
            }
            zipInputStream.close();
            Collections.sort(PutAppWithFilesV2.this.zippedFileNodes);
            ((ZipTreeTableModel)PutAppWithFilesV2.this.widgetDirTree.getModel()).populate(PutAppWithFilesV2.this.zippedFileNodes);
        }

        private class commandToSelectFile
        extends Command {
            public commandToSelectFile() {
                super((BWidget)PutAppWithFilesV2.this.wizard, "Select zip file", BImage.make((String)"module://icons/x16/open.png"), null, "Select zip file to restore");
            }

            public CommandArtifact doInvoke() throws Exception {
                BFileChooser bFileChooser = BFileChooser.makeOpen((BWidget)PutAppWithFilesV2.this.wizard);
                bFileChooser.setCurrentDirectory(BOrd.make((String)"local:|file:!sedona/store/apps"));
                BOrd bOrd = bFileChooser.show();
                if (bOrd != null) {
                    PutAppWithFilesV2.this.backupFile = BFileSystem.INSTANCE.pathToLocalFile(bOrd.resolve().getFilePath());
                    if (PutAppWithFilesV2.this.backupFile.exists()) {
                        PutAppWithFilesV2.this.widgetBackupFileName.setText(PutAppWithFilesV2.this.backupFile.getPath());
                        putAppUiHandler.this.analyzeZip();
                    }
                }
                return null;
            }
        }
    }
}

