/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui.tools;

import com.ontrol.sedona.ui.tools.RionToolsStep;
import com.tridium.nd.ui.sysdef.BTextOutputPane;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.ui.tools.BToolWizard;
import com.tridium.ui.wizard.step.CannotCommitException;
import com.tridium.ui.wizard.step.ICommitLog;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WidgetUiHandler;
import com.tridium.ui.wizard.step.WizardStep;
import java.io.File;
import javax.baja.file.BFileSystem;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import sedona.sox.SoxFile;

public class PutFileFirstStep
extends RionToolsStep {
    File file;
    BTextField filename;
    BTextField folder;
    BTextOutputPane outPane;

    public PutFileFirstStep(BToolWizard bToolWizard) {
        super(bToolWizard);
        this.addCommit(new Commit());
    }

    protected String header() {
        return "Transfer File";
    }

    protected String description() {
        return "Transfer a single file to device";
    }

    protected WidgetUiHandler makeUiHandler() {
        return new uiHandler();
    }

    class Commit
    implements WizardStep.ICommit,
    ProvCx.IProvLog {
        Commit() {
        }

        public void log(String string) {
            if (string != null) {
                PutFileFirstStep.this.outPane.append(string + '\n');
            }
        }

        public void log(String string, double d) {
        }

        public void commit(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, ICommitLog iCommitLog, Context context) throws CannotCommitException {
            PutFileFirstStep.this.provCx.addLog((ProvCx.IProvLog)this);
            new Thread(new commitJob()).start();
        }

        class commitJob
        implements Runnable {
            commitJob() {
            }

            @Override
            public final void run() {
                PutFileFirstStep.this.outPane.clear();
                Commit.this.log("Transferring " + PutFileFirstStep.this.file.getName() + " to '" + PutFileFirstStep.this.folder.getText() + "' folder in device...");
                try {
                    PutFileFirstStep.this.provCx.fileTransfer().putFile(SoxFile.make((File)PutFileFirstStep.this.file), PutFileFirstStep.this.folder.getText() + "/" + PutFileFirstStep.this.file.getName());
                    Commit.this.log("Done!");
                }
                catch (Exception exception) {
                    Commit.this.log("Error transferring file: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
    }

    class uiHandler
    extends WidgetUiHandler {
        uiHandler() {
        }

        public StepArtifact create(WizardStep wizardStep, StepModel stepModel, IWizardView iWizardView, Context context) {
            PutFileFirstStep.this.filename = new BTextField("", 60, false);
            PutFileFirstStep.this.folder = new BTextField("", 24, true);
            PutFileFirstStep.this.outPane = new BTextOutputPane("Please select a file to transfer");
            BButton bButton = new BButton((Command)new commandToSelectFile(), false, true);
            bButton.setButtonStyle(BButtonStyle.toolBar);
            BGridPane bGridPane = new BGridPane(3);
            bGridPane.add(null, (BValue)new BLabel("File to transfer"));
            bGridPane.add(null, (BValue)PutFileFirstStep.this.filename);
            bGridPane.add(null, (BValue)bButton);
            bGridPane.add(null, (BValue)new BLabel("Destination folder in device"));
            bGridPane.add(null, (BValue)PutFileFirstStep.this.folder);
            BGridPane bGridPane2 = new BGridPane(1);
            bGridPane2.setColumnAlign(BHalign.fill);
            bGridPane2.setStretchRow(1);
            bGridPane2.add(null, (BValue)bGridPane);
            bGridPane2.add(null, (BValue)new BNullWidget());
            BEdgePane bEdgePane = new BEdgePane(null, null, (BWidget)bGridPane2, (BWidget)PutFileFirstStep.this.outPane, null);
            BBorderPane bBorderPane = new BBorderPane((BWidget)bEdgePane, 5.0, 5.0, 5.0, 5.0);
            this.setWidget((BWidget)bBorderPane);
            return super.create(wizardStep, stepModel, iWizardView, context);
        }

        private class commandToSelectFile
        extends Command {
            public commandToSelectFile() {
                super((BWidget)PutFileFirstStep.this.wizard, "Select file", BImage.make((String)"module://icons/x16/open.png"), null, "Select file to transfer");
            }

            public CommandArtifact doInvoke() throws Exception {
                BFileChooser bFileChooser = BFileChooser.makeOpen((BWidget)PutFileFirstStep.this.wizard);
                bFileChooser.setCurrentDirectory(BOrd.make((String)"local:|file:!sedona"));
                BOrd bOrd = bFileChooser.show();
                if (bOrd != null) {
                    PutFileFirstStep.this.file = BFileSystem.INSTANCE.pathToLocalFile(bOrd.resolve().getFilePath());
                    if (PutFileFirstStep.this.file != null && PutFileFirstStep.this.file.exists()) {
                        PutFileFirstStep.this.filename.setText(PutFileFirstStep.this.file.getPath());
                    }
                }
                return null;
            }
        }
    }
}

