/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui.tools;

import com.ontrol.sedona.OntFontUtil;
import com.ontrol.sedona.OntImageUtil;
import com.ontrol.sedona.ui.tools.BOntrolRionTools;
import com.tridium.nd.ui.sysdef.BTextOutputPane;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.tooltasks.GetApp;
import com.tridium.sedonaProvisioning.ui.tools.BToolWizard;
import com.tridium.sedonaProvisioning.ui.tools.ToolWizardStep;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.ui.BProgressDialog;
import sedona.Buf;
import sedona.Component;
import sedona.Slot;
import sedona.Type;
import sedona.offline.OfflineApp;
import sedona.sox.SoxFile;

public abstract class RionToolsStep
extends ToolWizardStep {
    Array imageFileNames = new Array(String.class);
    Array fontFileNames = new Array(String.class);
    ProvCx provCx = this.wizard.getProvCx();
    OfflineApp offlineApp;
    BTextOutputPane outPane;

    public RionToolsStep(BToolWizard bToolWizard) {
        super(bToolWizard);
    }

    protected BImage headerIcon() {
        return BOntrolRionTools.ontrolIcon;
    }

    protected File resolveFolder(BOrd bOrd) {
        OrdQuery[] ordQueryArray = bOrd.parse();
        FilePath filePath = (FilePath)ordQueryArray[ordQueryArray.length - 1];
        File file = BFileSystem.INSTANCE.pathToLocalFile(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    protected final String makeDefaultGetAppName() {
        String string = new String();
        if (this.offlineApp != null) {
            String string2;
            Slot slot;
            String string3;
            Slot slot2 = this.offlineApp.slot("deviceName");
            if (slot2 != null && (string3 = this.offlineApp.getStr(slot2)).length() > 0) {
                string = string + string3 + '-';
            }
            if ((slot = this.offlineApp.slot("appName")) != null && (string2 = this.offlineApp.getStr(slot)).length() > 0) {
                string = string + string2 + '-';
            }
        }
        string = string + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        return string;
    }

    private void addFilesFromComponent(Component component) {
        int n;
        Type type = component.type;
        if (type.is(this.offlineApp.schema.type("ontrolOx::OxPage"))) {
            int n2 = 0;
            if (component.slot("maxImageId") != null) {
                n2 = component.getInt("maxImageId");
            }
            if (n2 <= 0) {
                this.addImageFileToArray(component.getStr("imageFileName"));
            } else {
                this.addImageFilesToArray(component.getStr("imageFileName"), n2);
            }
        } else if (type.is(this.offlineApp.schema.type("ontrolOx::Widget"))) {
            int n3;
            int n4;
            String string;
            Slot[] slotArray = component.type.slots;
            for (n = 0; n < slotArray.length; ++n) {
                Slot slot = slotArray[n];
                if (slot.name.endsWith("mageFileName")) {
                    this.addImageFileToArray(component.getStr(slot));
                    continue;
                }
                if (!slot.name.endsWith("mageFileNamePrefix")) continue;
                this.addImageFilesToArray(component.getStr(slot), component.getInt("maxIndex"));
            }
            if (type.is(this.offlineApp.schema.type("ontrolOx::Label")) && !this.fontFileNames.contains((Object)(string = OntFontUtil.makeFontString(n = component.getInt("fontName"), n4 = component.getInt("fontSize"), n3 = component.getInt("fontAttributes"))))) {
                this.fontFileNames.add((Object)string);
            }
            if (type.is(this.offlineApp.schema.type("ontrolOx::ScheduleLabelSet"))) {
                if (!this.fontFileNames.contains((Object)"9pt Tahoma")) {
                    this.fontFileNames.add((Object)"9pt Tahoma");
                }
                if (!this.fontFileNames.contains((Object)"12pt Tahoma")) {
                    this.fontFileNames.add((Object)"12pt Tahoma");
                }
            }
        }
        Component[] componentArray = component.getChildren();
        for (n = 0; n < componentArray.length; ++n) {
            this.addFilesFromComponent(componentArray[n]);
        }
    }

    private void addImageFileToArray(String string) {
        if (string.length() > 0 && !this.imageFileNames.contains((Object)string)) {
            this.imageFileNames.add((Object)string);
        }
    }

    private void addImageFilesToArray(String string, int n) {
        if (string.length() > 0) {
            for (int i = 0; i <= n; ++i) {
                this.addImageFileToArray(string + i);
            }
        }
    }

    protected String filesArrayToString(Array array) {
        String[] stringArray = (String[])array.trim();
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i] + "\n";
        }
        return string;
    }

    void getImageFile(String string, boolean bl) throws Exception {
        File file = new File(OntImageUtil.oxImageBank, string + ".png");
        if (!file.exists() || bl) {
            this.outPane.append("..getting image: " + string + "\n");
            File file2 = new File(OntImageUtil.oxImageBank, "natives/" + string + ".bin");
            try {
                this.provCx.fileTransfer().getFile("images/" + string + ".bin", SoxFile.make((File)file2));
            }
            catch (Exception exception) {
                this.outPane.append("..WARNING: can't get image " + string + " from device\n");
                exception.printStackTrace();
                return;
            }
            OntImageUtil.convertNativeToPng(file2);
        }
    }

    void getFontFile(String string, boolean bl) throws Exception {
        File file = new File(OntFontUtil.fontBank, string + ".bin");
        if (!file.exists() || bl) {
            this.outPane.append("..getting font: " + string + "\n");
            try {
                this.provCx.fileTransfer().getFile("fonts/" + string + ".bin", SoxFile.make((File)file));
            }
            catch (Exception exception) {
                this.outPane.append("..WARNING: can't get font " + string + " from device\n");
                exception.printStackTrace();
                return;
            }
        }
    }

    class getDecodeAnalyzeApp
    extends BProgressDialog.Worker {
        getDecodeAnalyzeApp() {
        }

        public final void doRun() throws Exception {
            BProgressDialog bProgressDialog = this.getDialog();
            bProgressDialog.getProgressBar().setIndeterminate(true);
            Buf buf = new Buf();
            this.updateProgress("Save App");
            RionToolsStep.this.provCx.session().saveApp();
            this.updateProgress("Get App");
            RionToolsStep.this.provCx.fileTransfer().getFile("app.sab", SoxFile.make((Buf)buf));
            this.updateProgress("Decode App");
            buf.seek(0);
            RionToolsStep.this.offlineApp = GetApp.decodeApp((Buf)buf, (ProvCx)RionToolsStep.this.provCx);
            this.updateProgress("Seek files");
            RionToolsStep.this.addFilesFromComponent((Component)RionToolsStep.this.offlineApp);
        }

        public final void doCancel() throws Exception {
        }
    }
}

