/*
 * Decompiled with CFR 0.152.
 */
package com.ontrol.sedona.ui.tools;

import com.ontrol.sedona.ui.tools.PutAppWithFilesV2;
import java.util.ArrayList;
import java.util.HashSet;
import javax.baja.gx.BImage;
import javax.baja.sys.BIcon;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;

public class ZipTreeTableModel
extends TreeTableModel {
    private ZipTreeTableNode rootNode;
    private ZipTreeTableNode saxNode;
    private ZipTreeTableNode sabNode;
    private ZipTreeTableNode scodeNode;
    private TreeTableCellRenderer renderer = new Renderer();
    private TreeTableController controller = new Controller();
    final String[] colNames = new String[]{"File", "Required by App?", "Restore?"};
    final String yesIcon = "job/success.png";
    final String noIcon = "job/failed.png";
    HashSet<String> imageSet = new HashSet();
    private static BImage dirImage = BImage.make((BIcon)BIcon.std((String)"folder.png"));
    private static BImage fileImage = BImage.make((BIcon)BIcon.std((String)"file.png"));

    public ZipTreeTableModel() {
        this.rootNode = new ZipTreeTableNode(this);
        this.rootNode.setExpanded(true);
    }

    public TreeTableNode getRoot(int n) {
        return n == 0 ? this.rootNode : null;
    }

    public int getRootCount() {
        return 1;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int n) {
        return this.colNames[n];
    }

    public BHalign getColumnAlignment(int n) {
        return BHalign.center;
    }

    protected TreeTableCellRenderer getRenderer() {
        return this.renderer;
    }

    protected TreeTableController getTableController() {
        return this.controller;
    }

    void populate(ArrayList<PutAppWithFilesV2.ZipItem> arrayList) {
        this.rootNode.removeChildren();
        for (PutAppWithFilesV2.ZipItem zipItem : arrayList) {
            this.addChild(zipItem);
        }
        this.updateTreeTable(true);
    }

    void addChild(PutAppWithFilesV2.ZipItem zipItem) {
        ZipTreeTableNode zipTreeTableNode = this.rootNode;
        String[] stringArray = zipItem.getDirectory().split("/");
        if (!stringArray[0].isEmpty()) {
            for (int i = 0; i < stringArray.length; ++i) {
                zipTreeTableNode = zipTreeTableNode.findChildDirectory(stringArray[i]);
            }
        }
        zipTreeTableNode.addChild(zipItem);
    }

    protected class Controller
    extends TreeTableController {
        protected Controller() {
        }
    }

    protected class Renderer
    extends TreeTableCellRenderer {
        protected Renderer() {
        }
    }

    protected class ZipTreeTableNode
    extends TreeTableNode {
        private PutAppWithFilesV2.ZipItem item;
        private String name;
        ZipTreeTableNode[] children;

        public ZipTreeTableNode(TreeTableModel treeTableModel) {
            super(treeTableModel);
            this.children = new ZipTreeTableNode[0];
            this.item = null;
            this.name = "root";
        }

        public ZipTreeTableNode(ZipTreeTableNode zipTreeTableNode, String string) {
            super((TreeTableNode)zipTreeTableNode);
            this.children = new ZipTreeTableNode[0];
            this.item = null;
            this.name = string;
        }

        public ZipTreeTableNode(ZipTreeTableNode zipTreeTableNode, PutAppWithFilesV2.ZipItem zipItem) {
            super((TreeTableNode)zipTreeTableNode);
            this.children = new ZipTreeTableNode[0];
            this.item = zipItem;
            this.name = zipItem.getFileName();
        }

        public BImage getIcon() {
            return this.isDirectory() ? dirImage : fileImage;
        }

        public int getChildCount() {
            return this.children.length;
        }

        public TreeTableNode getChild(int n) {
            return this.children[n];
        }

        public Object getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.name;
                }
                case 1: {
                    return this.isDirectory() ? "" : (this.item.getRequired() ? "check.png" : "");
                }
                case 2: {
                    return this.isDirectory() ? "" : (this.item.getRestore() ? "job/success.png" : "job/failed.png");
                }
            }
            return null;
        }

        public boolean isDirectory() {
            return this.item == null;
        }

        public void removeChildren() {
            this.children = new ZipTreeTableNode[0];
        }

        private ZipTreeTableNode findChildDirectory(String string) {
            for (int i = 0; i < this.children.length; ++i) {
                if (!this.children[i].name.equals(string)) continue;
                return this.children[i];
            }
            return this.addChildDirectory(string);
        }

        private ZipTreeTableNode addChildDirectory(String string) {
            ZipTreeTableNode[] zipTreeTableNodeArray = new ZipTreeTableNode[this.children.length + 1];
            System.arraycopy(this.children, 0, zipTreeTableNodeArray, 0, this.children.length);
            zipTreeTableNodeArray[this.children.length] = new ZipTreeTableNode(this, string);
            this.children = zipTreeTableNodeArray;
            return this.children[this.children.length - 1];
        }

        private ZipTreeTableNode addChild(PutAppWithFilesV2.ZipItem zipItem) {
            ZipTreeTableNode[] zipTreeTableNodeArray = new ZipTreeTableNode[this.children.length + 1];
            System.arraycopy(this.children, 0, zipTreeTableNodeArray, 0, this.children.length);
            zipTreeTableNodeArray[this.children.length] = new ZipTreeTableNode(this, zipItem);
            this.children = zipTreeTableNodeArray;
            return this.children[this.children.length - 1];
        }
    }
}

