/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.dasp;

import com.tridium.nsedona.sox.BSoxScheme;
import com.tridium.nsedona.sox.BSoxSession;
import java.io.IOException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.util.Hashtable;
import javax.baja.security.BICredentials;
import javax.baja.security.BUsernameAndPassword;
import sedona.dasp.DaspException;
import sedona.dasp.DaspMessage;
import sedona.dasp.DaspMsg;
import sedona.dasp.DaspSession;
import sedona.dasp.DaspSocket;
import sedona.dasp.DaspSocketInterface;
import sedona.dasp.DefaultDaspSocketInterface;

public final class TunneledDaspSocket
extends DaspSocket {
    private BICredentials credentials;
    protected final byte[] routePayload;

    protected final DaspSession createDaspSession(DaspSocketInterface daspSocketInterface, int n, InetAddress inetAddress, int n2, boolean bl, Hashtable hashtable) {
        return new DaspSession(daspSocketInterface, n, inetAddress, n2, bl, hashtable){

            protected final void connect() throws Exception {
                DaspMsg daspMsg = this.tunnelHello();
                DaspMsg daspMsg2 = null;
                switch (daspMsg.msgType()) {
                    case 7: {
                        throw new DaspException("Connection denied", daspMsg.errorCode());
                    }
                    case 2: {
                        daspMsg2 = this.tunnelAuthenticate(daspMsg);
                        break;
                    }
                    case 4: {
                        daspMsg2 = daspMsg;
                        break;
                    }
                    default: {
                        throw new DaspException("Unexpected response to hello " + daspMsg.msgType());
                    }
                }
                switch (daspMsg2.msgType()) {
                    case 7: {
                        if (daspMsg2.errorCode() == 228) {
                            throw new DaspException("Connection denied. The user did not authenticate with the UserService on the SoxTunnel.", daspMsg2.errorCode());
                        }
                        throw new DaspException("Connection denied", daspMsg2.errorCode());
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        throw new DaspException("Expected welcome, not " + daspMsg2.msgType());
                    }
                }
                super.connect();
            }

            private final DaspMsg tunnelHello() throws Exception {
                DaspMsg daspMsg = new DaspMsg();
                daspMsg.setMsgType(1);
                daspMsg.setVersion(0);
                daspMsg.setRemoteId(this.id);
                daspMsg.setSessionId((int)((char)-1));
                daspMsg.setPayload(TunneledDaspSocket.this.routePayload);
                long l = 3333L;
                if (l < 1000L) {
                    l = 1000L;
                }
                int n = 0;
                while (n < 3) {
                    this.send(daspMsg);
                    DaspMessage daspMessage = this.receiveAny(l);
                    if (daspMessage != null) {
                        return daspMessage;
                    }
                    ++n;
                }
                throw new DaspException("No response from tunnel hello message. 1) One of the hosts in the sox tunnel may be down, or 2) the sox tunnel may be disabled or in a fault state.");
            }

            private final DaspMsg tunnelAuthenticate(DaspMsg daspMsg) throws Exception {
                String string = daspMsg.digestAlgorithm();
                if (string != "SHA-1") {
                    throw new DaspException("Unsupported tunnel algorithm", 227);
                }
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)TunneledDaspSocket.this.credentials;
                String string2 = bUsernameAndPassword.getUsername() + ':' + bUsernameAndPassword.getPassword().getString();
                messageDigest.update(messageDigest.digest(string2.getBytes("UTF-8")));
                messageDigest.update(daspMsg.nonce());
                byte[] byArray = messageDigest.digest();
                DaspMsg daspMsg2 = new DaspMsg();
                daspMsg2.setMsgType(3);
                daspMsg2.setVersion(0);
                daspMsg2.setSessionId(daspMsg.remoteId());
                daspMsg2.setUsername(bUsernameAndPassword.getUsername());
                daspMsg2.setDigest(byArray);
                long l = 3333L;
                if (l < 1000L) {
                    l = 1000L;
                }
                int n = 0;
                while (n < 3) {
                    this.send(daspMsg2);
                    DaspMessage daspMessage = this.receiveAny(l);
                    if (daspMessage != null) {
                        return daspMessage;
                    }
                    ++n;
                }
                throw new DaspException("No response from tunnel authenticate");
            }
        };
    }

    public TunneledDaspSocket(BSoxSession bSoxSession) throws IOException {
        this(bSoxSession.getCredentials(), bSoxSession.getRoutes());
    }

    public TunneledDaspSocket(BICredentials bICredentials, BSoxScheme.RouteSpec[] routeSpecArray) throws IOException {
        super(null, 14);
        this.credentials = bICredentials;
        this.routePayload = BSoxScheme.RouteSpec.joinRoutes(routeSpecArray).getBytes("UTF-8");
        this.addInterface((DaspSocketInterface)new DefaultDaspSocketInterface(-1));
    }
}

