/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.sox;

import com.tridium.nsedona.sox.BSoxSession;
import com.tridium.nsedona.util.StringUtil;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrdScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.TextUtil;
import sedona.Schema;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSoxScheme
extends BOrdScheme {
    public static final int DEFAULT_PORT = 1876;
    public static final BSoxScheme INSTANCE = new BSoxScheme();
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$nsedona$sox$BSoxScheme;
    static /* synthetic */ Class class$com$tridium$nsedona$sox$BSoxScheme$RouteSpec;

    public OrdQuery parse(String string) {
        return new SoxQuery(string);
    }

    public OrdTarget resolve(OrdTarget ordTarget, OrdQuery ordQuery) throws SyntaxException, UnresolvedException {
        BHost bHost = (BHost)ordTarget.get();
        int n = ((SoxQuery)ordQuery).port;
        RouteSpec[] routeSpecArray = ((SoxQuery)ordQuery).routes;
        BSoxSession bSoxSession = BSoxSession.make(null, bHost, n, routeSpecArray);
        try {
            if (routeSpecArray != null && routeSpecArray.length == 0) {
                throw new SyntaxException("No valid routes");
            }
            bSoxSession.connect();
            return new OrdTarget(ordTarget, (BObject)bSoxSession);
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (BajaRuntimeException bajaRuntimeException) {
            Throwable throwable = bajaRuntimeException.getCause();
            if (throwable != null && throwable instanceof Schema.MissingKitManifestException) {
                Schema.MissingKitManifestException missingKitManifestException = (Schema.MissingKitManifestException)throwable;
                throw new UnresolvedException(StringUtil.formatMissingManifestException(missingKitManifestException), (Throwable)missingKitManifestException);
            }
            throw bajaRuntimeException;
        }
        catch (Throwable throwable) {
            throw new UnresolvedException(ordQuery.toString(), throwable);
        }
    }

    public static RouteSpec[] parseRoutes(String string) {
        if (string == null) {
            return new RouteSpec[0];
        }
        String[] stringArray = TextUtil.splitAndTrim((String)string, (char)'/');
        Class clazz = class$com$tridium$nsedona$sox$BSoxScheme$RouteSpec;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$sox$BSoxScheme$RouteSpec = BSoxScheme.class("[Lcom.tridium.nsedona.sox.BSoxScheme$RouteSpec;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && !stringArray[n].equals("")) {
                String[] stringArray2 = TextUtil.splitAndTrim((String)stringArray[n], (char)'=');
                if (stringArray2.length == 0) {
                    throw new SyntaxException("Empty route at index " + n);
                }
                if (stringArray2.length > 2) {
                    throw new SyntaxException("Invalid route at index " + n + ": " + stringArray[n]);
                }
                RouteSpec routeSpec = stringArray2.length == 1 ? new RouteSpec(stringArray2[0]) : new RouteSpec(stringArray2[0], stringArray2[1]);
                array.add((Object)routeSpec);
            }
            ++n;
        }
        return (RouteSpec[])array.trim();
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private BSoxScheme() {
        super("sox");
    }

    static {
        Class clazz = class$com$tridium$nsedona$sox$BSoxScheme;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$sox$BSoxScheme = BSoxScheme.class("[Lcom.tridium.nsedona.sox.BSoxScheme;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class SoxQuery
    implements OrdQuery {
        int port;
        RouteSpec[] routes;

        public final boolean isHost() {
            return false;
        }

        public final boolean isSession() {
            return true;
        }

        public final void normalize(OrdQueryList ordQueryList, int n) {
            ordQueryList.shiftToHost(n);
        }

        public final String getScheme() {
            return "sox";
        }

        public final String getBody() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.port != 1876) {
                stringBuffer.append(this.port);
            }
            if (this.routes != null) {
                stringBuffer.append(RouteSpec.joinRoutes(this.routes));
            }
            return stringBuffer.toString();
        }

        public final String toString() {
            return "sox:" + this.getBody();
        }

        public final int getPort() {
            return this.port;
        }

        public final boolean hasRoutes() {
            boolean bl = false;
            if (this.routes != null) {
                bl = true;
            }
            return bl;
        }

        public final RouteSpec[] getRoutes() {
            return this.routes;
        }

        private final /* synthetic */ void this() {
            this.routes = null;
        }

        SoxQuery(String string) {
            this.this();
            string = string.trim();
            if (string.length() == 0) {
                this.port = 1876;
            } else {
                int n = string.indexOf(47);
                if (n > -1) {
                    this.port = n == 0 ? 1876 : Integer.parseInt(string.substring(0, n));
                    this.routes = BSoxScheme.parseRoutes(string.substring(n));
                } else {
                    this.port = Integer.parseInt(string);
                }
            }
        }

        SoxQuery(int n) {
            this(n, null);
        }

        SoxQuery(int n, RouteSpec[] routeSpecArray) {
            this.this();
            this.port = n;
            this.routes = routeSpecArray;
        }
    }

    public static final class RouteSpec {
        public final String type;
        public final String address;

        public final String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (!"ip".equals(this.type)) {
                stringBuffer.append(this.type).append('=');
            }
            return stringBuffer.append(this.address).toString();
        }

        public static final String joinRoutes(RouteSpec[] routeSpecArray) {
            return RouteSpec.joinRoutes(routeSpecArray, 0);
        }

        public static final String joinRoutes(RouteSpec[] routeSpecArray, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = n;
            while (n2 < routeSpecArray.length) {
                stringBuffer.append('/').append(routeSpecArray[n2]);
                ++n2;
            }
            return stringBuffer.toString();
        }

        public RouteSpec(String string) {
            this("ip", string);
        }

        public RouteSpec(String string, String string2) {
            if (string == null || string.equals("")) {
                throw new IllegalArgumentException("invalid route type: " + string);
            }
            if (string2 == null || string2.equals("")) {
                throw new IllegalArgumentException("invalid route address: " + string2);
            }
            this.type = string;
            this.address = string2;
        }
    }
}

