/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonaInstaller.wizard;

import com.tridium.sedonaInstaller.wizard.CopyUtil;
import com.tridium.sedonaInstaller.wizard.SedonaInstallerWizardModel;
import com.tridium.sys.Nre;
import com.tridium.sys.module.NModule;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.naming.BOrd;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.util.Array;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SedonaBundle
implements Runnable {
    static final String sedonaZipPath = "modules/sedona.jar";
    static final String sedonacZipPath = "modules/sedonac.jar";
    static final String nsedonaZipPath = "modules/nsedona.jar";
    static final String licenseZipPath = "install-data/licenseAgreement.txt";
    static final File tempDir = new File(new File(Sys.getBajaHome(), "temp"), "sedonaInstaller");
    static final File backupDir = new File(tempDir, "backup");
    static final File stageDir = new File(tempDir, "stage");
    static final File stageSed = new File(stageDir, "sedona");
    static final File stageModules = new File(stageDir, "modules");
    static final File bajaSedonaHome = new File(Sys.getBajaHome(), "sedona");
    final SedonaInstallerWizardModel model;
    final BOrd bundleOrd;
    final File bundleFile;
    boolean hasOpensource;
    boolean hasModules;
    boolean requiresLicense;
    String licenseText;
    boolean warnDowngrade;
    StringBuffer downgrades;
    ZipEntry[] toInstall;
    ZipEntry[] toOverlay;
    File[] toCopy;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$util$zip$ZipEntry;

    public void install() {
        new Thread((Runnable)this, "Sedona-Installer").start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            block6: {
                try {
                    if (this.model.bundleButton.isSelected()) {
                        this.runInstallBundle();
                        break block6;
                    }
                    this.runImport();
                }
                catch (Exception exception) {
                    this.model.installX = exception;
                }
            }
            Object var2_4 = null;
            this.model.updateToDone();
            return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.model.updateToDone();
            throw throwable;
        }
    }

    private final void runInstallBundle() throws Exception {
        this.updateProgress("Preparing installation", 0.0);
        this.clean();
        this.init();
        this.migrate();
        this.extract(this.toInstall);
        this.extract(this.toOverlay);
        this.commitSedonaEnv();
        this.commitModules();
    }

    private final void runImport() throws Exception {
        block3: {
            this.model.installProgress.setIndeterminate(true);
            this.updateProgress("Importing " + this.bundleFile.getName());
            Class clazz = Sys.loadClass((String)"nsedona", (String)"com.tridium.nsedona.env.ImportUtil");
            Class[] classArray = new Class[1];
            Class clazz2 = class$java$io$File;
            if (clazz2 == null) {
                clazz2 = class$java$io$File = SedonaBundle.class("[Ljava.io.File;", false);
            }
            classArray[0] = clazz2;
            Method method = clazz.getMethod("doImport", classArray);
            try {
                method.invoke(clazz.newInstance(), this.bundleFile);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!(invocationTargetException.getTargetException() instanceof Exception)) break block3;
                throw (Exception)invocationTargetException.getTargetException();
            }
        }
    }

    private final void clean() throws Exception {
        FileUtil.delete((File)tempDir);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void init() throws Exception {
        Object object;
        ZipEntry zipEntry;
        Class clazz = class$java$util$zip$ZipEntry;
        if (clazz == null) {
            clazz = class$java$util$zip$ZipEntry = SedonaBundle.class("[Ljava.util.zip.ZipEntry;", false);
        }
        Array array = new Array(clazz);
        Class clazz2 = class$java$util$zip$ZipEntry;
        if (clazz2 == null) {
            clazz2 = class$java$util$zip$ZipEntry = SedonaBundle.class("[Ljava.util.zip.ZipEntry;", false);
        }
        Array array2 = new Array(clazz2);
        ZipFile zipFile = new ZipFile(this.bundleFile);
        try {
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                zipEntry = enumeration.nextElement();
                object = this.relativizeName(zipEntry);
                if (this.model.installOpensource.isSelected() && this.isSedonaEnvFile(zipEntry)) {
                    array.add((Object)zipEntry);
                    continue;
                }
                if (this.model.installModules.isSelected() && ((String)object).startsWith("modules/")) {
                    array.add((Object)zipEntry);
                    continue;
                }
                if (((String)object).equals(licenseZipPath)) {
                    array.add((Object)zipEntry);
                    continue;
                }
                if (!((String)object).startsWith("overlay")) continue;
                array2.add((Object)zipEntry);
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            zipFile.close();
            throw throwable;
        }
        {
            Object var5_10 = null;
        }
        zipFile.close();
        this.toInstall = (ZipEntry[])array.trim();
        this.toOverlay = (ZipEntry[])array2.trim();
        int n = this.toInstall.length + this.toOverlay.length + (int)((double)this.toInstall.length * 0.1);
        if (this.model.migrateEnv.isSelected()) {
            Class clazz3 = class$java$io$File;
            if (clazz3 == null) {
                clazz3 = class$java$io$File = SedonaBundle.class("[Ljava.io.File;", false);
            }
            zipEntry = new Array(clazz3);
            object = new CopyWalker((Array)zipEntry);
            CopyUtil.walk(this.getSedonaHome(), (CopyUtil.WalkVisitor)object);
            this.toCopy = (File[])zipEntry.trim();
            n += this.toCopy.length;
        }
        this.model.installProgress.setMax((double)n);
        this.mkdirs(tempDir);
        this.mkdirs(backupDir);
        this.mkdirs(stageDir);
    }

    private final void migrate() throws Exception {
        if (!this.model.migrateEnv.isSelected()) {
            return;
        }
        int n = (int)this.model.installProgress.getValue();
        int n2 = this.getSedonaHome().getCanonicalPath().length() + 1;
        int n3 = 0;
        while (n3 < this.toCopy.length) {
            File file = this.toCopy[n3];
            File file2 = new File(bajaSedonaHome, file.getParentFile().getCanonicalPath().substring(n2));
            this.updateProgress("Migrating file: " + file.getName(), ++n);
            CopyUtil.copyFile(file, new File(file2, file.getName()));
            ++n3;
        }
    }

    private final void extract(ZipEntry[] zipEntryArray) throws Exception {
        int n = (int)this.model.installProgress.getValue();
        ZipFile zipFile = new ZipFile(this.bundleFile);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (n2 < zipEntryArray.length) {
            ZipEntry zipEntry = zipEntryArray[n2];
            this.updateProgress("Extract: " + zipEntry.getName(), ++n);
            byteArrayOutputStream.reset();
            FileUtil.pipe((InputStream)zipFile.getInputStream(zipEntry), (OutputStream)byteArrayOutputStream);
            this.writeEntry(zipEntry, byteArrayOutputStream);
            ++n2;
        }
        zipFile.close();
    }

    private final void commitSedonaEnv() throws Exception {
        Class clazz = class$java$io$File;
        if (clazz == null) {
            clazz = class$java$io$File = SedonaBundle.class("[Ljava.io.File;", false);
        }
        Array array = new Array(clazz);
        CopyWalker copyWalker = new CopyWalker(array, stageSed);
        CopyUtil.walk(stageSed, copyWalker);
        File[] fileArray = (File[])array.trim();
        int n = stageSed.getCanonicalPath().length() + 1;
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file = fileArray[n2];
            String string = file.getParentFile().getCanonicalPath().substring(n);
            File file2 = new File(bajaSedonaHome, string);
            File file3 = new File(file2, file.getName());
            if (file3.exists() && !file3.delete()) {
                throw new Exception("Failed to delete existing file: " + file3.getCanonicalPath());
            }
            this.updateProgress("Install: " + file3);
            CopyUtil.copy(file, file3);
            ++n2;
        }
    }

    private final void commitModules() throws Exception {
        block8: {
            File file = new File(Sys.getBajaHome(), "modules");
            try {
                File[] fileArray = stageModules.exists() && stageModules.isDirectory() ? stageModules.listFiles() : new File[]{};
                int n = 0;
                while (n < fileArray.length) {
                    this.updateProgress("Install module: " + fileArray[n].getName());
                    File file2 = fileArray[n];
                    File file3 = new File(file, file2.getName());
                    if (file3.exists()) {
                        NModule nModule = Nre.moduleManager.loadModule(FileUtil.getBase((String)file3.getName()));
                        nModule.getZipFile().close();
                        if (!file3.renameTo(new File(backupDir, file3.getName()))) {
                            throw new Exception("Could not backup: " + file3.getName() + ". It's probably open by another process.");
                        }
                    }
                    CopyUtil.copy(file2, file3);
                    ++n;
                }
                this.updateSystemProperties();
                break block8;
            }
            catch (Exception exception) {
                try {
                    File[] fileArray = backupDir.listFiles();
                    int n = 0;
                    while (n < fileArray.length) {
                        CopyUtil.copyFile(fileArray[n], new File(file, fileArray[n].getName()));
                        ++n;
                    }
                }
                catch (Exception exception2) {}
            }
            throw exception;
        }
    }

    private final void updateSystemProperties() throws Exception {
        File file = new File(new File(Sys.getBajaHome(), "lib"), "system.properties");
        File file2 = null;
        try {
            String[] stringArray = FileUtil.readLines((File)file);
            file2 = FileUtil.renameToBackup((File)file);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            boolean bl = false;
            int n = 0;
            while (n < stringArray.length) {
                if (!stringArray[n].trim().startsWith("sedona.home")) {
                    printWriter.println(stringArray[n]);
                }
                ++n;
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            if (file2 != null) {
                FileUtil.move((File)file2, (File)file);
            }
            throw exception;
        }
    }

    public static boolean isImportAvailable() {
        try {
            Class clazz = Sys.loadClass((String)"nsedona", (String)"com.tridium.nsedona.env.ImportUtil");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private final void updateProgress(String string) {
        this.updateProgress(string, this.model.installProgress.getValue());
    }

    private final void updateProgress(String string, double d) {
        if (string != null) {
            this.model.info.setText(string);
        }
        this.model.installProgress.setValue(d);
    }

    private final void mkdirs(File file) throws Exception {
        if (file.exists() && file.isDirectory()) {
            return;
        }
        if (!file.mkdirs()) {
            throw new Exception("Cannot make directory: " + file.getAbsolutePath());
        }
    }

    public File getSedonaHome() {
        String string = this.model.bajaSysProps.getProperty("sedona.home", null);
        return string == null ? new File(Sys.getBajaHome(), "sedona") : new File(string);
    }

    public boolean isPre12Installed() {
        File file = this.getSedonaHome();
        boolean bl = false;
        if (file.exists() && !file.equals(bajaSedonaHome)) {
            bl = true;
        }
        return bl;
    }

    private final boolean isSedonaEnvFile(ZipEntry zipEntry) {
        boolean bl = false;
        if (this.isKit(zipEntry) || this.isManifest(zipEntry) || this.isPar(zipEntry)) {
            bl = true;
        }
        return bl;
    }

    private final boolean isKit(ZipEntry zipEntry) {
        boolean bl = false;
        if (!zipEntry.isDirectory() && this.relativizeName(zipEntry).startsWith("sedona/kits/")) {
            bl = true;
        }
        return bl;
    }

    private final boolean isManifest(ZipEntry zipEntry) {
        boolean bl = false;
        if (!zipEntry.isDirectory() && this.relativizeName(zipEntry).startsWith("sedona/manifests/")) {
            bl = true;
        }
        return bl;
    }

    private final boolean isPar(ZipEntry zipEntry) {
        boolean bl = false;
        if (!zipEntry.isDirectory() && this.relativizeName(zipEntry).startsWith("sedona/platforms/db/")) {
            bl = true;
        }
        return bl;
    }

    private final void writeEntry(ZipEntry zipEntry, ByteArrayOutputStream byteArrayOutputStream) throws Exception {
        Object object;
        String string = this.relativizeName(zipEntry);
        if (string.startsWith("overlay/")) {
            string = string.substring("overlay/".length());
        }
        if (string.endsWith("/") || zipEntry.isDirectory()) {
            this.mkdirs(new File(stageDir, string));
            return;
        }
        int n = string.lastIndexOf(47);
        if (n > 0) {
            object = string.substring(0, n);
            this.mkdirs(new File(stageDir, (String)object));
        }
        object = new File(stageDir, string);
        FileOutputStream fileOutputStream = new FileOutputStream((File)object);
        byteArrayOutputStream.writeTo(fileOutputStream);
        fileOutputStream.close();
        ((File)object).setLastModified(zipEntry.getTime());
    }

    private final String relativizeName(ZipEntry zipEntry) {
        String string = zipEntry.getName();
        return string.charAt(0) == '/' ? string.substring(1) : string;
    }

    public boolean verify() {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.bundleFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String string = this.relativizeName(zipEntry);
                if (licenseZipPath.equals(string)) {
                    this.extractLicense(zipFile, zipEntry);
                }
                this.hasOpensource |= string.startsWith("sedona/");
                if (!string.startsWith("modules/")) continue;
                this.hasModules |= true;
                this.requiresLicense |= string.equals(sedonaZipPath);
                this.requiresLicense |= string.equals(sedonacZipPath);
                this.verifyModule(zipFile, zipEntry);
            }
            if (this.hasModules && zipFile.getEntry("modules/baja.jar") != null) {
                throw new Exception("cannot install baja.jar");
            }
            if (!this.hasModules && !this.hasOpensource) {
                throw new Exception("Bundle contains nothing to install");
            }
            if (this.requiresLicense && this.licenseText == null) {
                throw new Exception("Invalid TXS Bundle");
            }
            zipFile.close();
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this.model.getWizard().getOwner(), (String)"Bundle Error", (Object)"Invalid Sedona Bundle", (String)exception.getMessage());
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private final void extractLicense(ZipFile var1_1, ZipEntry var2_2) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 57->61)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void verifyModule(ZipFile zipFile, ZipEntry zipEntry) throws Exception {
        XElem xElem = this.getModuleXml(zipFile, zipEntry);
        if (xElem == null) {
            throw new Exception("Could not find module.xml for " + zipEntry.getName());
        }
        if (nsedonaZipPath.equals(zipEntry.getName())) {
            this.checkBajaDependency(xElem);
        }
        this.checkForModuleDowngrade(xElem);
    }

    private final XElem getModuleXml(ZipFile zipFile, ZipEntry zipEntry) throws Exception {
        ZipEntry zipEntry2;
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtil.pipe((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        ZipInputStream zipInputStream = new ZipInputStream(byteArrayInputStream);
        XElem xElem = null;
        while ((zipEntry2 = zipInputStream.getNextEntry()) != null && xElem == null) {
            if ("meta-inf/module.xml".equalsIgnoreCase(zipEntry2.getName())) {
                xElem = XParser.make((InputStream)zipInputStream).parse(false);
            }
            zipInputStream.closeEntry();
        }
        return xElem;
    }

    private final void checkForModuleDowngrade(XElem xElem) {
        String string = xElem.get("name");
        Version version = new Version(xElem.get("vendorVersion"));
        try {
            ModuleInfo moduleInfo = Sys.getRegistry().getModule(string);
            if (version.compareTo((Object)moduleInfo.getVendorVersion()) < 0) {
                this.warnDowngrade |= true;
                this.downgrades.append("Downgrades ").append(string).append(" from ").append(moduleInfo.getVendorVersion()).append(" to ").append(version).append('\n');
            }
        }
        catch (ModuleNotFoundException moduleNotFoundException) {}
    }

    private final void checkBajaDependency(XElem xElem) throws Exception {
        XElem xElem2 = xElem.elem("dependencies");
        if (xElem2 == null) {
            throw new Exception("Invalid module.xml for nsedona.jar. No dependencies");
        }
        XElem[] xElemArray = xElem2.elems("dependency");
        int n = 0;
        while (n < xElemArray.length) {
            XElem xElem3 = xElemArray[n];
            if ("baja".equals(xElem3.get("name"))) {
                Version version = new Version(xElem3.get("vendorVersion"));
                Version version2 = Sys.getBajaModule().getVendorVersion();
                if (version2.compareTo((Object)version) < 0) {
                    throw new Exception("TXS bundle depends on baja " + version + ", but only " + version2 + " is installed");
                }
                return;
            }
            ++n;
        }
        throw new Exception("Could not verify baja dependency");
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hasOpensource = false;
        this.hasModules = false;
        this.requiresLicense = false;
        this.licenseText = null;
        this.warnDowngrade = false;
        this.downgrades = new StringBuffer();
        this.toInstall = new ZipEntry[0];
        this.toOverlay = new ZipEntry[0];
        this.toCopy = new File[0];
    }

    SedonaBundle(SedonaInstallerWizardModel sedonaInstallerWizardModel) {
        this.this();
        this.model = sedonaInstallerWizardModel;
        this.bundleOrd = BOrd.make((String)sedonaInstallerWizardModel.bundleTextField.getText());
        this.bundleFile = BFileSystem.INSTANCE.pathToLocalFile(((BIFile)this.bundleOrd.get()).getFilePath());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CopyWalker
    implements CopyUtil.WalkVisitor {
        final File croot;
        final Set walkRoots;
        final Array arr;

        public void visit(File file) {
            if (file.isFile() && this.isWalkable(file.getParentFile())) {
                this.arr.add((Object)file);
            }
        }

        public boolean isWalkable(File file) {
            if (!file.isDirectory()) {
                return false;
            }
            try {
                file = file.getCanonicalFile();
                while (file != null && !file.equals(this.croot)) {
                    if (this.walkRoots.contains(file)) {
                        return true;
                    }
                    file = file.getParentFile().getCanonicalFile();
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }

        private final /* synthetic */ void this() {
            this.walkRoots = new HashSet();
        }

        public CopyWalker(Array array) throws Exception {
            this(array, sedonaBundle.getSedonaHome().getCanonicalFile());
        }

        public CopyWalker(Array array, File file) throws Exception {
            this.this();
            this.arr = array;
            this.croot = file;
            this.walkRoots.add(new File(this.croot, "kits"));
            this.walkRoots.add(new File(this.croot, "manifests"));
            this.walkRoots.add(new File(this.croot, "platforms"));
        }
    }
}

