/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XParser;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.CompilerStep;
import sedonac.Location;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CheckHtmlLinks
extends CompilerStep {
    File dir;
    HashMap byName;
    Html[] htmls;

    public void run() {
        this.dir = this.compiler.input.getParentFile();
        try {
            this.log.info("  CheckHtmlLinks [" + this.dir + ']');
            this.parseFiles();
            this.mapIds();
            this.checkLinks();
            this.quitIfErrors();
        }
        catch (XException xException) {
            throw this.err(xException);
        }
        catch (CompilerException compilerException) {
            throw compilerException;
        }
        catch (Exception exception) {
            throw this.err("Cannot check html links", new Location(this.dir), (Throwable)exception);
        }
    }

    private final void parseFiles() {
        File[] fileArray = this.dir.listFiles();
        ArrayList<Html> arrayList = new ArrayList<Html>();
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            String string = file.getName().toLowerCase();
            if (string.endsWith(".html") && !string.equals("api.html")) {
                this.log.debug("    Parse [" + file + ']');
                XElem xElem = this.parseFile(file);
                if (xElem != null) {
                    Html html = new Html();
                    html.file = file;
                    html.xml = xElem;
                    arrayList.add(html);
                    this.byName.put(file.getName(), html);
                }
            }
            ++n;
        }
        this.htmls = arrayList.toArray(new Html[arrayList.size()]);
    }

    private final XElem parseFile(File file) {
        Object var2_2 = null;
        try {
            return XParser.make((File)file).parse();
        }
        catch (XException xException) {
            this.err(xException);
            return null;
        }
        catch (Exception exception) {
            this.err("Cannot parse HTML", new Location(file), (Throwable)exception);
            return null;
        }
    }

    private final void mapIds() {
        int n = 0;
        while (n < this.htmls.length) {
            this.mapIds(this.htmls[n], this.htmls[n].xml);
            ++n;
        }
    }

    private final void mapIds(Html html, XElem xElem) {
        XElem xElem2;
        String string = xElem.get("id", null);
        if (string != null && (xElem2 = html.ids.put(string, xElem)) != null) {
            this.err("Duplicate id '" + string + "' (line " + xElem2.line() + ')', new Location(xElem));
        }
        xElem2 = xElem.elems();
        int n = 0;
        while (n < ((XElem)xElem2).length) {
            this.mapIds(html, xElem2[n]);
            ++n;
        }
    }

    private final void checkLinks() {
        int n = 0;
        while (n < this.htmls.length) {
            this.checkLinks(this.htmls[n], this.htmls[n].xml);
            ++n;
        }
    }

    private final void checkLinks(Html html, XElem xElem) {
        String string = xElem.get("href", null);
        if (string != null) {
            this.checkLink(html, xElem, string);
        }
        XElem[] xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            this.checkLinks(html, xElemArray[n]);
            ++n;
        }
    }

    private final void checkLink(Html html, XElem xElem, String string) {
        File file;
        Html html2;
        String string2 = string;
        String string3 = null;
        if (string.startsWith("http:")) {
            return;
        }
        int n = string.indexOf(35);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if (string2.equals("")) {
            string2 = html.file.getName();
        }
        if ((html2 = (Html)this.byName.get(string2)) == null) {
            file = new File(this.dir, string2);
            if (!file.exists()) {
                file = new File(this.compiler.outDir, string2);
                if (!file.exists()) {
                    if (string2.startsWith("../")) {
                        this.warn("Cannot resolve relateive href target '" + string + '\'', new Location(xElem));
                    } else {
                        this.err("Unknown href target '" + string + '\'', new Location(xElem));
                    }
                }
                return;
            }
            try {
                if (!string2.endsWith(file.getCanonicalFile().getName())) {
                    this.err("Invalid case for href target '" + string + '\'', new Location(xElem));
                    return;
                }
            }
            catch (Exception exception) {
                this.err("Internal error '" + string + '\'', new Location(xElem));
                exception.printStackTrace();
            }
        }
        if (string3 != null && html2 != null && (file = (XElem)html2.ids.get(string3)) == null) {
            this.err("Unknown href target '" + string + '\'', new Location(xElem));
            return;
        }
    }

    private final /* synthetic */ void this() {
        this.byName = new HashMap();
    }

    public CheckHtmlLinks(Compiler compiler) {
        super(compiler);
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Html {
        File file;
        XElem xml;
        HashMap ids;

        private final /* synthetic */ void this() {
            this.ids = new HashMap();
        }

        Html() {
            this.this();
        }
    }
}

