/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.Expr;
import sedonac.ast.MethodDef;
import sedonac.ast.TypeDef;
import sedonac.namespace.Method;

public class InstanceInit
extends CompilerStep {
    public void run() {
        this.log.debug("  InstanceInit");
        this.walkAst(1);
        this.quitIfErrors();
    }

    public void enterType(TypeDef typeDef) {
        super.enterType(typeDef);
        MethodDef methodDef = typeDef.makeInstanceInit(this.ns);
        Location location = methodDef.loc;
        if (typeDef.base != null && !typeDef.base.isObj()) {
            Method method = (Method)typeDef.base.slot("_iInit");
            if (method == null) {
                throw new IllegalStateException(typeDef.base.qname());
            }
            Expr.Call call = new Expr.Call(location, (Expr)new Expr.Super(location), method, new Expr[0]);
            methodDef.code.add(methodDef.initStmtIndex++, call.toStmt());
        }
        if (typeDef.isaVirtual()) {
            methodDef.code.add(methodDef.initStmtIndex++, new Expr.InitVirt(location, typeDef).toStmt());
        }
        if (typeDef.isaComponent()) {
            methodDef.code.add(methodDef.initStmtIndex++, new Expr.InitComp(location, typeDef).toStmt());
        }
    }

    public InstanceInit(Compiler compiler) {
        super(compiler);
    }
}

