/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.IOException;
import sedona.util.FileUtil;
import sedona.xml.XException;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.Location;
import sedonac.steps.InitImageCompile;

public class StageNatives
extends InitImageCompile {
    File stageDir;

    public void run() {
        try {
            this.log.info("  StageVM [" + this.stageDir + ']');
            this.copySourceFiles();
        }
        catch (XException xException) {
            throw this.err(xException);
        }
        catch (CompilerException compilerException) {
            throw compilerException;
        }
        catch (Exception exception) {
            throw this.err("Cannot stage VM", new Location(this.stageDir), (Throwable)exception);
        }
    }

    public void copySourceFiles() {
        if (this.compiler.platform.nativeFiles == null) {
            throw this.err("Must have at least one <nativeSource> element", new Location(this.xml));
        }
        String[] stringArray = this.compiler.platform.nativeFiles;
        int n = 0;
        while (n < stringArray.length) {
            this.copySourceFile(stringArray[n]);
            ++n;
        }
    }

    public void copySourceFile(String string) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            this.warn("Source file not found '" + file + '\'');
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        try {
            FileUtil.copyFile((File)file, (File)new File(this.stageDir, file.getName()));
        }
        catch (IOException iOException) {
            throw this.err("Cannot copy file", new Location(file), (Throwable)iOException);
        }
    }

    public StageNatives(Compiler compiler) {
        super(compiler);
        this.xmlFile = compiler.input;
        this.xmlDir = this.xmlFile.getParentFile();
        this.xml = compiler.xml;
        this.stageDir = compiler.outDir;
    }
}

