/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sedona.KitPart;
import sedona.kit.KitDb;
import sedona.manifest.KitManifest;
import sedona.manifest.ManifestDb;
import sedona.util.FileUtil;
import sedona.util.Version;
import sedona.xml.XWriter;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.SourceFile;
import sedonac.ir.IrKit;
import sedonac.ir.IrType;
import sedonac.ir.IrWriter;

public class WriteKit
extends CompilerStep {
    public void run() {
        this.writeKit();
        this.writeManifest();
    }

    private final void writeKit() {
        IrKit irKit = this.compiler.ir;
        KitManifest kitManifest = this.compiler.manifest;
        File file = KitDb.toFile((String)irKit.name, (int)kitManifest.checksum, (Version)kitManifest.version);
        File file2 = file.getParentFile();
        if (this.compiler.outDir != null) {
            file2 = new File(new File(this.compiler.outDir, "kits"), file.getParentFile().getName());
            file = new File(file2, file.getName());
        }
        this.log.info("  WriteKit [" + file + ']');
        try {
            file2.mkdirs();
            ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            this.writeManifest(zipOutputStream, irKit);
            int n = 0;
            while (n < irKit.types.length) {
                this.writeType(zipOutputStream, irKit.types[n]);
                ++n;
            }
            if (this.compiler.ast.includeSource) {
                this.writeSource(zipOutputStream);
            }
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw this.err("Cannot write kit file", new Location(file));
        }
    }

    private final void writeManifest(ZipOutputStream zipOutputStream, IrKit irKit) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry("manifest.xml"));
        XWriter xWriter = new XWriter((OutputStream)zipOutputStream);
        this.compiler.manifest.encodeXml(xWriter);
        xWriter.flush();
        zipOutputStream.closeEntry();
    }

    private final void writeType(ZipOutputStream zipOutputStream, IrType irType) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry(irType.name + ".ir"));
        IrWriter irWriter = new IrWriter(zipOutputStream);
        irWriter.writeType(irType);
        irWriter.flush();
        zipOutputStream.closeEntry();
    }

    private final void writeSource(ZipOutputStream zipOutputStream) throws Exception {
        SourceFile sourceFile = new SourceFile();
        sourceFile.file = this.compiler.input;
        this.writeSource(zipOutputStream, sourceFile);
        SourceFile[] sourceFileArray = this.compiler.sourceFiles;
        int n = 0;
        while (n < sourceFileArray.length) {
            this.writeSource(zipOutputStream, sourceFileArray[n]);
            ++n;
        }
    }

    private final void writeSource(ZipOutputStream zipOutputStream, SourceFile sourceFile) throws IOException {
        String string = this.compiler.input.getParentFile().getCanonicalPath();
        String string2 = sourceFile.file.getCanonicalPath();
        String string3 = string2.substring(string.length() + 1);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(sourceFile.file));
        zipOutputStream.putNextEntry(new ZipEntry("source/" + string3));
        FileUtil.pipe((InputStream)bufferedInputStream, (OutputStream)zipOutputStream);
        ((InputStream)bufferedInputStream).close();
        zipOutputStream.closeEntry();
    }

    private final void writeManifest() {
        File file;
        KitManifest kitManifest = this.compiler.manifest;
        KitPart kitPart = new KitPart(kitManifest.name, kitManifest.checksum);
        File file2 = ManifestDb.toFile((KitPart)kitPart);
        if (this.compiler.outDir != null) {
            file2 = new File(new File(new File(this.compiler.outDir, "manifests"), kitPart.name), file2.getName());
            file = file2.getParentFile();
        }
        this.log.info("  WriteManifest [" + file2 + ']');
        file2.getParentFile().mkdirs();
        try {
            file = new XWriter(file2);
            kitManifest.encodeXml((XWriter)file);
            file.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw this.err("Cannot write kit manifest", new Location(file2));
        }
    }

    public WriteKit(Compiler compiler) {
        super(compiler);
    }
}

