/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonaProvisioning.tooltasks;

import com.tridium.nsedona.env.KitDb;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.ProvTask;
import com.tridium.sedonaProvisioning.tooltasks.TransferFiles;
import java.io.File;
import java.io.InputStream;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import sedona.Buf;
import sedona.Depend;
import sedona.Env;
import sedona.platform.PlatformDbException;
import sedona.platform.PlatformManifest;
import sedona.util.Version;
import sedona.xml.XElem;
import sedona.xml.XParser;
import sedona.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BuildScode
implements ProvTask {
    static final String nameAttr = "kits";
    static final String mainAttr = "sys::Sys.main";
    KitDb.KitSummary[] kits;
    TransferFiles transferTask;
    Array depends;
    static /* synthetic */ Class class$sedona$Depend;
    static /* synthetic */ Class class$com$tridium$sedonaProvisioning$tooltasks$SaveApp;

    public String getSummary() {
        Class clazz = class$com$tridium$sedonaProvisioning$tooltasks$SaveApp;
        if (clazz == null) {
            clazz = class$com$tridium$sedonaProvisioning$tooltasks$SaveApp = BuildScode.class("[Lcom.tridium.sedonaProvisioning.tooltasks.SaveApp;", false);
        }
        Lexicon lexicon = Lexicon.make((Class)clazz);
        return lexicon.getText("buildScode.summary");
    }

    public void execute(ProvCx provCx) throws Exception {
        provCx.log(this.getSummary());
        PlatformManifest platformManifest = provCx.session().getPlatformManifest();
        if (platformManifest == null) {
            String string = provCx.session().getVersionInfo().platformId;
            provCx.log("Cannot compile scode.");
            provCx.log("  Missing platform manifest for: " + string + '\n');
            throw new PlatformDbException(string + " is not in the platform database");
        }
        if (this.kits == null) {
            throw new IllegalStateException("no kits to install");
        }
        int n = 0;
        while (n < this.kits.length) {
            KitDb.KitSummary kitSummary = this.kits[n];
            Depend depend = Depend.parse((String)(kitSummary.name() + ' ' + kitSummary.version() + "=, 0x" + Integer.toHexString(kitSummary.checksum())));
            this.depends.add((Object)depend);
            ++n;
        }
        provCx.log(null, -1.0);
        File file = provCx.buildScode(this.writeScodeXml(platformManifest, provCx));
        this.transferTask.register(file, "kits.scode");
        provCx.log("", 100.0);
    }

    private final XElem writeScodeXml(PlatformManifest platformManifest, ProvCx provCx) throws Exception {
        Buf buf = new Buf();
        XWriter xWriter = new XWriter(buf.getOutputStream());
        boolean bl = platformManifest.debug;
        boolean bl2 = platformManifest.test;
        provCx.log("  debug = " + bl);
        provCx.log("  test  = " + bl2);
        xWriter.w((Object)"<sedonaCode").nl();
        if (new Version(Env.version).compareTo((Object)new Version("1.0.48")) <= 0) {
            xWriter.w((Object)"  ").attr("name", nameAttr).nl();
        }
        xWriter.w((Object)"  ").attr("endian", platformManifest.endian).nl();
        xWriter.w((Object)"  ").attr("armDouble", platformManifest.armDouble).nl();
        xWriter.w((Object)"  ").attr("blockSize", platformManifest.blockSize).nl();
        xWriter.w((Object)"  ").attr("refSize", platformManifest.refSize).nl();
        xWriter.w((Object)"  ").attr("main", mainAttr).nl();
        xWriter.w((Object)"  ").attr("debug", bl).nl();
        xWriter.w((Object)"  ").attr("test", bl2).nl();
        xWriter.w((Object)">").nl();
        provCx.log("  Dependencies [" + this.depends.size() + " kits]");
        int n = 0;
        while (n < this.depends.size()) {
            Depend depend = (Depend)this.depends.get(n);
            provCx.log("    " + depend);
            depend.encodeXml(xWriter);
            ++n;
        }
        xWriter.w((Object)"</sedonaCode>").nl();
        xWriter.close();
        buf.seek(0);
        XElem xElem = XParser.make((String)"scodeDef", (InputStream)buf.getInputStream()).parse();
        xElem.addAttr("__platformId__", platformManifest.id);
        return xElem;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$sedona$Depend;
        if (clazz == null) {
            clazz = class$sedona$Depend = BuildScode.class("[Lsedona.Depend;", false);
        }
        this.depends = new Array(clazz);
    }

    public BuildScode(KitDb.KitSummary[] kitSummaryArray, TransferFiles transferFiles) {
        this.this();
        this.kits = kitSummaryArray;
        this.transferTask = transferFiles;
    }
}

