/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonaProvisioning.ui.util;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.nav.BFileMenuAgent;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.transfer.TransferUtil;
import java.text.DecimalFormat;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.space.Mark;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.Subject;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.commands.RenameCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.SortUtil;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BDirTable
extends BTable
implements NavListener {
    public static final Type TYPE;
    static final BImage defaultIcon;
    static DecimalFormat sizeFormat;
    static final BBrush cutFg;
    static final int COL_NAME = 0;
    static final int COL_TYPE = 1;
    static final int COL_SIZE = 2;
    static final int COL_MODIFIED = 3;
    final UiLexicon lex;
    final String LEX_NAME;
    final String LEX_TYPE;
    final String LEX_SIZE;
    final String LEX_MODIFIED;
    boolean enableEdits;
    BIDirectory dir;
    Context context;
    boolean isSpace;
    BOrd dirOrd;
    boolean dropActive;
    Row[] rows;
    Row[] origRowOrder;
    BIFile copyFrom;
    static /* synthetic */ Class class$com$tridium$sedonaProvisioning$ui$util$BDirTable;

    public Type getType() {
        return TYPE;
    }

    public void load(BIDirectory bIDirectory, Context context) {
        boolean bl = false;
        if (this.dir == null) {
            bl = true;
        }
        boolean bl2 = bl;
        this.enableEdits = false;
        if (bIDirectory instanceof BDirectory) {
            this.enableEdits = ((BDirectory)bIDirectory).isReadonly() ^ true;
        }
        BIFile[] bIFileArray = bIDirectory.listFiles();
        Row[] rowArray = new Row[bIFileArray.length];
        int n = 0;
        while (n < rowArray.length) {
            rowArray[n] = new Row(bIFileArray[n], context);
            ++n;
        }
        this.dir = bIDirectory;
        this.context = context;
        this.isSpace = bIDirectory instanceof BFileSpace;
        this.dirOrd = bIDirectory.getNavOrd();
        this.rows = rowArray;
        this.origRowOrder = (Row[])rowArray.clone();
        if (bl2) {
            this.sortByColumn(0, true);
        }
        this.sizeColumnsToFit();
        this.fireTableModified(new BWidgetEvent(1, (BWidget)this));
        this.updateTransferCommands();
    }

    public void refresh() {
        BIFile[] bIFileArray = this.dir.listFiles();
        Row[] rowArray = new Row[bIFileArray.length];
        Row[] rowArray2 = this.rows;
        int n = 0;
        int n2 = 0;
        while (n2 < bIFileArray.length) {
            String string = bIFileArray[n2].getFileName();
            int n3 = 0;
            while (n3 < rowArray2.length) {
                if (string.equals(rowArray2[n3].file.getFileName())) {
                    bIFileArray[n2] = null;
                    rowArray[n++] = rowArray2[n3];
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        n2 = n;
        int n4 = 0;
        while (n4 < bIFileArray.length) {
            if (bIFileArray[n4] != null) {
                rowArray[n++] = new Row(bIFileArray[n4], this.context);
            }
            ++n4;
        }
        this.rows = rowArray;
        this.getSelection().deselectAll();
        if (n2 < rowArray.length) {
            this.getSelection().select(n2, this.rows.length - 1);
        }
        this.sizeColumnsToFit();
        this.fireTableModified(new BWidgetEvent(1, (BWidget)this));
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
    }

    public void navEvent(NavEvent navEvent) {
        if (this.dirOrd != null && this.dirOrd.equals((Object)navEvent.getParentOrd())) {
            this.refresh();
        }
    }

    public BWbShell getWbShell() {
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell instanceof BWbShell) {
            return (BWbShell)bWidgetShell;
        }
        return null;
    }

    public BIFile getSelectedFile() {
        int n = this.getSelection().getRow();
        if (n == -1) {
            return null;
        }
        return this.rows[n].file;
    }

    public BIFile[] getSelectedFiles() {
        int[] nArray = this.getSelection().getRows();
        BIFile[] bIFileArray = new BIFile[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            bIFileArray[n] = this.rows[nArray[n]].file;
            ++n;
        }
        return bIFileArray;
    }

    public Mark getSelectedFilesAsMark() {
        if (this.dir == null) {
            return null;
        }
        BIFile[] bIFileArray = this.getSelectedFiles();
        if (bIFileArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[bIFileArray.length];
        BObject[] bObjectArray = new BObject[bIFileArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = bIFileArray[n].getFileName();
            bObjectArray[n] = (BObject)bIFileArray[n];
            ++n;
        }
        return new Mark(bObjectArray, stringArray);
    }

    public void updateTransferCommands() {
        BIFile[] bIFileArray = this.getSelectedFiles();
        int n = bIFileArray.length;
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (bIFileArray[n2].isReadonly()) {
                bl = false;
                break;
            }
            ++n2;
        }
        boolean bl2 = false;
        if (n > 0 && bl && this.enableEdits) {
            bl2 = true;
        }
        this.setCutEnabled(bl2);
        boolean bl3 = false;
        if (n > 0) {
            bl3 = true;
        }
        this.setCopyEnabled(bl3);
        this.setPasteEnabled(this.enableEdits);
        boolean bl4 = false;
        if (n > 0 && this.enableEdits) {
            bl4 = true;
        }
        this.setDuplicateEnabled(bl4);
        boolean bl5 = false;
        if (n > 0 && bl && this.enableEdits) {
            bl5 = true;
        }
        this.setDeleteEnabled(bl5);
        boolean bl6 = false;
        if (n > 0 && bl && this.enableEdits) {
            bl6 = true;
        }
        this.setRenameEnabled(bl6);
    }

    public TransferEnvelope getTransferData() throws Exception {
        if (this.copyFrom != null) {
            String[] stringArray = new String[]{this.copyFrom.getFileName()};
            BObject[] bObjectArray = new BObject[]{(BObject)this.copyFrom};
            return TransferEnvelope.make((Mark)new Mark(bObjectArray, stringArray));
        }
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)mark);
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        return TransferUtil.insert((BWidget)this, (TransferContext)transferContext, (BObject)((BObject)this.dir), null);
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        return null;
    }

    public CommandArtifact doDelete() throws Exception {
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferUtil.delete((BWidget)this, (Mark)mark);
    }

    public CommandArtifact doRename() throws Exception {
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferUtil.rename((BWidget)this, (Mark)mark);
    }

    public void mouseDragStarted(BMouseEvent bMouseEvent) {
        int[] nArray = this.getSelection().getRows();
        if (nArray.length == 0) {
            return;
        }
        int n = this.getRowAt(bMouseEvent.getY());
        boolean bl = false;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        Mark mark = this.getSelectedFilesAsMark();
        SimpleDragRenderer simpleDragRenderer = new SimpleDragRenderer(mark);
        simpleDragRenderer.font = Theme.table().getCellFont();
        this.startDrag(bMouseEvent, TransferEnvelope.make((Mark)mark), (DragRenderer)simpleDragRenderer);
    }

    public void dragEnter(TransferContext transferContext) {
        if (!this.enableEdits) {
            return;
        }
        this.dropActive = true;
        this.repaint();
    }

    public int dragOver(TransferContext transferContext) {
        if (!this.enableEdits) {
            return 0;
        }
        int n = 48;
        return n;
    }

    public void dragExit(TransferContext transferContext) {
        this.dropActive = false;
        this.repaint();
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        this.dropActive = false;
        this.repaint();
        if (!this.enableEdits) {
            return null;
        }
        return this.insertTransferData(transferContext);
    }

    public static BMenu makeDirPopup(BTransferWidget bTransferWidget, BIDirectory bIDirectory, Subject subject, boolean bl) {
        BDirectory bDirectory;
        if (subject.size() > 1) {
            return NavMenuUtil.makeMenu((BWidget)bTransferWidget, (Subject)subject);
        }
        BMenu bMenu = new BMenu();
        BIFile bIFile = (BIFile)subject.getActive();
        if (bIFile != null) {
            bDirectory = NavMenuUtil.makeViewsMenu((BWidget)bTransferWidget, (BObject)((BObject)bIFile), (BOrd)bIFile.getAbsoluteOrd());
            bMenu.add("views", (BValue)new BSubMenuItem((BMenu)bDirectory));
        }
        if (!bl) {
            bMenu.add("copy", (Command)new CopyCommand(bTransferWidget));
        } else {
            bDirectory = (BDirectory)bIDirectory;
            BMenu bMenu2 = BFileMenuAgent.makeNewMenu((BWidget)bTransferWidget, (BDirectory)bDirectory);
            if (bMenu2 != null) {
                bMenu.add("new", (BValue)new BSubMenuItem(bMenu2));
                bMenu.add("sep0", (BValue)new BSeparator());
            }
            bMenu.add("copy", (Command)new CopyCommand(bTransferWidget));
            bMenu.add("cut", (Command)new CutCommand(bTransferWidget));
            bMenu.add("paste", (Command)new PasteCommand(bTransferWidget));
            bMenu.add("duplicate", (Command)new DuplicateCommand(bTransferWidget));
            if (bTransferWidget instanceof BDirTable) {
                bMenu.add("copyFrom", ((BDirTable)bTransferWidget).makeCopyFromCommand());
            }
            bMenu.add("sep1", (BValue)new BSeparator());
            bMenu.add("delete", (Command)new DeleteCommand(bTransferWidget));
            bMenu.add("rename", (Command)new RenameCommand(bTransferWidget));
        }
        return bMenu;
    }

    Command makeCopyFromCommand() {
        return new CopyFromCommand((BTransferWidget)this);
    }

    public static BImage icon(BIcon bIcon) {
        BImage bImage = BImage.make((BIcon)bIcon);
        if (bImage == null) {
            return defaultIcon;
        }
        return bImage;
    }

    public static String size(long l) {
        if (l < 0L) {
            return "";
        }
        if (l < 1024L) {
            return "1 KB";
        }
        double d = l / 1024L;
        return sizeFormat.format(d);
    }

    public static String time(BAbsTime bAbsTime, Context context) {
        if (bAbsTime == null || bAbsTime.isNull()) {
            return "";
        }
        return bAbsTime.toString(context);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.lex = UiLexicon.bajaui();
        this.LEX_NAME = this.lex.getText("name");
        this.LEX_TYPE = this.lex.getText("type");
        this.LEX_SIZE = this.lex.getText("size");
        this.LEX_MODIFIED = this.lex.getText("modified");
        this.enableEdits = false;
        this.rows = new Row[0];
        this.copyFrom = null;
    }

    public BDirTable() {
        this.this();
        this.setModel((TableModel)new DynamicTableModel((TableModel)new Model()));
        this.setSelection(new Selection());
        this.setController(new Controller());
        this.setHeaderRenderer(new HeaderRenderer());
        this.setCellRenderer(new CellRenderer());
    }

    static {
        Class clazz = class$com$tridium$sedonaProvisioning$ui$util$BDirTable;
        if (clazz == null) {
            clazz = class$com$tridium$sedonaProvisioning$ui$util$BDirTable = BDirTable.class("[Lcom.tridium.sedonaProvisioning.ui.util.BDirTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        defaultIcon = BImage.make((String)"module://icons/x16/file.png");
        sizeFormat = new DecimalFormat("#,##0.# KB");
        cutFg = BColor.make((int)100, (int)100, (int)100).toBrush();
    }

    static class Row {
        BIFile file;
        BImage icon;
        String name;
        String type;
        String sizeString;
        String modifiedString;
        long size;
        BAbsTime modified;

        public BImage getIcon() {
            if (this.file.isPendingMove()) {
                return this.icon.getDisabledImage();
            }
            return this.icon;
        }

        public Object getSortKey(int n) {
            switch (n) {
                case 0: {
                    return new NameKey(this);
                }
                case 1: {
                    return this.type;
                }
                case 2: {
                    return new Long(this.size);
                }
                case 3: {
                    return this.modified == null ? BAbsTime.NULL : this.modified;
                }
            }
            throw new IllegalStateException();
        }

        Row(BIFile bIFile, Context context) {
            try {
                this.file = bIFile;
                this.icon = BDirTable.icon(bIFile.getNavIcon());
                this.name = bIFile.getNavDisplayName(null);
                this.type = bIFile.asObject().getType().getTypeName();
                this.size = bIFile.getSize();
                this.sizeString = BDirTable.size(this.size);
                this.modified = bIFile.getLastModified();
                this.modifiedString = BDirTable.time(this.modified, context);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CopyFromCommand
    extends Command {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public CommandArtifact doInvoke() throws Exception {
            BTransferWidget bTransferWidget = (BTransferWidget)this.getOwner();
            BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)BDirTable.this.getWbShell();
            if (bNiagaraWbShell.fileChooser == null) {
                bNiagaraWbShell.fileChooser = BFileChooser.makeOpen((BWidget)bNiagaraWbShell);
            }
            BOrd bOrd = bNiagaraWbShell.fileChooser.show();
            try {
                if (bOrd != null) {
                    BDirTable.this.copyFrom = (BIFile)bOrd.get();
                    BDirTable.this.setCopyEnabled(true);
                    bTransferWidget.doCopy();
                    bTransferWidget.doPaste();
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                BDirTable.this.copyFrom = null;
                BDirTable.this.updateTransferCommands();
                throw throwable;
            }
            {
                Object var5_6 = null;
                BDirTable.this.copyFrom = null;
                BDirTable.this.updateTransferCommands();
                return null;
            }
        }

        public CopyFromCommand(BTransferWidget bTransferWidget) {
            super((BWidget)bTransferWidget, UiLexicon.bajaui().module, "commands.copyFrom");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends TableModel {
        public int getRowCount() {
            return BDirTable.this.rows.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return BDirTable.this.LEX_NAME;
                }
                case 1: {
                    return BDirTable.this.LEX_TYPE;
                }
                case 2: {
                    return BDirTable.this.LEX_SIZE;
                }
                case 3: {
                    return BDirTable.this.LEX_MODIFIED;
                }
            }
            return "?";
        }

        public BHalign getColumnAlignment(int n) {
            if (n == 2) {
                return BHalign.right;
            }
            return BHalign.left;
        }

        public Object getSubject(int n) {
            return BDirTable.this.rows[n].file;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return BDirTable.this.rows[n].name;
                }
                case 1: {
                    return BDirTable.this.rows[n].type;
                }
                case 2: {
                    return BDirTable.this.rows[n].sizeString;
                }
                case 3: {
                    return BDirTable.this.rows[n].modifiedString;
                }
            }
            return "?";
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            if (n == 0 && BDirTable.this.dir instanceof BFileSpace) {
                BDirTable.this.rows = (Row[])BDirTable.this.origRowOrder.clone();
            } else {
                Object[] objectArray = new Object[BDirTable.this.rows.length];
                int n2 = 0;
                while (n2 < objectArray.length) {
                    objectArray[n2] = BDirTable.this.rows[n2].getSortKey(n);
                    ++n2;
                }
                SortUtil.sort((Object[])objectArray, (Object[])BDirTable.this.rows, (boolean)bl);
            }
        }

        public BImage getRowIcon(int n) {
            return BDirTable.this.rows[n].getIcon();
        }

        Model() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Selection
    extends TableSelection {
        public void updateTable() {
            super.updateTable();
            BDirTable.this.updateTransferCommands();
        }

        Selection() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Controller
    extends TableController {
        protected void handleEnter(BKeyEvent bKeyEvent) {
            bKeyEvent.consume();
            int[] nArray = this.getSelection().getRows();
            if (nArray.length == 1) {
                this.hyperlink(BDirTable.this.rows[nArray[0]].file.getNavOrd(), null);
            }
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            super.cellDoubleClicked(bMouseEvent, n, n2);
        }

        public int getTextSearchColumn() {
            return 0;
        }

        private final void hyperlink(BOrd bOrd, BMouseEvent bMouseEvent) {
            BWbShell bWbShell = BDirTable.this.getWbShell();
            if (bOrd != null && bWbShell != null) {
                HyperlinkInfo hyperlinkInfo = bMouseEvent == null ? new HyperlinkInfo(bOrd) : new HyperlinkInfo(bOrd, (BInputEvent)bMouseEvent);
                bWbShell.hyperlink(hyperlinkInfo);
            }
        }

        protected BMenu makePopup(TableSubject tableSubject) {
            return BDirTable.makeDirPopup((BTransferWidget)BDirTable.this, BDirTable.this.dir, (Subject)tableSubject, BDirTable.this.enableEdits);
        }

        Controller() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class HeaderRenderer
    extends TableHeaderRenderer {
        public BBrush getForeground(TableHeaderRenderer.Header header) {
            if (BDirTable.this.dropActive) {
                return Theme.widget().getDropOkForeground();
            }
            return super.getForeground(header);
        }

        public BBrush getBackground(TableHeaderRenderer.Header header) {
            if (BDirTable.this.dropActive) {
                return Theme.widget().getDropOkBackground();
            }
            return super.getBackground(header);
        }

        HeaderRenderer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CellRenderer
    extends TableCellRenderer {
        public BBrush getForeground(TableCellRenderer.Cell cell) {
            try {
                BIFile bIFile = BDirTable.this.rows[cell.row].file;
                if (bIFile.isPendingMove()) {
                    return cutFg;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            return super.getForeground(cell);
        }

        CellRenderer() {
        }
    }

    static class NameKey
    implements Comparable {
        Row row;

        public int compareTo(Object object) {
            Row row = this.row;
            Row row2 = ((NameKey)object).row;
            if (row.file.isDirectory()) {
                if (!row2.file.isDirectory()) {
                    return -1;
                }
                return row.name.compareToIgnoreCase(row2.name);
            }
            if (row2.file.isDirectory()) {
                return 1;
            }
            return row.name.compareToIgnoreCase(row2.name);
        }

        NameKey(Row row) {
            this.row = row;
        }
    }
}

