/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pansheet;

import com.tridium.nsedona.pan.BIPanNetwork;
import com.tridium.nsedona.pan.BPanLink;
import com.tridium.nsedona.pan.BPanNode;
import com.tridium.nsedona.pan.IPanGraph;
import com.tridium.nsedona.pan.LinkPair;
import com.tridium.pansheet.digraph.Digraph;
import com.tridium.pansheet.digraph.Edge;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PanGraph
extends Digraph
implements IPanGraph {
    public BIPanNetwork network;
    protected BPanNode root;

    public BPanNode getPanRoot() {
        return this.root;
    }

    public void setPanRoot(BPanNode bPanNode) {
        this.root = bPanNode;
        if (this.root != null) {
            this.addPanNode(this.root);
        }
    }

    public void addPanNode(BPanNode bPanNode) {
        if (bPanNode == null) {
            throw new NullPointerException("node is null");
        }
        this.addVertex(bPanNode);
    }

    public void addLink(BPanNode bPanNode, BPanNode bPanNode2, BPanLink bPanLink) {
        if (bPanNode == null) {
            throw new NullPointerException("from is null");
        }
        if (bPanNode2 == null) {
            throw new NullPointerException("to is null");
        }
        Edge edge = this.addEdge(bPanNode, bPanNode2);
        if (bPanLink == null) {
            bPanLink = new BPanLink();
            bPanLink.setIgnoreLinkData(true);
        }
        edge.edgeData = bPanLink;
        edge = this.addEdge(bPanNode2, bPanNode);
        if (edge.edgeData == null) {
            BPanLink bPanLink2 = new BPanLink();
            bPanLink2.setIgnoreLinkData(true);
            edge.edgeData = bPanLink2;
        }
    }

    public BPanNode[] nodes() {
        return this.vertices().toArray(new BPanNode[this.cardinality()]);
    }

    public LinkPair getLinkPair(BPanNode bPanNode, BPanNode bPanNode2) {
        if (!this.containsVertex(bPanNode)) {
            throw new IllegalArgumentException("'a' is not in the graph: " + bPanNode);
        }
        if (!this.containsVertex(bPanNode2)) {
            throw new IllegalArgumentException("'b' is not in the graph: " + bPanNode2);
        }
        BPanLink bPanLink = (BPanLink)this.getEdgeData(bPanNode, bPanNode2);
        BPanLink bPanLink2 = (BPanLink)this.getEdgeData(bPanNode2, bPanNode);
        return new LinkPair(bPanNode, bPanNode2, bPanLink, bPanLink2);
    }

    public void dump() {
        this.dump(System.out);
    }

    public void dump(OutputStream outputStream) {
        PrintStream printStream = new PrintStream(outputStream);
        printStream.println("PanGraph dump:");
        printStream.println("root=" + this.root);
        BPanNode[] bPanNodeArray = this.nodes();
        printStream.println("nodes:" + bPanNodeArray.length);
        int n = 0;
        while (n < bPanNodeArray.length) {
            printStream.println("  node[" + n + "]:" + bPanNodeArray[n]);
            ++n;
        }
        printStream.println("links:" + this.edges.size());
        Iterator iterator = this.edges.iterator();
        while (iterator.hasNext()) {
            printStream.println("  " + iterator.next());
        }
        this.dumpAdjacencyList("Adjacency List:", printStream);
    }

    private final /* synthetic */ void this() {
        this.network = null;
        this.root = null;
    }

    public PanGraph() {
        this.this();
    }
}

