/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pansheet.commands;

import com.tridium.pansheet.viz.BPanSheetView;
import javax.baja.gx.BTransform;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;

public abstract class ZoomCommand
extends Command {
    protected BPanSheetView ps;

    public final CommandArtifact doInvoke() throws Exception {
        double d = this.ps.getPanWidget().getScale();
        RectGeom rectGeom = this.ps.getCanvas().getViewport();
        double d2 = this.getZoomScale(d);
        if (d2 == 0.0) {
            return null;
        }
        this.ps.getPanWidget().setScale(d2);
        BTransform bTransform = BTransform.makeScale((double)d, (double)d).getInverse();
        BTransform bTransform2 = BTransform.makeScale((double)d2, (double)d2);
        Point point = bTransform.transform((IPoint)new Point(rectGeom.x, rectGeom.y), null);
        Point point2 = bTransform2.transform((IPoint)point, null);
        this.ps.getPanWidget().scrollToVisible(new RectGeom(point2.x, point2.y, rectGeom.width, rectGeom.height));
        return null;
    }

    protected abstract double getZoomScale(double var1);

    public ZoomCommand(BPanSheetView bPanSheetView, String string) {
        super((BWidget)bPanSheetView.getWbShell(), UiLexicon.bajaui.module, string);
        this.ps = bPanSheetView;
    }

    public static class ZoomResetCommand
    extends ZoomCommand {
        protected double getZoomScale(double d) {
            return 1.0;
        }

        public ZoomResetCommand(BPanSheetView bPanSheetView) {
            super(bPanSheetView, "commands.zoomReset");
        }
    }

    public static class ZoomOutCommand
    extends ZoomCommand {
        protected double getZoomScale(double d) {
            return d - 0.1;
        }

        public ZoomOutCommand(BPanSheetView bPanSheetView) {
            super(bPanSheetView, "commands.zoomOut");
        }
    }

    public static class ZoomInCommand
    extends ZoomCommand {
        protected double getZoomScale(double d) {
            return d + 0.1;
        }

        public ZoomInCommand(BPanSheetView bPanSheetView) {
            super(bPanSheetView, "commands.zoomIn");
        }
    }
}

