/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.pansheet.digraph;

import com.tridium.pansheet.digraph.Edge;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;

class Vertex {
    public Object data;
    protected LinkedHashMap predToInEdges;
    protected LinkedHashMap succToOutEdges;

    public Set getIncidentEdges() {
        Collection collection = this.predToInEdges.values();
        Collection collection2 = this.succToOutEdges.values();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (collection != null) {
            linkedHashSet.addAll(collection);
        }
        if (collection2 != null) {
            linkedHashSet.addAll(collection2);
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public Set getInEdges() {
        Collection collection = this.predToInEdges.values();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (collection != null) {
            linkedHashSet.addAll(collection);
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public Set getOutEdges() {
        Collection collection = this.succToOutEdges.values();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (collection != null) {
            linkedHashSet.addAll(collection);
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public Edge getOutEdge(Object object) {
        return (Edge)this.succToOutEdges.get(object);
    }

    public Edge getInEdge(Object object) {
        return (Edge)this.predToInEdges.get(object);
    }

    public void removeEdge(Edge edge) {
        if (this.isPredecessorOf(edge.head)) {
            this.succToOutEdges.remove(edge.head);
        } else if (this.isSuccessorOf(edge.tail)) {
            this.predToInEdges.remove(edge.tail);
        } else {
            throw new IllegalStateException(edge + " is not incident to " + this);
        }
    }

    public boolean isPredecessorOf(Object object) {
        return this.succToOutEdges.containsKey(object);
    }

    public boolean isSuccessorOf(Object object) {
        return this.predToInEdges.containsKey(object);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vertex)) {
            return false;
        }
        return this.data.equals(((Vertex)object).data);
    }

    public String toString() {
        return "V:" + this.data.toString();
    }

    public Vertex(Object object) {
        if (object == null) {
            throw new NullPointerException("null data");
        }
        this.data = object;
        this.predToInEdges = new LinkedHashMap(7);
        this.succToOutEdges = new LinkedHashMap(7);
    }
}

