/*
 * Decompiled with CFR 0.152.
 */
package sedona.manifest;

import java.util.Arrays;
import java.util.zip.CRC32;
import sedona.Facets;
import sedona.Value;
import sedona.manifest.KitManifest;
import sedona.manifest.SlotManifest;
import sedona.manifest.TypeManifest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class KitChecksum {
    CRC32 crc;

    public int compute(KitManifest kitManifest) {
        this.crc.reset();
        this.update(kitManifest);
        return (int)this.crc.getValue();
    }

    private final void update(KitManifest kitManifest) {
        this.update(kitManifest.name);
        this.update(kitManifest.types.length);
        int n = 0;
        while (n < kitManifest.types.length) {
            this.update(kitManifest.types[n]);
            ++n;
        }
    }

    private final void update(TypeManifest typeManifest) {
        this.update(typeManifest.id);
        this.update(typeManifest.name);
        this.update(typeManifest.facets);
        this.update(typeManifest.slots.length);
        this.update(typeManifest.base);
        int n = 0;
        while (n < typeManifest.slots.length) {
            this.update(typeManifest.slots[n]);
            ++n;
        }
    }

    private final void update(SlotManifest slotManifest) {
        this.update(slotManifest.declaredId);
        this.update(slotManifest.name);
        this.update(slotManifest.facets);
        this.update(slotManifest.type);
        this.update(slotManifest.flags);
        this.update(slotManifest.def);
    }

    private final void update(Facets facets) {
        Object[] objectArray = facets.keys();
        Arrays.sort(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            Value value = facets.get((String)object);
            this.update((String)object);
            this.update(value);
            ++n;
        }
    }

    private final void update(Value value) {
        if (value != null) {
            this.update(value.encodeString());
        }
    }

    private final void update(String string) {
        if (string == null) {
            string = "<<null>>";
        }
        try {
            this.crc.update(string.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    private final void update(int n) {
        this.crc.update(n >>> 24 & 0xFF);
        this.crc.update(n >>> 16 & 0xFF);
        this.crc.update(n >>> 8 & 0xFF);
        this.crc.update(n & 0xFF);
    }

    private final /* synthetic */ void this() {
        this.crc = new CRC32();
    }

    public KitChecksum() {
        this.this();
    }
}

